import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook } from '../../theme/internal';
var genWaveStyle = function genWaveStyle(token) {
  var componentCls = token.componentCls,
    colorPrimary = token.colorPrimary;
  return _defineProperty({}, componentCls, {
    position: 'absolute',
    background: 'transparent',
    pointerEvents: 'none',
    boxSizing: 'border-box',
    color: "var(--wave-color, ".concat(colorPrimary, ")"),
    boxShadow: "0 0 0 0 currentcolor",
    opacity: 0.2,
    // =================== Motion ===================
    '&.wave-motion-appear': {
      transition: ["box-shadow 0.4s ".concat(token.motionEaseOutCirc), "opacity 2s ".concat(token.motionEaseOutCirc)].join(','),
      '&-active': {
        boxShadow: "0 0 0 6px currentcolor",
        opacity: 0
      }
    }
  });
};
export default genComponentStyleHook('Wave', function (token) {
  return [genWaveStyle(token)];
});