import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode } from "vue";
import { defineComponent, shallowRef, reactive, watch, onMounted, getCurrentInstance, computed, onUnmounted, onUpdated } from 'vue';
import classNames from '../_util/classNames';
import ResizeObserver from '../vc-resize-observer';
import throttleByAnimationFrame from '../_util/throttleByAnimationFrame';
import { withInstall } from '../_util/type';
import { addObserveTarget, removeObserveTarget, getTargetRect, getFixedTop, getFixedBottom } from './utils';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import omit from '../_util/omit';
import useStyle from './style';
function getDefaultTarget() {
  return typeof window !== 'undefined' ? window : null;
}
var AffixStatus;
(function (AffixStatus) {
  AffixStatus[AffixStatus["None"] = 0] = "None";
  AffixStatus[AffixStatus["Prepare"] = 1] = "Prepare";
})(AffixStatus || (AffixStatus = {}));
// Affix
export var affixProps = function affixProps() {
  return {
    /**
     * 距离窗口顶部达到指定偏移量后触发
     */
    offsetTop: Number,
    /** 距离窗口底部达到指定偏移量后触发 */
    offsetBottom: Number,
    /** 设置 Affix 需要监听其滚动事件的元素，值为一个返回对应 DOM 元素的函数 */
    target: {
      type: Function,
      default: getDefaultTarget
    },
    prefixCls: String,
    /** 固定状态改变时触发的回调函数 */
    onChange: Function,
    onTestUpdatePosition: Function
  };
};
var Affix = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AAffix',
  inheritAttrs: false,
  props: affixProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      expose = _ref.expose,
      attrs = _ref.attrs;
    var placeholderNode = shallowRef();
    var fixedNode = shallowRef();
    var state = reactive({
      affixStyle: undefined,
      placeholderStyle: undefined,
      status: AffixStatus.None,
      lastAffix: false,
      prevTarget: null,
      timeout: null
    });
    var currentInstance = getCurrentInstance();
    var offsetTop = computed(function () {
      return props.offsetBottom === undefined && props.offsetTop === undefined ? 0 : props.offsetTop;
    });
    var offsetBottom = computed(function () {
      return props.offsetBottom;
    });
    var measure = function measure() {
      var status = state.status,
        lastAffix = state.lastAffix;
      var target = props.target;
      if (status !== AffixStatus.Prepare || !fixedNode.value || !placeholderNode.value || !target) {
        return;
      }
      var targetNode = target();
      if (!targetNode) {
        return;
      }
      var newState = {
        status: AffixStatus.None
      };
      var placeholderRect = getTargetRect(placeholderNode.value);
      if (placeholderRect.top === 0 && placeholderRect.left === 0 && placeholderRect.width === 0 && placeholderRect.height === 0) {
        return;
      }
      var targetRect = getTargetRect(targetNode);
      var fixedTop = getFixedTop(placeholderRect, targetRect, offsetTop.value);
      var fixedBottom = getFixedBottom(placeholderRect, targetRect, offsetBottom.value);
      if (placeholderRect.top === 0 && placeholderRect.left === 0 && placeholderRect.width === 0 && placeholderRect.height === 0) {
        return;
      }
      if (fixedTop !== undefined) {
        var width = "".concat(placeholderRect.width, "px");
        var height = "".concat(placeholderRect.height, "px");
        newState.affixStyle = {
          position: 'fixed',
          top: fixedTop,
          width: width,
          height: height
        };
        newState.placeholderStyle = {
          width: width,
          height: height
        };
      } else if (fixedBottom !== undefined) {
        var _width = "".concat(placeholderRect.width, "px");
        var _height = "".concat(placeholderRect.height, "px");
        newState.affixStyle = {
          position: 'fixed',
          bottom: fixedBottom,
          width: _width,
          height: _height
        };
        newState.placeholderStyle = {
          width: _width,
          height: _height
        };
      }
      newState.lastAffix = !!newState.affixStyle;
      if (lastAffix !== newState.lastAffix) {
        emit('change', newState.lastAffix);
      }
      // update state
      _extends(state, newState);
    };
    var prepareMeasure = function prepareMeasure() {
      _extends(state, {
        status: AffixStatus.Prepare,
        affixStyle: undefined,
        placeholderStyle: undefined
      });
      currentInstance.update();
      // Test if `updatePosition` called
      if (process.env.NODE_ENV === 'test') {
        emit('testUpdatePosition');
      }
    };
    var updatePosition = throttleByAnimationFrame(function () {
      prepareMeasure();
    });
    var lazyUpdatePosition = throttleByAnimationFrame(function () {
      var target = props.target;
      var affixStyle = state.affixStyle;
      // Check position change before measure to make Safari smooth
      if (target && affixStyle) {
        var targetNode = target();
        if (targetNode && placeholderNode.value) {
          var targetRect = getTargetRect(targetNode);
          var placeholderRect = getTargetRect(placeholderNode.value);
          var fixedTop = getFixedTop(placeholderRect, targetRect, offsetTop.value);
          var fixedBottom = getFixedBottom(placeholderRect, targetRect, offsetBottom.value);
          if (fixedTop !== undefined && affixStyle.top === fixedTop || fixedBottom !== undefined && affixStyle.bottom === fixedBottom) {
            return;
          }
        }
      }
      // Directly call prepare measure since it's already throttled.
      prepareMeasure();
    });
    expose({
      updatePosition: updatePosition,
      lazyUpdatePosition: lazyUpdatePosition
    });
    watch(function () {
      return props.target;
    }, function (val) {
      var newTarget = (val === null || val === void 0 ? void 0 : val()) || null;
      if (state.prevTarget !== newTarget) {
        removeObserveTarget(currentInstance);
        if (newTarget) {
          addObserveTarget(newTarget, currentInstance);
          // Mock Event object.
          updatePosition();
        }
        state.prevTarget = newTarget;
      }
    });
    watch(function () {
      return [props.offsetTop, props.offsetBottom];
    }, updatePosition);
    onMounted(function () {
      var target = props.target;
      if (target) {
        // [Legacy] Wait for parent component ref has its value.
        // We should use target as directly element instead of function which makes element check hard.
        state.timeout = setTimeout(function () {
          addObserveTarget(target(), currentInstance);
          // Mock Event object.
          updatePosition();
        });
      }
    });
    onUpdated(function () {
      measure();
    });
    onUnmounted(function () {
      clearTimeout(state.timeout);
      removeObserveTarget(currentInstance);
      updatePosition.cancel();
      // https://github.com/ant-design/ant-design/issues/22683
      lazyUpdatePosition.cancel();
    });
    var _useConfigInject = useConfigInject('affix', props),
      prefixCls = _useConfigInject.prefixCls;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames;
      var _a;
      var affixStyle = state.affixStyle,
        placeholderStyle = state.placeholderStyle;
      var className = classNames((_classNames = {}, _defineProperty(_classNames, prefixCls.value, affixStyle), _defineProperty(_classNames, hashId.value, true), _classNames));
      var restProps = omit(props, ['prefixCls', 'offsetTop', 'offsetBottom', 'target', 'onChange', 'onTestUpdatePosition']);
      return wrapSSR(_createVNode(ResizeObserver, {
        "onResize": updatePosition
      }, {
        default: function _default() {
          return [_createVNode("div", _objectSpread(_objectSpread(_objectSpread({}, restProps), attrs), {}, {
            "ref": placeholderNode
          }), [affixStyle && _createVNode("div", {
            "style": placeholderStyle,
            "aria-hidden": "true"
          }, null), _createVNode("div", {
            "class": className,
            "ref": fixedNode,
            "style": affixStyle
          }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)])])];
        }
      }));
    };
  }
});
export default withInstall(Affix);