import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent } from '../../style';
var genAlertTypeStyle = function genAlertTypeStyle(bgColor, borderColor, iconColor, token, alertCls) {
  return _defineProperty({
    backgroundColor: bgColor,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(borderColor)
  }, "".concat(alertCls, "-icon"), {
    color: iconColor
  });
};
export var genBaseStyle = function genBaseStyle(token) {
  var _extends2, _$concat, _ref2;
  var componentCls = token.componentCls,
    duration = token.motionDurationSlow,
    marginXS = token.marginXS,
    marginSM = token.marginSM,
    fontSize = token.fontSize,
    fontSizeLG = token.fontSizeLG,
    lineHeight = token.lineHeight,
    borderRadius = token.borderRadiusLG,
    motionEaseInOutCirc = token.motionEaseInOutCirc,
    alertIconSizeLG = token.alertIconSizeLG,
    colorText = token.colorText,
    paddingContentVerticalSM = token.paddingContentVerticalSM,
    alertPaddingHorizontal = token.alertPaddingHorizontal,
    paddingMD = token.paddingMD,
    paddingContentHorizontalLG = token.paddingContentHorizontalLG;
  return _ref2 = {}, _defineProperty(_ref2, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    padding: "".concat(paddingContentVerticalSM, "px ").concat(alertPaddingHorizontal, "px"),
    wordWrap: 'break-word',
    borderRadius: borderRadius
  }, _defineProperty(_extends2, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), _defineProperty(_extends2, "".concat(componentCls, "-content"), {
    flex: 1,
    minWidth: 0
  }), _defineProperty(_extends2, "".concat(componentCls, "-icon"), {
    marginInlineEnd: marginXS,
    lineHeight: 0
  }), _defineProperty(_extends2, "&-description", {
    display: 'none',
    fontSize: fontSize,
    lineHeight: lineHeight
  }), _defineProperty(_extends2, '&-message', {
    color: colorText
  }), _defineProperty(_extends2, "&".concat(componentCls, "-motion-leave"), {
    overflow: 'hidden',
    opacity: 1,
    transition: "max-height ".concat(duration, " ").concat(motionEaseInOutCirc, ", opacity ").concat(duration, " ").concat(motionEaseInOutCirc, ",\n        padding-top ").concat(duration, " ").concat(motionEaseInOutCirc, ", padding-bottom ").concat(duration, " ").concat(motionEaseInOutCirc, ",\n        margin-bottom ").concat(duration, " ").concat(motionEaseInOutCirc)
  }), _defineProperty(_extends2, "&".concat(componentCls, "-motion-leave-active"), {
    maxHeight: 0,
    marginBottom: '0 !important',
    paddingTop: 0,
    paddingBottom: 0,
    opacity: 0
  }), _extends2))), _defineProperty(_ref2, "".concat(componentCls, "-with-description"), (_$concat = {
    alignItems: 'flex-start',
    paddingInline: paddingContentHorizontalLG,
    paddingBlock: paddingMD
  }, _defineProperty(_$concat, "".concat(componentCls, "-icon"), {
    marginInlineEnd: marginSM,
    fontSize: alertIconSizeLG,
    lineHeight: 0
  }), _defineProperty(_$concat, "".concat(componentCls, "-message"), {
    display: 'block',
    marginBottom: marginXS,
    color: colorText,
    fontSize: fontSizeLG
  }), _defineProperty(_$concat, "".concat(componentCls, "-description"), {
    display: 'block'
  }), _$concat)), _defineProperty(_ref2, "".concat(componentCls, "-banner"), {
    marginBottom: 0,
    border: '0 !important',
    borderRadius: 0
  }), _ref2;
};
export var genTypeStyle = function genTypeStyle(token) {
  var componentCls = token.componentCls,
    colorSuccess = token.colorSuccess,
    colorSuccessBorder = token.colorSuccessBorder,
    colorSuccessBg = token.colorSuccessBg,
    colorWarning = token.colorWarning,
    colorWarningBorder = token.colorWarningBorder,
    colorWarningBg = token.colorWarningBg,
    colorError = token.colorError,
    colorErrorBorder = token.colorErrorBorder,
    colorErrorBg = token.colorErrorBg,
    colorInfo = token.colorInfo,
    colorInfoBorder = token.colorInfoBorder,
    colorInfoBg = token.colorInfoBg;
  return _defineProperty({}, componentCls, {
    '&-success': genAlertTypeStyle(colorSuccessBg, colorSuccessBorder, colorSuccess, token, componentCls),
    '&-info': genAlertTypeStyle(colorInfoBg, colorInfoBorder, colorInfo, token, componentCls),
    '&-warning': genAlertTypeStyle(colorWarningBg, colorWarningBorder, colorWarning, token, componentCls),
    '&-error': _extends(_extends({}, genAlertTypeStyle(colorErrorBg, colorErrorBorder, colorError, token, componentCls)), _defineProperty({}, "".concat(componentCls, "-description > pre"), {
      margin: 0,
      padding: 0
    }))
  });
};
export var genActionStyle = function genActionStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    motionDurationMid = token.motionDurationMid,
    marginXS = token.marginXS,
    fontSizeIcon = token.fontSizeIcon,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover;
  return _defineProperty({}, componentCls, (_componentCls = {}, _defineProperty(_componentCls, "&-action", {
    marginInlineStart: marginXS
  }), _defineProperty(_componentCls, "".concat(componentCls, "-close-icon"), _defineProperty({
    marginInlineStart: marginXS,
    padding: 0,
    overflow: 'hidden',
    fontSize: fontSizeIcon,
    lineHeight: "".concat(fontSizeIcon, "px"),
    backgroundColor: 'transparent',
    border: 'none',
    outline: 'none',
    cursor: 'pointer'
  }, "".concat(iconCls, "-close"), {
    color: colorIcon,
    transition: "color ".concat(motionDurationMid),
    '&:hover': {
      color: colorIconHover
    }
  })), _defineProperty(_componentCls, '&-close-text', {
    color: colorIcon,
    transition: "color ".concat(motionDurationMid),
    '&:hover': {
      color: colorIconHover
    }
  }), _componentCls));
};
export var genAlertStyle = function genAlertStyle(token) {
  return [genBaseStyle(token), genTypeStyle(token), genActionStyle(token)];
};
export default genComponentStyleHook('Alert', function (token) {
  var fontSizeHeading3 = token.fontSizeHeading3;
  var alertToken = mergeToken(token, {
    alertIconSizeLG: fontSizeHeading3,
    alertPaddingHorizontal: 12 // Fixed value here.
  });

  return [genAlertStyle(alertToken)];
});