import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";
import { defineComponent, nextTick, onBeforeUnmount, onMounted, onUpdated, reactive, ref, computed } from 'vue';
import scrollIntoView from 'scroll-into-view-if-needed';
import classNames from '../_util/classNames';
import addEventListener from '../vc-util/Dom/addEventListener';
import Affix from '../affix';
import scrollTo from '../_util/scrollTo';
import getScroll from '../_util/getScroll';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useProvideAnchor from './context';
import useStyle from './style';
import AnchorLink from './AnchorLink';
import PropTypes from '../_util/vue-types';
import devWarning from '../vc-util/devWarning';
import { arrayType } from '../_util/type';
function getDefaultContainer() {
  return window;
}
function getOffsetTop(element, container) {
  if (!element.getClientRects().length) {
    return 0;
  }
  var rect = element.getBoundingClientRect();
  if (rect.width || rect.height) {
    if (container === window) {
      container = element.ownerDocument.documentElement;
      return rect.top - container.clientTop;
    }
    return rect.top - container.getBoundingClientRect().top;
  }
  return rect.top;
}
var sharpMatcherRegx = /#([\S ]+)$/;
export var anchorProps = function anchorProps() {
  return {
    prefixCls: String,
    offsetTop: Number,
    bounds: Number,
    affix: {
      type: Boolean,
      default: true
    },
    showInkInFixed: {
      type: Boolean,
      default: false
    },
    getContainer: Function,
    wrapperClass: String,
    wrapperStyle: {
      type: Object,
      default: undefined
    },
    getCurrentAnchor: Function,
    targetOffset: Number,
    items: arrayType(),
    direction: PropTypes.oneOf(['vertical', 'horizontal']).def('vertical'),
    onChange: Function,
    onClick: Function
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AAnchor',
  inheritAttrs: false,
  props: anchorProps(),
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      attrs = _ref.attrs,
      slots = _ref.slots,
      expose = _ref.expose;
    var _a;
    var _useConfigInject = useConfigInject('anchor', props),
      prefixCls = _useConfigInject.prefixCls,
      getTargetContainer = _useConfigInject.getTargetContainer,
      direction = _useConfigInject.direction;
    var anchorDirection = computed(function () {
      var _a;
      return (_a = props.direction) !== null && _a !== void 0 ? _a : 'vertical';
    });
    if (process.env.NODE_ENV !== 'production') {
      devWarning(props.items && typeof slots.default !== 'function', 'Anchor', '`Anchor children` is deprecated. Please use `items` instead.');
    }
    if (process.env.NODE_ENV !== 'production') {
      devWarning(!(anchorDirection.value === 'horizontal' && ((_a = props.items) === null || _a === void 0 ? void 0 : _a.some(function (n) {
        return 'children' in n;
      }))), 'Anchor', '`Anchor items#children` is not supported when `Anchor` direction is horizontal.');
    }
    var spanLinkNode = ref(null);
    var anchorRef = ref();
    var state = reactive({
      links: [],
      scrollContainer: null,
      scrollEvent: null,
      animating: false
    });
    var activeLink = ref(null);
    var getContainer = computed(function () {
      var getContainer = props.getContainer;
      return getContainer || (getTargetContainer === null || getTargetContainer === void 0 ? void 0 : getTargetContainer.value) || getDefaultContainer;
    });
    // func...
    var getCurrentAnchor = function getCurrentAnchor() {
      var offsetTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var bounds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 5;
      var linkSections = [];
      var container = getContainer.value();
      state.links.forEach(function (link) {
        var sharpLinkMatch = sharpMatcherRegx.exec(link.toString());
        if (!sharpLinkMatch) {
          return;
        }
        var target = document.getElementById(sharpLinkMatch[1]);
        if (target) {
          var top = getOffsetTop(target, container);
          if (top < offsetTop + bounds) {
            linkSections.push({
              link: link,
              top: top
            });
          }
        }
      });
      if (linkSections.length) {
        var maxSection = linkSections.reduce(function (prev, curr) {
          return curr.top > prev.top ? curr : prev;
        });
        return maxSection.link;
      }
      return '';
    };
    var setCurrentActiveLink = function setCurrentActiveLink(link) {
      var getCurrentAnchor = props.getCurrentAnchor;
      if (activeLink.value === link) {
        return;
      }
      activeLink.value = typeof getCurrentAnchor === 'function' ? getCurrentAnchor(link) : link;
      emit('change', link);
    };
    var handleScrollTo = function handleScrollTo(link) {
      var offsetTop = props.offsetTop,
        targetOffset = props.targetOffset;
      setCurrentActiveLink(link);
      var sharpLinkMatch = sharpMatcherRegx.exec(link);
      if (!sharpLinkMatch) {
        return;
      }
      var targetElement = document.getElementById(sharpLinkMatch[1]);
      if (!targetElement) {
        return;
      }
      var container = getContainer.value();
      var scrollTop = getScroll(container, true);
      var eleOffsetTop = getOffsetTop(targetElement, container);
      var y = scrollTop + eleOffsetTop;
      y -= targetOffset !== undefined ? targetOffset : offsetTop || 0;
      state.animating = true;
      scrollTo(y, {
        callback: function callback() {
          state.animating = false;
        },
        getContainer: getContainer.value
      });
    };
    expose({
      scrollTo: handleScrollTo
    });
    var handleScroll = function handleScroll() {
      if (state.animating) {
        return;
      }
      var offsetTop = props.offsetTop,
        bounds = props.bounds,
        targetOffset = props.targetOffset;
      var currentActiveLink = getCurrentAnchor(targetOffset !== undefined ? targetOffset : offsetTop || 0, bounds);
      setCurrentActiveLink(currentActiveLink);
    };
    var updateInk = function updateInk() {
      var linkNode = anchorRef.value.querySelector(".".concat(prefixCls.value, "-link-title-active"));
      if (linkNode && spanLinkNode.value) {
        var horizontalAnchor = anchorDirection.value === 'horizontal';
        spanLinkNode.value.style.top = horizontalAnchor ? '' : "".concat(linkNode.offsetTop + linkNode.clientHeight / 2, "px");
        spanLinkNode.value.style.height = horizontalAnchor ? '' : "".concat(linkNode.clientHeight, "px");
        spanLinkNode.value.style.left = horizontalAnchor ? "".concat(linkNode.offsetLeft, "px") : '';
        spanLinkNode.value.style.width = horizontalAnchor ? "".concat(linkNode.clientWidth, "px") : '';
        if (horizontalAnchor) {
          scrollIntoView(linkNode, {
            scrollMode: 'if-needed',
            block: 'nearest'
          });
        }
      }
    };
    useProvideAnchor({
      registerLink: function registerLink(link) {
        if (!state.links.includes(link)) {
          state.links.push(link);
        }
      },
      unregisterLink: function unregisterLink(link) {
        var index = state.links.indexOf(link);
        if (index !== -1) {
          state.links.splice(index, 1);
        }
      },
      activeLink: activeLink,
      scrollTo: handleScrollTo,
      handleClick: function handleClick(e, info) {
        emit('click', e, info);
      },
      direction: anchorDirection
    });
    onMounted(function () {
      nextTick(function () {
        var container = getContainer.value();
        state.scrollContainer = container;
        state.scrollEvent = addEventListener(state.scrollContainer, 'scroll', handleScroll);
        handleScroll();
      });
    });
    onBeforeUnmount(function () {
      if (state.scrollEvent) {
        state.scrollEvent.remove();
      }
    });
    onUpdated(function () {
      if (state.scrollEvent) {
        var currentContainer = getContainer.value();
        if (state.scrollContainer !== currentContainer) {
          state.scrollContainer = currentContainer;
          state.scrollEvent.remove();
          state.scrollEvent = addEventListener(state.scrollContainer, 'scroll', handleScroll);
          handleScroll();
        }
      }
      updateInk();
    });
    var createNestedLink = function createNestedLink(options) {
      return Array.isArray(options) ? options.map(function (option) {
        var children = option.children,
          key = option.key,
          href = option.href,
          target = option.target,
          cls = option.class,
          style = option.style,
          title = option.title;
        return _createVNode(AnchorLink, {
          "key": key,
          "href": href,
          "target": target,
          "class": cls,
          "style": style,
          "title": title,
          "customTitleProps": option
        }, {
          default: function _default() {
            return [anchorDirection.value === 'vertical' ? createNestedLink(children) : null];
          },
          customTitle: slots.customTitle
        });
      }) : null;
    };
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames2;
      var _a;
      var offsetTop = props.offsetTop,
        affix = props.affix,
        showInkInFixed = props.showInkInFixed;
      var pre = prefixCls.value;
      var inkClass = classNames("".concat(pre, "-ink"), _defineProperty({}, "".concat(pre, "-ink-visible"), activeLink.value));
      var wrapperClass = classNames(hashId.value, props.wrapperClass, "".concat(pre, "-wrapper"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(pre, "-wrapper-horizontal"), anchorDirection.value === 'horizontal'), _defineProperty(_classNames2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classNames2));
      var anchorClass = classNames(pre, _defineProperty({}, "".concat(pre, "-fixed"), !affix && !showInkInFixed));
      var wrapperStyle = _extends({
        maxHeight: offsetTop ? "calc(100vh - ".concat(offsetTop, "px)") : '100vh'
      }, props.wrapperStyle);
      var anchorContent = _createVNode("div", {
        "class": wrapperClass,
        "style": wrapperStyle,
        "ref": anchorRef
      }, [_createVNode("div", {
        "class": anchorClass
      }, [_createVNode("span", {
        "class": inkClass,
        "ref": spanLinkNode
      }, null), Array.isArray(props.items) ? createNestedLink(props.items) : (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)])]);
      return wrapSSR(!affix ? anchorContent : _createVNode(Affix, _objectSpread(_objectSpread({}, attrs), {}, {
        "offsetTop": offsetTop,
        "target": getContainer.value
      }), {
        default: function _default() {
          return [anchorContent];
        }
      }));
    };
  }
});