import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { defineComponent, ref } from 'vue';
import Select, { selectProps } from '../select';
import { isValidElement, flattenChildren } from '../_util/props-util';
import warning from '../_util/warning';
import Option from './Option';
import OptGroup from './OptGroup';
import omit from '../_util/omit';
import useConfigInject from '../config-provider/hooks/useConfigInject';
function isSelectOptionOrSelectOptGroup(child) {
  var _a, _b;
  return ((_a = child === null || child === void 0 ? void 0 : child.type) === null || _a === void 0 ? void 0 : _a.isSelectOption) || ((_b = child === null || child === void 0 ? void 0 : child.type) === null || _b === void 0 ? void 0 : _b.isSelectOptGroup);
}
export var autoCompleteProps = function autoCompleteProps() {
  return _extends(_extends({}, omit(selectProps(), ['loading', 'mode', 'optionLabelProp', 'labelInValue'])), {
    dataSource: Array,
    dropdownMenuStyle: {
      type: Object,
      default: undefined
    },
    // optionLabelProp: String,
    dropdownMatchSelectWidth: {
      type: [Number, Boolean],
      default: true
    },
    prefixCls: String,
    showSearch: {
      type: Boolean,
      default: undefined
    },
    transitionName: String,
    choiceTransitionName: {
      type: String,
      default: 'zoom'
    },
    autofocus: {
      type: Boolean,
      default: undefined
    },
    backfill: {
      type: Boolean,
      default: undefined
    },
    // optionLabelProp: PropTypes.string.def('children'),
    filterOption: {
      type: [Boolean, Function],
      default: false
    },
    defaultActiveFirstOption: {
      type: Boolean,
      default: true
    },
    status: String
  });
};
export var AutoCompleteOption = Option;
export var AutoCompleteOptGroup = OptGroup;
var AutoComplete = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AAutoComplete',
  inheritAttrs: false,
  props: autoCompleteProps(),
  // emits: ['change', 'select', 'focus', 'blur'],
  slots: ['option'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      expose = _ref.expose;
    warning(!('dataSource' in slots), 'AutoComplete', '`dataSource` slot is deprecated, please use props `options` instead.');
    warning(!('options' in slots), 'AutoComplete', '`options` slot is deprecated, please use props `options` instead.');
    warning(!props.dropdownClassName, 'AutoComplete', '`dropdownClassName` is deprecated, please use `popupClassName` instead.');
    var selectRef = ref();
    var getInputElement = function getInputElement() {
      var _a;
      var children = flattenChildren((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      var element = children.length ? children[0] : undefined;
      return element;
    };
    var focus = function focus() {
      var _a;
      (_a = selectRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = selectRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var _useConfigInject = useConfigInject('select', props),
      prefixCls = _useConfigInject.prefixCls;
    return function () {
      var _cls;
      var _a, _b, _c;
      var size = props.size,
        dataSource = props.dataSource,
        _props$notFoundConten = props.notFoundContent,
        notFoundContent = _props$notFoundConten === void 0 ? (_a = slots.notFoundContent) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$notFoundConten;
      var optionChildren;
      var className = attrs.class;
      var cls = (_cls = {}, _defineProperty(_cls, className, !!className), _defineProperty(_cls, "".concat(prefixCls.value, "-lg"), size === 'large'), _defineProperty(_cls, "".concat(prefixCls.value, "-sm"), size === 'small'), _defineProperty(_cls, "".concat(prefixCls.value, "-show-search"), true), _defineProperty(_cls, "".concat(prefixCls.value, "-auto-complete"), true), _cls);
      if (props.options === undefined) {
        var childArray = ((_b = slots.dataSource) === null || _b === void 0 ? void 0 : _b.call(slots)) || ((_c = slots.options) === null || _c === void 0 ? void 0 : _c.call(slots)) || [];
        if (childArray.length && isSelectOptionOrSelectOptGroup(childArray[0])) {
          optionChildren = childArray;
        } else {
          optionChildren = dataSource ? dataSource.map(function (item) {
            if (isValidElement(item)) {
              return item;
            }
            switch (_typeof(item)) {
              case 'string':
                return _createVNode(Option, {
                  "key": item,
                  "value": item
                }, {
                  default: function _default() {
                    return [item];
                  }
                });
              case 'object':
                return _createVNode(Option, {
                  "key": item.value,
                  "value": item.value
                }, {
                  default: function _default() {
                    return [item.text];
                  }
                });
              default:
                throw new Error('AutoComplete[dataSource] only supports type `string[] | Object[]`.');
            }
          }) : [];
        }
      }
      var selectProps = omit(_extends(_extends(_extends({}, props), attrs), {
        mode: Select.SECRET_COMBOBOX_MODE_DO_NOT_USE,
        // optionLabelProp,
        getInputElement: getInputElement,
        notFoundContent: notFoundContent,
        // placeholder: '',
        class: cls,
        popupClassName: props.popupClassName || props.dropdownClassName,
        ref: selectRef
      }), ['dataSource', 'loading']);
      return _createVNode(Select, selectProps, _objectSpread({
        default: function _default() {
          return [optionChildren];
        }
      }, omit(slots, ['default', 'dataSource', 'options'])));
    };
  }
});
/* istanbul ignore next */
export default _extends(AutoComplete, {
  Option: Option,
  OptGroup: OptGroup,
  install: function install(app) {
    app.component(AutoComplete.name, AutoComplete);
    app.component(Option.displayName, Option);
    app.component(OptGroup.displayName, OptGroup);
    return app;
  }
});