import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { cloneVNode, defineComponent } from 'vue';
import PropTypes from '../_util/vue-types';
import { flattenChildren, getPropsSlot } from '../_util/props-util';
import warning from '../_util/warning';
import BreadcrumbItem from './BreadcrumbItem';
import Menu from '../menu';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
export var breadcrumbProps = function breadcrumbProps() {
  return {
    prefixCls: String,
    routes: {
      type: Array
    },
    params: PropTypes.any,
    separator: PropTypes.any,
    itemRender: {
      type: Function
    }
  };
};
function getBreadcrumbName(route, params) {
  if (!route.breadcrumbName) {
    return null;
  }
  var paramsKeys = Object.keys(params).join('|');
  var name = route.breadcrumbName.replace(new RegExp(":(".concat(paramsKeys, ")"), 'g'), function (replacement, key) {
    return params[key] || replacement;
  });
  return name;
}
function defaultItemRender(opt) {
  var route = opt.route,
    params = opt.params,
    routes = opt.routes,
    paths = opt.paths;
  var isLastItem = routes.indexOf(route) === routes.length - 1;
  var name = getBreadcrumbName(route, params);
  return isLastItem ? _createVNode("span", null, [name]) : _createVNode("a", {
    "href": "#/".concat(paths.join('/'))
  }, [name]);
}
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ABreadcrumb',
  inheritAttrs: false,
  props: breadcrumbProps(),
  slots: ['separator', 'itemRender'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('breadcrumb', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getPath = function getPath(path, params) {
      path = (path || '').replace(/^\//, '');
      Object.keys(params).forEach(function (key) {
        path = path.replace(":".concat(key), params[key]);
      });
      return path;
    };
    var addChildPath = function addChildPath(paths, childPath, params) {
      var originalPaths = _toConsumableArray(paths);
      var path = getPath(childPath || '', params);
      if (path) {
        originalPaths.push(path);
      }
      return originalPaths;
    };
    var genForRoutes = function genForRoutes(_ref2) {
      var _ref2$routes = _ref2.routes,
        routes = _ref2$routes === void 0 ? [] : _ref2$routes,
        _ref2$params = _ref2.params,
        params = _ref2$params === void 0 ? {} : _ref2$params,
        separator = _ref2.separator,
        _ref2$itemRender = _ref2.itemRender,
        itemRender = _ref2$itemRender === void 0 ? defaultItemRender : _ref2$itemRender;
      var paths = [];
      return routes.map(function (route) {
        var path = getPath(route.path, params);
        if (path) {
          paths.push(path);
        }
        var tempPaths = [].concat(paths);
        // generated overlay by route.children
        var overlay = null;
        if (route.children && route.children.length) {
          overlay = _createVNode(Menu, {
            "items": route.children.map(function (child) {
              return {
                key: child.path || child.breadcrumbName,
                label: itemRender({
                  route: child,
                  params: params,
                  routes: routes,
                  paths: addChildPath(tempPaths, child.path, params)
                })
              };
            })
          }, null);
        }
        var itemProps = {
          separator: separator
        };
        if (overlay) {
          itemProps.overlay = overlay;
        }
        return _createVNode(BreadcrumbItem, _objectSpread(_objectSpread({}, itemProps), {}, {
          "key": path || route.breadcrumbName
        }), {
          default: function _default() {
            return [itemRender({
              route: route,
              params: params,
              routes: routes,
              paths: tempPaths
            })];
          }
        });
      });
    };
    return function () {
      var _breadcrumbClassName;
      var _a;
      var crumbs;
      var routes = props.routes,
        _props$params = props.params,
        params = _props$params === void 0 ? {} : _props$params;
      var children = flattenChildren(getPropsSlot(slots, props));
      var separator = (_a = getPropsSlot(slots, props, 'separator')) !== null && _a !== void 0 ? _a : '/';
      var itemRender = props.itemRender || slots.itemRender || defaultItemRender;
      if (routes && routes.length > 0) {
        // generated by route
        crumbs = genForRoutes({
          routes: routes,
          params: params,
          separator: separator,
          itemRender: itemRender
        });
      } else if (children.length) {
        crumbs = children.map(function (element, index) {
          warning(_typeof(element.type) === 'object' && (element.type.__ANT_BREADCRUMB_ITEM || element.type.__ANT_BREADCRUMB_SEPARATOR), 'Breadcrumb', "Only accepts Breadcrumb.Item and Breadcrumb.Separator as it's children");
          return cloneVNode(element, {
            separator: separator,
            key: index
          });
        });
      }
      var breadcrumbClassName = (_breadcrumbClassName = {}, _defineProperty(_breadcrumbClassName, prefixCls.value, true), _defineProperty(_breadcrumbClassName, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _defineProperty(_breadcrumbClassName, "".concat(attrs.class), !!attrs.class), _defineProperty(_breadcrumbClassName, hashId.value, true), _breadcrumbClassName);
      return wrapSSR(_createVNode("nav", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": breadcrumbClassName
      }), [_createVNode("ol", null, [crumbs])]));
    };
  }
});