import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { genFocusStyle, resetComponent } from '../../style';
var genBreadcrumbStyle = function genBreadcrumbStyle(token) {
  var _$concat2, _extends2;
  var componentCls = token.componentCls,
    iconCls = token.iconCls;
  return _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    color: token.breadcrumbBaseColor,
    fontSize: token.breadcrumbFontSize
  }, _defineProperty(_extends2, iconCls, {
    fontSize: token.breadcrumbIconFontSize
  }), _defineProperty(_extends2, "ol", {
    display: 'flex',
    flexWrap: 'wrap',
    margin: 0,
    padding: 0,
    listStyle: 'none'
  }), _defineProperty(_extends2, "a", _extends({
    color: token.breadcrumbLinkColor,
    transition: "color ".concat(token.motionDurationMid),
    padding: "0 ".concat(token.paddingXXS, "px"),
    borderRadius: token.borderRadiusSM,
    height: token.lineHeight * token.fontSize,
    display: 'inline-block',
    marginInline: -token.marginXXS,
    '&:hover': {
      color: token.breadcrumbLinkColorHover,
      backgroundColor: token.colorBgTextHover
    }
  }, genFocusStyle(token))), _defineProperty(_extends2, "li:last-child", _defineProperty({
    color: token.breadcrumbLastItemColor
  }, "& > ".concat(componentCls, "-separator"), {
    display: 'none'
  })), _defineProperty(_extends2, "".concat(componentCls, "-separator"), {
    marginInline: token.breadcrumbSeparatorMargin,
    color: token.breadcrumbSeparatorColor
  }), _defineProperty(_extends2, "".concat(componentCls, "-link"), _defineProperty({}, "\n          > ".concat(iconCls, " + span,\n          > ").concat(iconCls, " + a\n        "), {
    marginInlineStart: token.marginXXS
  })), _defineProperty(_extends2, "".concat(componentCls, "-overlay-link"), (_$concat2 = {
    borderRadius: token.borderRadiusSM,
    height: token.lineHeight * token.fontSize,
    display: 'inline-block',
    padding: "0 ".concat(token.paddingXXS, "px"),
    marginInline: -token.marginXXS
  }, _defineProperty(_$concat2, "> ".concat(iconCls), {
    marginInlineStart: token.marginXXS,
    fontSize: token.fontSizeIcon
  }), _defineProperty(_$concat2, '&:hover', {
    color: token.breadcrumbLinkColorHover,
    backgroundColor: token.colorBgTextHover,
    a: {
      color: token.breadcrumbLinkColorHover
    }
  }), _defineProperty(_$concat2, "a", {
    '&:hover': {
      backgroundColor: 'transparent'
    }
  }), _$concat2)), _defineProperty(_extends2, "&".concat(token.componentCls, "-rtl"), {
    direction: 'rtl'
  }), _extends2)));
};
// ============================== Export ==============================
export default genComponentStyleHook('Breadcrumb', function (token) {
  var BreadcrumbToken = mergeToken(token, {
    breadcrumbBaseColor: token.colorTextDescription,
    breadcrumbFontSize: token.fontSize,
    breadcrumbIconFontSize: token.fontSize,
    breadcrumbLinkColor: token.colorTextDescription,
    breadcrumbLinkColorHover: token.colorText,
    breadcrumbLastItemColor: token.colorText,
    breadcrumbSeparatorMargin: token.marginXS,
    breadcrumbSeparatorColor: token.colorTextDescription
  });
  return [genBreadcrumbStyle(BreadcrumbToken)];
});