import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { computed, defineComponent, reactive } from 'vue';
import { flattenChildren } from '../_util/props-util';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { useToken } from '../theme/internal';
import devWarning from '../vc-util/devWarning';
import createContext from '../_util/createContext';
export var buttonGroupProps = function buttonGroupProps() {
  return {
    prefixCls: String,
    size: {
      type: String
    }
  };
};
export var GroupSizeContext = createContext();
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AButtonGroup',
  props: buttonGroupProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var _useConfigInject = useConfigInject('btn-group', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useToken = useToken(),
      _useToken2 = _slicedToArray(_useToken, 3),
      hashId = _useToken2[2];
    GroupSizeContext.useProvide(reactive({
      size: computed(function () {
        return props.size;
      })
    }));
    var classes = computed(function () {
      var _ref2;
      var size = props.size;
      var sizeCls = '';
      switch (size) {
        case 'large':
          sizeCls = 'lg';
          break;
        case 'small':
          sizeCls = 'sm';
          break;
        case 'middle':
        case undefined:
          break;
        default:
          // eslint-disable-next-line no-console
          devWarning(!size, 'Button.Group', 'Invalid prop `size`.');
      }
      return _ref2 = {}, _defineProperty(_ref2, "".concat(prefixCls.value), true), _defineProperty(_ref2, "".concat(prefixCls.value, "-").concat(sizeCls), sizeCls), _defineProperty(_ref2, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _defineProperty(_ref2, hashId.value, true), _ref2;
    });
    return function () {
      var _a;
      return _createVNode("div", {
        "class": classes.value
      }, [flattenChildren((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots))]);
    };
  }
});