import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _createForOfIteratorHelper from "@babel/runtime/helpers/esm/createForOfIteratorHelper";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { computed, ref, watch, defineComponent, provide } from 'vue';
import Checkbox from './Checkbox';
import { useInjectFormItemContext } from '../form/FormItemContext';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { CheckboxGroupContextKey, checkboxGroupProps } from './interface';
// CSSINJS
import useStyle from './style';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ACheckboxGroup',
  inheritAttrs: false,
  props: checkboxGroupProps(),
  // emits: ['change', 'update:value'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit,
      expose = _ref.expose;
    var formItemContext = useInjectFormItemContext();
    var _useConfigInject = useConfigInject('checkbox', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var groupPrefixCls = computed(function () {
      return "".concat(prefixCls.value, "-group");
    });
    // style
    var _useStyle = useStyle(groupPrefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var mergedValue = ref((props.value === undefined ? props.defaultValue : props.value) || []);
    watch(function () {
      return props.value;
    }, function () {
      mergedValue.value = props.value || [];
    });
    var options = computed(function () {
      return props.options.map(function (option) {
        if (typeof option === 'string' || typeof option === 'number') {
          return {
            label: option,
            value: option
          };
        }
        return option;
      });
    });
    var triggerUpdate = ref(Symbol());
    var registeredValuesMap = ref(new Map());
    var cancelValue = function cancelValue(id) {
      registeredValuesMap.value.delete(id);
      triggerUpdate.value = Symbol();
    };
    var registerValue = function registerValue(id, value) {
      registeredValuesMap.value.set(id, value);
      triggerUpdate.value = Symbol();
    };
    var registeredValues = ref(new Map());
    watch(triggerUpdate, function () {
      var valuseMap = new Map();
      var _iterator = _createForOfIteratorHelper(registeredValuesMap.value.values()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var value = _step.value;
          valuseMap.set(value, true);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      registeredValues.value = valuseMap;
    });
    var toggleOption = function toggleOption(option) {
      var optionIndex = mergedValue.value.indexOf(option.value);
      var value = _toConsumableArray(mergedValue.value);
      if (optionIndex === -1) {
        value.push(option.value);
      } else {
        value.splice(optionIndex, 1);
      }
      if (props.value === undefined) {
        mergedValue.value = value;
      }
      var val = value.filter(function (val) {
        return registeredValues.value.has(val);
      }).sort(function (a, b) {
        var indexA = options.value.findIndex(function (opt) {
          return opt.value === a;
        });
        var indexB = options.value.findIndex(function (opt) {
          return opt.value === b;
        });
        return indexA - indexB;
      });
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    provide(CheckboxGroupContextKey, {
      cancelValue: cancelValue,
      registerValue: registerValue,
      toggleOption: toggleOption,
      mergedValue: mergedValue,
      name: computed(function () {
        return props.name;
      }),
      disabled: computed(function () {
        return props.disabled;
      })
    });
    expose({
      mergedValue: mergedValue
    });
    return function () {
      var _a;
      var _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id;
      var children = null;
      if (options.value && options.value.length > 0) {
        children = options.value.map(function (option) {
          var _a;
          return _createVNode(Checkbox, {
            "prefixCls": prefixCls.value,
            "key": option.value.toString(),
            "disabled": 'disabled' in option ? option.disabled : props.disabled,
            "indeterminate": option.indeterminate,
            "value": option.value,
            "checked": mergedValue.value.indexOf(option.value) !== -1,
            "onChange": option.onChange,
            "class": "".concat(groupPrefixCls.value, "-item")
          }, {
            default: function _default() {
              return [option.label === undefined ? (_a = slots.label) === null || _a === void 0 ? void 0 : _a.call(slots, option) : option.label];
            }
          });
        });
      }
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [groupPrefixCls.value, _defineProperty({}, "".concat(groupPrefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value],
        "id": id
      }), [children || ((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots))]));
    };
  }
});