import _extends from "@babel/runtime/helpers/esm/extends";
import PropTypes from '../_util/vue-types';
import { booleanType, functionType, stringType, arrayType } from '../_util/type';
export var abstractCheckboxGroupProps = function abstractCheckboxGroupProps() {
  return {
    name: String,
    prefixCls: String,
    options: arrayType([]),
    disabled: Boolean,
    id: String
  };
};
export var checkboxGroupProps = function checkboxGroupProps() {
  return _extends(_extends({}, abstractCheckboxGroupProps()), {
    defaultValue: arrayType(),
    value: arrayType(),
    onChange: functionType(),
    'onUpdate:value': functionType()
  });
};
export var abstractCheckboxProps = function abstractCheckboxProps() {
  return {
    prefixCls: String,
    defaultChecked: booleanType(),
    checked: booleanType(),
    disabled: booleanType(),
    isGroup: booleanType(),
    value: PropTypes.any,
    name: String,
    id: String,
    indeterminate: booleanType(),
    type: stringType('checkbox'),
    autofocus: booleanType(),
    onChange: functionType(),
    'onUpdate:checked': functionType(),
    onClick: functionType(),
    skipGroup: booleanType(false)
  };
};
export var checkboxProps = function checkboxProps() {
  return _extends(_extends({}, abstractCheckboxProps()), {
    indeterminate: booleanType(false)
  });
};
export var CheckboxGroupContextKey = Symbol('CheckboxGroupContext');