import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genCollapseMotion } from '../../style/motion';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent, resetIcon } from '../../style';
export var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _$concat2, _$concat5, _$concat6, _extends2;
  var componentCls = token.componentCls,
    collapseContentBg = token.collapseContentBg,
    padding = token.padding,
    collapseContentPaddingHorizontal = token.collapseContentPaddingHorizontal,
    collapseHeaderBg = token.collapseHeaderBg,
    collapseHeaderPadding = token.collapseHeaderPadding,
    collapsePanelBorderRadius = token.collapsePanelBorderRadius,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    colorBorder = token.colorBorder,
    colorText = token.colorText,
    colorTextHeading = token.colorTextHeading,
    colorTextDisabled = token.colorTextDisabled,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    marginSM = token.marginSM,
    paddingSM = token.paddingSM,
    motionDurationSlow = token.motionDurationSlow,
    fontSizeIcon = token.fontSizeIcon;
  var borderBase = "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorBorder);
  return _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    backgroundColor: collapseHeaderBg,
    border: borderBase,
    borderBottom: 0,
    borderRadius: "".concat(collapsePanelBorderRadius, "px")
  }, _defineProperty(_extends2, "&-rtl", {
    direction: 'rtl'
  }), _defineProperty(_extends2, "& > ".concat(componentCls, "-item"), (_$concat5 = {
    borderBottom: borderBase
  }, _defineProperty(_$concat5, "&:last-child", _defineProperty({}, "\n            &,\n            & > ".concat(componentCls, "-header"), {
    borderRadius: "0 0 ".concat(collapsePanelBorderRadius, "px ").concat(collapsePanelBorderRadius, "px")
  })), _defineProperty(_$concat5, "> ".concat(componentCls, "-header"), (_$concat = {
    position: 'relative',
    display: 'flex',
    flexWrap: 'nowrap',
    alignItems: 'flex-start',
    padding: collapseHeaderPadding,
    color: colorTextHeading,
    lineHeight: lineHeight,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationSlow, ", visibility 0s")
  }, _defineProperty(_$concat, "> ".concat(componentCls, "-header-text"), {
    flex: 'auto'
  }), _defineProperty(_$concat, '&:focus', {
    outline: 'none'
  }), _defineProperty(_$concat, "".concat(componentCls, "-expand-icon"), {
    height: fontSize * lineHeight,
    display: 'flex',
    alignItems: 'center',
    paddingInlineEnd: marginSM
  }), _defineProperty(_$concat, "".concat(componentCls, "-arrow"), _extends(_extends({}, resetIcon()), {
    fontSize: fontSizeIcon,
    svg: {
      transition: "transform ".concat(motionDurationSlow)
    }
  })), _defineProperty(_$concat, "".concat(componentCls, "-header-text"), {
    marginInlineEnd: 'auto'
  }), _$concat)), _defineProperty(_$concat5, "".concat(componentCls, "-header-collapsible-only"), (_$concat2 = {
    cursor: 'default'
  }, _defineProperty(_$concat2, "".concat(componentCls, "-header-text"), {
    flex: 'none',
    cursor: 'pointer'
  }), _defineProperty(_$concat2, "".concat(componentCls, "-expand-icon"), {
    cursor: 'pointer'
  }), _$concat2)), _defineProperty(_$concat5, "".concat(componentCls, "-icon-collapsible-only"), _defineProperty({
    cursor: 'default'
  }, "".concat(componentCls, "-expand-icon"), {
    cursor: 'pointer'
  })), _defineProperty(_$concat5, "&".concat(componentCls, "-no-arrow"), _defineProperty({}, "> ".concat(componentCls, "-header"), {
    paddingInlineStart: paddingSM
  })), _$concat5)), _defineProperty(_extends2, "".concat(componentCls, "-content"), (_$concat6 = {
    color: colorText,
    backgroundColor: collapseContentBg,
    borderTop: borderBase
  }, _defineProperty(_$concat6, "& > ".concat(componentCls, "-content-box"), {
    padding: "".concat(padding, "px ").concat(collapseContentPaddingHorizontal, "px")
  }), _defineProperty(_$concat6, "&-hidden", {
    display: 'none'
  }), _$concat6)), _defineProperty(_extends2, "".concat(componentCls, "-item:last-child"), _defineProperty({}, "> ".concat(componentCls, "-content"), {
    borderRadius: "0 0 ".concat(collapsePanelBorderRadius, "px ").concat(collapsePanelBorderRadius, "px")
  })), _defineProperty(_extends2, "& ".concat(componentCls, "-item-disabled > ").concat(componentCls, "-header"), _defineProperty({}, "\n          &,\n          & > .arrow\n        ", {
    color: colorTextDisabled,
    cursor: 'not-allowed'
  })), _defineProperty(_extends2, "&".concat(componentCls, "-icon-position-end"), _defineProperty({}, "& > ".concat(componentCls, "-item"), _defineProperty({}, "> ".concat(componentCls, "-header"), _defineProperty({}, "".concat(componentCls, "-expand-icon"), {
    order: 1,
    paddingInlineEnd: 0,
    paddingInlineStart: marginSM
  })))), _extends2)));
};
var genArrowStyle = function genArrowStyle(token) {
  var componentCls = token.componentCls;
  var fixedSelector = "> ".concat(componentCls, "-item > ").concat(componentCls, "-header ").concat(componentCls, "-arrow svg");
  return _defineProperty({}, "".concat(componentCls, "-rtl"), _defineProperty({}, fixedSelector, {
    transform: "rotate(180deg)"
  }));
};
var genBorderlessStyle = function genBorderlessStyle(token) {
  var _$concat12;
  var componentCls = token.componentCls,
    collapseHeaderBg = token.collapseHeaderBg,
    paddingXXS = token.paddingXXS,
    colorBorder = token.colorBorder;
  return _defineProperty({}, "".concat(componentCls, "-borderless"), (_$concat12 = {
    backgroundColor: collapseHeaderBg,
    border: 0
  }, _defineProperty(_$concat12, "> ".concat(componentCls, "-item"), {
    borderBottom: "1px solid ".concat(colorBorder)
  }), _defineProperty(_$concat12, "\n        > ".concat(componentCls, "-item:last-child,\n        > ").concat(componentCls, "-item:last-child ").concat(componentCls, "-header\n      "), {
    borderRadius: 0
  }), _defineProperty(_$concat12, "> ".concat(componentCls, "-item:last-child"), {
    borderBottom: 0
  }), _defineProperty(_$concat12, "> ".concat(componentCls, "-item > ").concat(componentCls, "-content"), {
    backgroundColor: 'transparent',
    borderTop: 0
  }), _defineProperty(_$concat12, "> ".concat(componentCls, "-item > ").concat(componentCls, "-content > ").concat(componentCls, "-content-box"), {
    paddingTop: paddingXXS
  }), _$concat12));
};
var genGhostStyle = function genGhostStyle(token) {
  var componentCls = token.componentCls,
    paddingSM = token.paddingSM;
  return _defineProperty({}, "".concat(componentCls, "-ghost"), _defineProperty({
    backgroundColor: 'transparent',
    border: 0
  }, "> ".concat(componentCls, "-item"), _defineProperty({
    borderBottom: 0
  }, "> ".concat(componentCls, "-content"), _defineProperty({
    backgroundColor: 'transparent',
    border: 0
  }, "> ".concat(componentCls, "-content-box"), {
    paddingBlock: paddingSM
  }))));
};
export default genComponentStyleHook('Collapse', function (token) {
  var collapseToken = mergeToken(token, {
    collapseContentBg: token.colorBgContainer,
    collapseHeaderBg: token.colorFillAlter,
    collapseHeaderPadding: "".concat(token.paddingSM, "px ").concat(token.padding, "px"),
    collapsePanelBorderRadius: token.borderRadiusLG,
    collapseContentPaddingHorizontal: 16 // Fixed value
  });

  return [genBaseStyle(collapseToken), genBorderlessStyle(collapseToken), genGhostStyle(collapseToken), genArrowStyle(collapseToken), genCollapseMotion(collapseToken)];
});