import { computed, inject, ref, provide } from 'vue';
var DisabledContextKey = Symbol('DisabledContextKey');
export var useInjectDisabled = function useInjectDisabled() {
  return inject(DisabledContextKey, ref(undefined));
};
export var useProviderDisabled = function useProviderDisabled(disabled) {
  var parentDisabled = useInjectDisabled();
  provide(DisabledContextKey, computed(function () {
    var _a;
    return (_a = disabled.value) !== null && _a !== void 0 ? _a : parentDisabled.value;
  }));
  return disabled;
};