import { computed, inject, provide } from 'vue';
import { objectType } from '../_util/type';
export var defaultIconPrefixCls = 'anticon';
export var GlobalFormContextKey = Symbol('GlobalFormContextKey');
export var useProvideGlobalForm = function useProvideGlobalForm(state) {
  provide(GlobalFormContextKey, state);
};
export var useInjectGlobalForm = function useInjectGlobalForm() {
  return inject(GlobalFormContextKey, {
    validateMessages: computed(function () {
      return undefined;
    })
  });
};
export var GlobalConfigContextKey = Symbol('GlobalConfigContextKey');
export var configProviderProps = function configProviderProps() {
  return {
    iconPrefixCls: String,
    getTargetContainer: {
      type: Function
    },
    getPopupContainer: {
      type: Function
    },
    prefixCls: String,
    getPrefixCls: {
      type: Function
    },
    renderEmpty: {
      type: Function
    },
    transformCellText: {
      type: Function
    },
    csp: objectType(),
    input: objectType(),
    autoInsertSpaceInButton: {
      type: Boolean,
      default: undefined
    },
    locale: objectType(),
    pageHeader: objectType(),
    componentSize: {
      type: String
    },
    componentDisabled: {
      type: Boolean,
      default: undefined
    },
    direction: {
      type: String
    },
    space: objectType(),
    virtual: {
      type: Boolean,
      default: undefined
    },
    dropdownMatchSelectWidth: {
      type: [Number, Boolean],
      default: true
    },
    form: objectType(),
    pagination: objectType(),
    theme: objectType(),
    select: objectType()
  };
};
export var configProviderKey = Symbol('configProvider');
export var defaultConfigProvider = {
  getPrefixCls: function getPrefixCls(suffixCls, customizePrefixCls) {
    if (customizePrefixCls) return customizePrefixCls;
    return suffixCls ? "ant-".concat(suffixCls) : 'ant';
  },
  iconPrefixCls: computed(function () {
    return defaultIconPrefixCls;
  }),
  getPopupContainer: computed(function () {
    return function () {
      return document.body;
    };
  })
};
export var useConfigContextInject = function useConfigContextInject() {
  return inject(configProviderKey, defaultConfigProvider);
};
export var useConfigContextProvider = function useConfigContextProvider(props) {
  return provide(configProviderKey, props);
};