import _extends from "@babel/runtime/helpers/esm/extends";
import { defaultConfig } from '../../theme/internal';
import { computed } from 'vue';
export default function useTheme(theme, parentTheme) {
  var themeConfig = computed(function () {
    return (theme === null || theme === void 0 ? void 0 : theme.value) || {};
  });
  var parentThemeConfig = computed(function () {
    return themeConfig.value.inherit === false || !(parentTheme === null || parentTheme === void 0 ? void 0 : parentTheme.value) ? defaultConfig : parentTheme.value;
  });
  var mergedTheme = computed(function () {
    if (!(theme === null || theme === void 0 ? void 0 : theme.value)) {
      return parentTheme === null || parentTheme === void 0 ? void 0 : parentTheme.value;
    }
    // Override
    var mergedComponents = _extends({}, parentThemeConfig.value.components);
    Object.keys(theme.value.components || {}).forEach(function (componentName) {
      mergedComponents[componentName] = _extends(_extends({}, mergedComponents[componentName]), theme.value.components[componentName]);
    });
    // Base token
    return _extends(_extends(_extends({}, parentThemeConfig.value), themeConfig.value), {
      token: _extends(_extends({}, parentThemeConfig.value.token), themeConfig.value.token),
      components: mergedComponents
    });
  });
  return mergedTheme;
}