import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { watch, computed, reactive, defineComponent, watchEffect } from 'vue';
import defaultRenderEmpty from './renderEmpty';
import LocaleProvider, { ANT_MARK } from '../locale-provider';
import LocaleReceiver from '../locale-provider/LocaleReceiver';
import message from '../message';
import notification from '../notification';
import { registerTheme } from './cssVariables';
import defaultLocale from '../locale/en_US';
import useStyle from './style';
import useTheme from './hooks/useTheme';
import defaultSeedToken from '../theme/themes/seed';
import { useConfigContextProvider, useConfigContextInject, configProviderProps, useProvideGlobalForm, defaultIconPrefixCls } from './context';
import { useProviderSize } from './SizeContext';
import { useProviderDisabled } from './DisabledContext';
import { createTheme } from '../_util/cssinjs';
import { DesignTokenProvider } from '../theme/internal';
export var defaultPrefixCls = 'ant';
export { defaultIconPrefixCls };
function getGlobalPrefixCls() {
  return globalConfigForApi.prefixCls || defaultPrefixCls;
}
function getGlobalIconPrefixCls() {
  return globalConfigForApi.iconPrefixCls || defaultIconPrefixCls;
}
var globalConfigBySet = reactive({}); // 权重最大
export var globalConfigForApi = reactive({});
export var configConsumerProps = ['getTargetContainer', 'getPopupContainer', 'rootPrefixCls', 'getPrefixCls', 'renderEmpty', 'csp', 'autoInsertSpaceInButton', 'locale', 'pageHeader'];
watchEffect(function () {
  _extends(globalConfigForApi, globalConfigBySet);
  globalConfigForApi.prefixCls = getGlobalPrefixCls();
  globalConfigForApi.iconPrefixCls = getGlobalIconPrefixCls();
  globalConfigForApi.getPrefixCls = function (suffixCls, customizePrefixCls) {
    if (customizePrefixCls) return customizePrefixCls;
    return suffixCls ? "".concat(globalConfigForApi.prefixCls, "-").concat(suffixCls) : globalConfigForApi.prefixCls;
  };
  globalConfigForApi.getRootPrefixCls = function () {
    // If Global prefixCls provided, use this
    if (globalConfigForApi.prefixCls) {
      return globalConfigForApi.prefixCls;
    }
    // Fallback to default prefixCls
    return getGlobalPrefixCls();
  };
});
var stopWatchEffect;
var setGlobalConfig = function setGlobalConfig(params) {
  if (stopWatchEffect) {
    stopWatchEffect();
  }
  stopWatchEffect = watchEffect(function () {
    _extends(globalConfigBySet, reactive(params));
    _extends(globalConfigForApi, reactive(params));
  });
  if (params.theme) {
    registerTheme(getGlobalPrefixCls(), params.theme);
  }
};
export var globalConfig = function globalConfig() {
  return {
    getPrefixCls: function getPrefixCls(suffixCls, customizePrefixCls) {
      if (customizePrefixCls) return customizePrefixCls;
      return suffixCls ? "".concat(getGlobalPrefixCls(), "-").concat(suffixCls) : getGlobalPrefixCls();
    },
    getIconPrefixCls: getGlobalIconPrefixCls,
    getRootPrefixCls: function getRootPrefixCls() {
      // If Global prefixCls provided, use this
      if (globalConfigForApi.prefixCls) {
        return globalConfigForApi.prefixCls;
      }
      // Fallback to default prefixCls
      return getGlobalPrefixCls();
    }
  };
};
var ConfigProvider = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AConfigProvider',
  inheritAttrs: false,
  props: configProviderProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var parentContext = useConfigContextInject();
    var getPrefixCls = function getPrefixCls(suffixCls, customizePrefixCls) {
      var _props$prefixCls = props.prefixCls,
        prefixCls = _props$prefixCls === void 0 ? 'ant' : _props$prefixCls;
      if (customizePrefixCls) return customizePrefixCls;
      var mergedPrefixCls = prefixCls || parentContext.getPrefixCls('');
      return suffixCls ? "".concat(mergedPrefixCls, "-").concat(suffixCls) : mergedPrefixCls;
    };
    var iconPrefixCls = computed(function () {
      return props.iconPrefixCls || parentContext.iconPrefixCls.value || defaultIconPrefixCls;
    });
    var shouldWrapSSR = computed(function () {
      return iconPrefixCls.value !== parentContext.iconPrefixCls.value;
    });
    var csp = computed(function () {
      var _a;
      return props.csp || ((_a = parentContext.csp) === null || _a === void 0 ? void 0 : _a.value);
    });
    var wrapSSR = useStyle(iconPrefixCls);
    var mergedTheme = useTheme(computed(function () {
      return props.theme;
    }), computed(function () {
      var _a;
      return (_a = parentContext.theme) === null || _a === void 0 ? void 0 : _a.value;
    }));
    var renderEmptyComponent = function renderEmptyComponent(name) {
      var renderEmpty = props.renderEmpty || slots.renderEmpty || parentContext.renderEmpty || defaultRenderEmpty;
      return renderEmpty(name);
    };
    var autoInsertSpaceInButton = computed(function () {
      var _a, _b;
      return (_a = props.autoInsertSpaceInButton) !== null && _a !== void 0 ? _a : (_b = parentContext.autoInsertSpaceInButton) === null || _b === void 0 ? void 0 : _b.value;
    });
    var locale = computed(function () {
      var _a;
      return props.locale || ((_a = parentContext.locale) === null || _a === void 0 ? void 0 : _a.value);
    });
    watch(locale, function () {
      globalConfigBySet.locale = locale.value;
    }, {
      immediate: true
    });
    var direction = computed(function () {
      var _a;
      return props.direction || ((_a = parentContext.direction) === null || _a === void 0 ? void 0 : _a.value);
    });
    var space = computed(function () {
      var _a, _b;
      return (_a = props.space) !== null && _a !== void 0 ? _a : (_b = parentContext.space) === null || _b === void 0 ? void 0 : _b.value;
    });
    var virtual = computed(function () {
      var _a, _b;
      return (_a = props.virtual) !== null && _a !== void 0 ? _a : (_b = parentContext.virtual) === null || _b === void 0 ? void 0 : _b.value;
    });
    var dropdownMatchSelectWidth = computed(function () {
      var _a, _b;
      return (_a = props.dropdownMatchSelectWidth) !== null && _a !== void 0 ? _a : (_b = parentContext.dropdownMatchSelectWidth) === null || _b === void 0 ? void 0 : _b.value;
    });
    var getTargetContainer = computed(function () {
      var _a;
      return props.getTargetContainer !== undefined ? props.getTargetContainer : (_a = parentContext.getTargetContainer) === null || _a === void 0 ? void 0 : _a.value;
    });
    var getPopupContainer = computed(function () {
      var _a;
      return props.getPopupContainer !== undefined ? props.getPopupContainer : (_a = parentContext.getPopupContainer) === null || _a === void 0 ? void 0 : _a.value;
    });
    var pageHeader = computed(function () {
      var _a;
      return props.pageHeader !== undefined ? props.pageHeader : (_a = parentContext.pageHeader) === null || _a === void 0 ? void 0 : _a.value;
    });
    var input = computed(function () {
      var _a;
      return props.input !== undefined ? props.input : (_a = parentContext.input) === null || _a === void 0 ? void 0 : _a.value;
    });
    var pagination = computed(function () {
      var _a;
      return props.pagination !== undefined ? props.pagination : (_a = parentContext.pagination) === null || _a === void 0 ? void 0 : _a.value;
    });
    var form = computed(function () {
      var _a;
      return props.form !== undefined ? props.form : (_a = parentContext.form) === null || _a === void 0 ? void 0 : _a.value;
    });
    var select = computed(function () {
      var _a;
      return props.select !== undefined ? props.select : (_a = parentContext.select) === null || _a === void 0 ? void 0 : _a.value;
    });
    var componentSize = computed(function () {
      return props.componentSize;
    });
    var componentDisabled = computed(function () {
      return props.componentDisabled;
    });
    var configProvider = {
      csp: csp,
      autoInsertSpaceInButton: autoInsertSpaceInButton,
      locale: locale,
      direction: direction,
      space: space,
      virtual: virtual,
      dropdownMatchSelectWidth: dropdownMatchSelectWidth,
      getPrefixCls: getPrefixCls,
      iconPrefixCls: iconPrefixCls,
      theme: computed(function () {
        var _a, _b;
        return (_a = mergedTheme.value) !== null && _a !== void 0 ? _a : (_b = parentContext.theme) === null || _b === void 0 ? void 0 : _b.value;
      }),
      renderEmpty: renderEmptyComponent,
      getTargetContainer: getTargetContainer,
      getPopupContainer: getPopupContainer,
      pageHeader: pageHeader,
      input: input,
      pagination: pagination,
      form: form,
      select: select,
      componentSize: componentSize,
      componentDisabled: componentDisabled,
      transformCellText: computed(function () {
        return props.transformCellText;
      })
    };
    // ================================ Dynamic theme ================================
    var memoTheme = computed(function () {
      var _a = mergedTheme.value || {},
        algorithm = _a.algorithm,
        token = _a.token,
        rest = __rest(_a, ["algorithm", "token"]);
      var themeObj = algorithm && (!Array.isArray(algorithm) || algorithm.length > 0) ? createTheme(algorithm) : undefined;
      return _extends(_extends({}, rest), {
        theme: themeObj,
        token: _extends(_extends({}, defaultSeedToken), token)
      });
    });
    var validateMessagesRef = computed(function () {
      var _a, _b;
      // Additional Form provider
      var validateMessages = {};
      if (locale.value) {
        validateMessages = ((_a = locale.value.Form) === null || _a === void 0 ? void 0 : _a.defaultValidateMessages) || ((_b = defaultLocale.Form) === null || _b === void 0 ? void 0 : _b.defaultValidateMessages) || {};
      }
      if (props.form && props.form.validateMessages) {
        validateMessages = _extends(_extends({}, validateMessages), props.form.validateMessages);
      }
      return validateMessages;
    });
    useConfigContextProvider(configProvider);
    useProvideGlobalForm({
      validateMessages: validateMessagesRef
    });
    useProviderSize(componentSize);
    useProviderDisabled(componentDisabled);
    var renderProvider = function renderProvider(legacyLocale) {
      var _a, _b;
      var childNode = shouldWrapSSR.value ? wrapSSR((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) : (_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots);
      if (props.theme) {
        var _childNode = function () {
          return childNode;
        }();
        childNode = _createVNode(DesignTokenProvider, {
          "value": memoTheme.value
        }, {
          default: function _default() {
            return [_childNode];
          }
        });
      }
      return _createVNode(LocaleProvider, {
        "locale": locale.value || legacyLocale,
        "ANT_MARK__": ANT_MARK
      }, {
        default: function _default() {
          return [childNode];
        }
      });
    };
    watchEffect(function () {
      if (direction.value) {
        message.config({
          rtl: direction.value === 'rtl'
        });
        notification.config({
          rtl: direction.value === 'rtl'
        });
      }
    });
    return function () {
      return _createVNode(LocaleReceiver, {
        "children": function children(_, __, legacyLocale) {
          return renderProvider(legacyLocale);
        }
      }, null);
    };
  }
});
ConfigProvider.install = function (app) {
  app.component(ConfigProvider.name, ConfigProvider);
};
export default ConfigProvider;