import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode, Fragment as _Fragment } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import CalendarOutlined from "@ant-design/icons-vue/es/icons/CalendarOutlined";
import ClockCircleOutlined from "@ant-design/icons-vue/es/icons/ClockCircleOutlined";
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import RCPicker from '../../vc-picker';
import enUS from '../locale/en_US';
import { getPlaceholder, transPlacement2DropdownAlign } from '../util';
import { useLocaleReceiver } from '../../locale-provider/LocaleReceiver';
import { getTimeProps, Components } from '.';
import { computed, defineComponent, ref } from 'vue';
import useConfigInject from '../../config-provider/hooks/useConfigInject';
import classNames from '../../_util/classNames';
import { commonProps, datePickerProps } from './props';
import devWarning from '../../vc-util/devWarning';
import { FormItemInputContext, useInjectFormItemContext } from '../../form/FormItemContext';
import { getMergedStatus, getStatusClassNames } from '../../_util/statusUtils';
import { useCompactItemContext } from '../../space/Compact';
//CSSINJS
import useStyle from '../style';
export default function generateSinglePicker(generateConfig, extraProps) {
  function getPicker(picker, displayName) {
    var comProps = _extends(_extends(_extends({}, commonProps()), datePickerProps()), extraProps);
    return defineComponent({
      compatConfig: {
        MODE: 3
      },
      name: displayName,
      inheritAttrs: false,
      props: comProps,
      slots: ['suffixIcon',
      // 'clearIcon',
      'prevIcon', 'nextIcon', 'superPrevIcon', 'superNextIcon',
      // 'panelRender',
      'dateRender', 'renderExtraFooter', 'monthCellRender'],
      setup: function setup(_props, _ref) {
        var slots = _ref.slots,
          expose = _ref.expose,
          attrs = _ref.attrs,
          emit = _ref.emit;
        // 兼容 vue 3.2.7
        var props = _props;
        var formItemContext = useInjectFormItemContext();
        var formItemInputContext = FormItemInputContext.useInject();
        // =================== Warning =====================
        if (process.env.NODE_ENV !== 'production') {
          devWarning(picker !== 'quarter', displayName || 'DatePicker', "DatePicker.".concat(displayName, " is legacy usage. Please use DatePicker[picker='").concat(picker, "'] directly."));
          devWarning(!props.dropdownClassName, displayName || 'DatePicker', '`dropdownClassName` is deprecated. Please use `popupClassName` instead.');
          devWarning(!(props.monthCellContentRender || slots.monthCellContentRender), displayName || 'DatePicker', '`monthCellContentRender` is deprecated. Please use `monthCellRender"` instead.');
          devWarning(!attrs.getCalendarContainer, displayName || 'DatePicker', '`getCalendarContainer` is deprecated. Please use `getPopupContainer"` instead.');
        }
        var _useConfigInject = useConfigInject('picker', props),
          prefixCls = _useConfigInject.prefixCls,
          direction = _useConfigInject.direction,
          getPopupContainer = _useConfigInject.getPopupContainer,
          size = _useConfigInject.size,
          rootPrefixCls = _useConfigInject.rootPrefixCls,
          disabled = _useConfigInject.disabled;
        var _useCompactItemContex = useCompactItemContext(prefixCls, direction),
          compactSize = _useCompactItemContex.compactSize,
          compactItemClassnames = _useCompactItemContex.compactItemClassnames;
        var mergedSize = computed(function () {
          return compactSize.value || size.value;
        });
        // style
        var _useStyle = useStyle(prefixCls),
          _useStyle2 = _slicedToArray(_useStyle, 2),
          wrapSSR = _useStyle2[0],
          hashId = _useStyle2[1];
        var pickerRef = ref();
        expose({
          focus: function focus() {
            var _a;
            (_a = pickerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
          },
          blur: function blur() {
            var _a;
            (_a = pickerRef.value) === null || _a === void 0 ? void 0 : _a.blur();
          }
        });
        var maybeToString = function maybeToString(date) {
          return props.valueFormat ? generateConfig.toString(date, props.valueFormat) : date;
        };
        var onChange = function onChange(date, dateString) {
          var value = maybeToString(date);
          emit('update:value', value);
          emit('change', value, dateString);
          formItemContext.onFieldChange();
        };
        var onOpenChange = function onOpenChange(open) {
          emit('update:open', open);
          emit('openChange', open);
        };
        var onFocus = function onFocus(e) {
          emit('focus', e);
        };
        var onBlur = function onBlur(e) {
          emit('blur', e);
          formItemContext.onFieldBlur();
        };
        var onPanelChange = function onPanelChange(date, mode) {
          var value = maybeToString(date);
          emit('panelChange', value, mode);
        };
        var onOk = function onOk(date) {
          var value = maybeToString(date);
          emit('ok', value);
        };
        var _useLocaleReceiver = useLocaleReceiver('DatePicker', enUS),
          _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
          contextLocale = _useLocaleReceiver2[0];
        var value = computed(function () {
          if (props.value) {
            return props.valueFormat ? generateConfig.toDate(props.value, props.valueFormat) : props.value;
          }
          return props.value === '' ? undefined : props.value;
        });
        var defaultValue = computed(function () {
          if (props.defaultValue) {
            return props.valueFormat ? generateConfig.toDate(props.defaultValue, props.valueFormat) : props.defaultValue;
          }
          return props.defaultValue === '' ? undefined : props.defaultValue;
        });
        var defaultPickerValue = computed(function () {
          if (props.defaultPickerValue) {
            return props.valueFormat ? generateConfig.toDate(props.defaultPickerValue, props.valueFormat) : props.defaultPickerValue;
          }
          return props.defaultPickerValue === '' ? undefined : props.defaultPickerValue;
        });
        return function () {
          var _classNames;
          var _a, _b, _c, _d, _e, _f;
          var locale = _extends(_extends({}, contextLocale.value), props.locale);
          var p = _extends(_extends({}, props), attrs);
          var _p$bordered = p.bordered,
            bordered = _p$bordered === void 0 ? true : _p$bordered,
            placeholder = p.placeholder,
            _p$suffixIcon = p.suffixIcon,
            suffixIcon = _p$suffixIcon === void 0 ? (_a = slots.suffixIcon) === null || _a === void 0 ? void 0 : _a.call(slots) : _p$suffixIcon,
            _p$showToday = p.showToday,
            showToday = _p$showToday === void 0 ? true : _p$showToday,
            transitionName = p.transitionName,
            _p$allowClear = p.allowClear,
            allowClear = _p$allowClear === void 0 ? true : _p$allowClear,
            _p$dateRender = p.dateRender,
            dateRender = _p$dateRender === void 0 ? slots.dateRender : _p$dateRender,
            _p$renderExtraFooter = p.renderExtraFooter,
            renderExtraFooter = _p$renderExtraFooter === void 0 ? slots.renderExtraFooter : _p$renderExtraFooter,
            _p$monthCellRender = p.monthCellRender,
            monthCellRender = _p$monthCellRender === void 0 ? slots.monthCellRender || props.monthCellContentRender || slots.monthCellContentRender : _p$monthCellRender,
            _p$clearIcon = p.clearIcon,
            clearIcon = _p$clearIcon === void 0 ? (_b = slots.clearIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _p$clearIcon,
            _p$id = p.id,
            id = _p$id === void 0 ? formItemContext.id.value : _p$id,
            restProps = __rest(p, ["bordered", "placeholder", "suffixIcon", "showToday", "transitionName", "allowClear", "dateRender", "renderExtraFooter", "monthCellRender", "clearIcon", "id"]);
          var showTime = p.showTime === '' ? true : p.showTime;
          var format = p.format;
          var additionalOverrideProps = {};
          if (picker) {
            additionalOverrideProps.picker = picker;
          }
          var mergedPicker = picker || p.picker || 'date';
          additionalOverrideProps = _extends(_extends(_extends({}, additionalOverrideProps), showTime ? getTimeProps(_extends({
            format: format,
            picker: mergedPicker
          }, _typeof(showTime) === 'object' ? showTime : {})) : {}), mergedPicker === 'time' ? getTimeProps(_extends(_extends({
            format: format
          }, restProps), {
            picker: mergedPicker
          })) : {});
          var pre = prefixCls.value;
          var suffixNode = _createVNode(_Fragment, null, [suffixIcon || (picker === 'time' ? _createVNode(ClockCircleOutlined, null, null) : _createVNode(CalendarOutlined, null, null)), formItemInputContext.hasFeedback && formItemInputContext.feedbackIcon]);
          return wrapSSR(_createVNode(RCPicker, _objectSpread(_objectSpread(_objectSpread({
            "monthCellRender": monthCellRender,
            "dateRender": dateRender,
            "renderExtraFooter": renderExtraFooter,
            "ref": pickerRef,
            "placeholder": getPlaceholder(locale, mergedPicker, placeholder),
            "suffixIcon": suffixNode,
            "dropdownAlign": transPlacement2DropdownAlign(direction.value, props.placement),
            "clearIcon": clearIcon || _createVNode(CloseCircleFilled, null, null),
            "allowClear": allowClear,
            "transitionName": transitionName || "".concat(rootPrefixCls.value, "-slide-up")
          }, restProps), additionalOverrideProps), {}, {
            "id": id,
            "picker": mergedPicker,
            "value": value.value,
            "defaultValue": defaultValue.value,
            "defaultPickerValue": defaultPickerValue.value,
            "showToday": showToday,
            "locale": locale.lang,
            "class": classNames((_classNames = {}, _defineProperty(_classNames, "".concat(pre, "-").concat(mergedSize.value), mergedSize.value), _defineProperty(_classNames, "".concat(pre, "-borderless"), !bordered), _classNames), getStatusClassNames(pre, getMergedStatus(formItemInputContext.status, props.status), formItemInputContext.hasFeedback), attrs.class, hashId.value, compactItemClassnames.value),
            "disabled": disabled.value,
            "prefixCls": pre,
            "getPopupContainer": attrs.getCalendarContainer || getPopupContainer.value,
            "generateConfig": generateConfig,
            "prevIcon": ((_c = slots.prevIcon) === null || _c === void 0 ? void 0 : _c.call(slots)) || _createVNode("span", {
              "class": "".concat(pre, "-prev-icon")
            }, null),
            "nextIcon": ((_d = slots.nextIcon) === null || _d === void 0 ? void 0 : _d.call(slots)) || _createVNode("span", {
              "class": "".concat(pre, "-next-icon")
            }, null),
            "superPrevIcon": ((_e = slots.superPrevIcon) === null || _e === void 0 ? void 0 : _e.call(slots)) || _createVNode("span", {
              "class": "".concat(pre, "-super-prev-icon")
            }, null),
            "superNextIcon": ((_f = slots.superNextIcon) === null || _f === void 0 ? void 0 : _f.call(slots)) || _createVNode("span", {
              "class": "".concat(pre, "-super-next-icon")
            }, null),
            "components": Components,
            "direction": direction.value,
            "dropdownClassName": classNames(hashId.value, props.popupClassName, props.dropdownClassName),
            "onChange": onChange,
            "onOpenChange": onOpenChange,
            "onFocus": onFocus,
            "onBlur": onBlur,
            "onPanelChange": onPanelChange,
            "onOk": onOk
          }), null));
        };
      }
    });
  }
  var DatePicker = getPicker(undefined, 'ADatePicker');
  var WeekPicker = getPicker('week', 'AWeekPicker');
  var MonthPicker = getPicker('month', 'AMonthPicker');
  var YearPicker = getPicker('year', 'AYearPicker');
  var TimePicker = getPicker('time', 'TimePicker'); // 给独立组件 TimePicker 使用，此处名称不用更改
  var QuarterPicker = getPicker('quarter', 'AQuarterPicker');
  return {
    DatePicker: DatePicker,
    WeekPicker: WeekPicker,
    MonthPicker: MonthPicker,
    YearPicker: YearPicker,
    TimePicker: TimePicker,
    QuarterPicker: QuarterPicker
  };
}