import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { flattenChildren } from '../_util/props-util';
import { computed, defineComponent } from 'vue';
import { withInstall } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
export var dividerProps = function dividerProps() {
  return {
    prefixCls: String,
    type: {
      type: String,
      default: 'horizontal'
    },
    dashed: {
      type: Boolean,
      default: false
    },
    orientation: {
      type: String,
      default: 'center'
    },
    plain: {
      type: Boolean,
      default: false
    },
    orientationMargin: [String, Number]
  };
};
var Divider = defineComponent({
  name: 'ADivider',
  inheritAttrs: false,
  compatConfig: {
    MODE: 3
  },
  props: dividerProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('divider', props),
      prefixClsRef = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixClsRef),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var hasCustomMarginLeft = computed(function () {
      return props.orientation === 'left' && props.orientationMargin != null;
    });
    var hasCustomMarginRight = computed(function () {
      return props.orientation === 'right' && props.orientationMargin != null;
    });
    var classString = computed(function () {
      var _ref2;
      var type = props.type,
        dashed = props.dashed,
        plain = props.plain;
      var prefixCls = prefixClsRef.value;
      return _ref2 = {}, _defineProperty(_ref2, prefixCls, true), _defineProperty(_ref2, hashId.value, !!hashId.value), _defineProperty(_ref2, "".concat(prefixCls, "-").concat(type), true), _defineProperty(_ref2, "".concat(prefixCls, "-dashed"), !!dashed), _defineProperty(_ref2, "".concat(prefixCls, "-plain"), !!plain), _defineProperty(_ref2, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), _defineProperty(_ref2, "".concat(prefixCls, "-no-default-orientation-margin-left"), hasCustomMarginLeft.value), _defineProperty(_ref2, "".concat(prefixCls, "-no-default-orientation-margin-right"), hasCustomMarginRight.value), _ref2;
    });
    var innerStyle = computed(function () {
      var marginValue = typeof props.orientationMargin === 'number' ? "".concat(props.orientationMargin, "px") : props.orientationMargin;
      return _extends(_extends({}, hasCustomMarginLeft.value && {
        marginLeft: marginValue
      }), hasCustomMarginRight.value && {
        marginRight: marginValue
      });
    });
    var orientationPrefix = computed(function () {
      return props.orientation.length > 0 ? '-' + props.orientation : props.orientation;
    });
    return function () {
      var _a;
      var children = flattenChildren((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [classString.value, children.length ? "".concat(prefixClsRef.value, "-with-text ").concat(prefixClsRef.value, "-with-text").concat(orientationPrefix.value) : '', attrs.class],
        "role": "separator"
      }), [children.length ? _createVNode("span", {
        "class": "".concat(prefixClsRef.value, "-inner-text"),
        "style": innerStyle.value
      }, [children]) : null]));
    };
  }
});
export default withInstall(Divider);