import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { inject, nextTick, defineComponent, shallowRef, onMounted, provide, onUnmounted, watch, computed } from 'vue';
import { getPropsSlot, initDefaultProps } from '../_util/props-util';
import classnames from '../_util/classNames';
import VcDrawer from '../vc-drawer';
import PropTypes from '../_util/vue-types';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { objectType, withInstall } from '../_util/type';
import omit from '../_util/omit';
import devWarning from '../vc-util/devWarning';
import useStyle from './style';
import { NoCompactStyle } from '../space/Compact';
import isNumeric from '../_util/isNumeric';
import { getTransitionName, getTransitionProps } from '../_util/transition';
var PlacementTypes = ['top', 'right', 'bottom', 'left'];
var SizeTypes = ['default', 'large'];
var defaultPushState = {
  distance: 180
};
export var drawerProps = function drawerProps() {
  return {
    autofocus: {
      type: Boolean,
      default: undefined
    },
    closable: {
      type: Boolean,
      default: undefined
    },
    closeIcon: PropTypes.any,
    destroyOnClose: {
      type: Boolean,
      default: undefined
    },
    forceRender: {
      type: Boolean,
      default: undefined
    },
    getContainer: {
      type: [String, Function, Boolean, Object],
      default: undefined
    },
    maskClosable: {
      type: Boolean,
      default: undefined
    },
    mask: {
      type: Boolean,
      default: undefined
    },
    maskStyle: objectType(),
    rootClassName: String,
    rootStyle: objectType(),
    size: {
      type: String
    },
    drawerStyle: objectType(),
    headerStyle: objectType(),
    bodyStyle: objectType(),
    contentWrapperStyle: {
      type: Object,
      default: undefined
    },
    title: PropTypes.any,
    /** @deprecated Please use `open` instead */
    visible: {
      type: Boolean,
      default: undefined
    },
    open: {
      type: Boolean,
      default: undefined
    },
    width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    zIndex: Number,
    prefixCls: String,
    push: PropTypes.oneOfType([PropTypes.looseBool, {
      type: Object
    }]),
    placement: PropTypes.oneOf(PlacementTypes),
    keyboard: {
      type: Boolean,
      default: undefined
    },
    extra: PropTypes.any,
    footer: PropTypes.any,
    footerStyle: objectType(),
    level: PropTypes.any,
    levelMove: {
      type: [Number, Array, Function]
    },
    handle: PropTypes.any,
    /** @deprecated Use `@afterVisibleChange` instead */
    afterVisibleChange: Function,
    /** @deprecated Please use `@afterOpenChange` instead */
    onAfterVisibleChange: Function,
    onAfterOpenChange: Function,
    /** @deprecated Please use `onUpdate:open` instead */
    'onUpdate:visible': Function,
    'onUpdate:open': Function,
    onClose: Function
  };
};
var Drawer = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ADrawer',
  inheritAttrs: false,
  props: initDefaultProps(drawerProps(), {
    closable: true,
    placement: 'right',
    maskClosable: true,
    mask: true,
    level: null,
    keyboard: true,
    push: defaultPushState
  }),
  slots: ['closeIcon', 'title', 'extra', 'footer', 'handle'],
  // emits: ['update:visible', 'close', 'afterVisibleChange'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var sPush = shallowRef(false);
    var destroyClose = shallowRef(false);
    var vcDrawer = shallowRef(null);
    var load = shallowRef(false);
    var visible = shallowRef(false);
    var mergedOpen = computed(function () {
      var _a;
      return (_a = props.open) !== null && _a !== void 0 ? _a : props.visible;
    });
    watch(mergedOpen, function () {
      if (mergedOpen.value) {
        load.value = true;
      } else {
        visible.value = false;
      }
    }, {
      immediate: true
    });
    watch([mergedOpen, load], function () {
      if (mergedOpen.value && load.value) {
        visible.value = true;
      }
    }, {
      immediate: true
    });
    var parentDrawerOpts = inject('parentDrawerOpts', null);
    var _useConfigInject = useConfigInject('drawer', props),
      prefixCls = _useConfigInject.prefixCls,
      getPopupContainer = _useConfigInject.getPopupContainer,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getContainer = computed(function () {
      return (
        // 有可能为 false，所以不能直接判断
        props.getContainer === undefined && (getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value) ? function () {
          return getPopupContainer.value(document.body);
        } : props.getContainer
      );
    });
    devWarning(!props.afterVisibleChange, 'Drawer', '`afterVisibleChange` prop is deprecated, please use `@afterVisibleChange` event instead');
    // ========================== Warning ===========================
    if (process.env.NODE_ENV !== 'production') {
      [['visible', 'open'], ['onUpdate:visible', 'onUpdate:open'], ['onAfterVisibleChange', 'onAfterOpenChange']].forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        devWarning(!props[deprecatedName], 'Drawer', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var setPush = function setPush() {
      sPush.value = true;
    };
    var setPull = function setPull() {
      sPush.value = false;
      nextTick(function () {
        domFocus();
      });
    };
    provide('parentDrawerOpts', {
      setPush: setPush,
      setPull: setPull
    });
    onMounted(function () {
      if (mergedOpen.value && parentDrawerOpts) {
        parentDrawerOpts.setPush();
      }
    });
    onUnmounted(function () {
      if (parentDrawerOpts) {
        parentDrawerOpts.setPull();
      }
    });
    watch(visible, function () {
      if (parentDrawerOpts) {
        if (visible.value) {
          parentDrawerOpts.setPush();
        } else {
          parentDrawerOpts.setPull();
        }
      }
    }, {
      flush: 'post'
    });
    var domFocus = function domFocus() {
      var _a, _b;
      (_b = (_a = vcDrawer.value) === null || _a === void 0 ? void 0 : _a.domFocus) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var close = function close(e) {
      emit('update:visible', false);
      emit('update:open', false);
      emit('close', e);
    };
    var afterVisibleChange = function afterVisibleChange(open) {
      var _a;
      if (!open) {
        if (destroyClose.value === false) {
          // set true only once
          destroyClose.value = true;
        }
        if (props.destroyOnClose) {
          load.value = false;
        }
      }
      (_a = props.afterVisibleChange) === null || _a === void 0 ? void 0 : _a.call(props, open);
      emit('afterVisibleChange', open);
      emit('afterOpenChange', open);
    };
    var pushTransform = computed(function () {
      var push = props.push,
        placement = props.placement;
      var distance;
      if (typeof push === 'boolean') {
        distance = push ? defaultPushState.distance : 0;
      } else {
        distance = push.distance;
      }
      distance = parseFloat(String(distance || 0));
      if (placement === 'left' || placement === 'right') {
        return "translateX(".concat(placement === 'left' ? distance : -distance, "px)");
      }
      if (placement === 'top' || placement === 'bottom') {
        return "translateY(".concat(placement === 'top' ? distance : -distance, "px)");
      }
      return null;
    });
    // ============================ Size ============================
    var mergedWidth = computed(function () {
      var _a;
      return (_a = props.width) !== null && _a !== void 0 ? _a : props.size === 'large' ? 736 : 378;
    });
    var mergedHeight = computed(function () {
      var _a;
      return (_a = props.height) !== null && _a !== void 0 ? _a : props.size === 'large' ? 736 : 378;
    });
    var offsetStyle = computed(function () {
      // https://github.com/ant-design/ant-design/issues/24287
      var mask = props.mask,
        placement = props.placement;
      if (!visible.value && !mask) {
        return {};
      }
      var val = {};
      if (placement === 'left' || placement === 'right') {
        val.width = isNumeric(mergedWidth.value) ? "".concat(mergedWidth.value, "px") : mergedWidth.value;
      } else {
        val.height = isNumeric(mergedHeight.value) ? "".concat(mergedHeight.value, "px") : mergedHeight.value;
      }
      return val;
    });
    var wrapperStyle = computed(function () {
      var zIndex = props.zIndex;
      var val = offsetStyle.value;
      return [{
        zIndex: zIndex,
        transform: sPush.value ? pushTransform.value : undefined
      }, val];
    });
    var renderHeader = function renderHeader(prefixCls) {
      var closable = props.closable,
        headerStyle = props.headerStyle;
      var extra = getPropsSlot(slots, props, 'extra');
      var title = getPropsSlot(slots, props, 'title');
      if (!title && !closable) {
        return null;
      }
      return _createVNode("div", {
        "class": classnames("".concat(prefixCls, "-header"), _defineProperty({}, "".concat(prefixCls, "-header-close-only"), closable && !title && !extra)),
        "style": headerStyle
      }, [_createVNode("div", {
        "class": "".concat(prefixCls, "-header-title")
      }, [renderCloseIcon(prefixCls), title && _createVNode("div", {
        "class": "".concat(prefixCls, "-title")
      }, [title])]), extra && _createVNode("div", {
        "class": "".concat(prefixCls, "-extra")
      }, [extra])]);
    };
    var renderCloseIcon = function renderCloseIcon(prefixCls) {
      var _a;
      var closable = props.closable;
      var $closeIcon = slots.closeIcon ? (_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots) : props.closeIcon;
      return closable && _createVNode("button", {
        "key": "closer",
        "onClick": close,
        "aria-label": "Close",
        "class": "".concat(prefixCls, "-close")
      }, [$closeIcon === undefined ? _createVNode(CloseOutlined, null, null) : $closeIcon]);
    };
    var renderBody = function renderBody(prefixCls) {
      var _a;
      if (destroyClose.value && !props.forceRender && !load.value) {
        return null;
      }
      var bodyStyle = props.bodyStyle,
        drawerStyle = props.drawerStyle;
      return _createVNode("div", {
        "class": "".concat(prefixCls, "-wrapper-body"),
        "style": drawerStyle
      }, [renderHeader(prefixCls), _createVNode("div", {
        "key": "body",
        "class": "".concat(prefixCls, "-body"),
        "style": bodyStyle
      }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]), renderFooter(prefixCls)]);
    };
    var renderFooter = function renderFooter(prefixCls) {
      var footer = getPropsSlot(slots, props, 'footer');
      if (!footer) {
        return null;
      }
      var footerClassName = "".concat(prefixCls, "-footer");
      return _createVNode("div", {
        "class": footerClassName,
        "style": props.footerStyle
      }, [footer]);
    };
    var drawerClassName = computed(function () {
      return classnames(_defineProperty({
        'no-mask': !props.mask
      }, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), props.rootClassName, hashId.value);
    });
    // =========================== Motion ===========================
    var maskMotion = computed(function () {
      return getTransitionProps(getTransitionName(prefixCls.value, 'mask-motion'));
    });
    var panelMotion = function panelMotion(motionPlacement) {
      return getTransitionProps(getTransitionName(prefixCls.value, "panel-motion-".concat(motionPlacement)));
    };
    return function () {
      var width = props.width,
        height = props.height,
        placement = props.placement,
        mask = props.mask,
        forceRender = props.forceRender,
        rest = __rest(props, ["width", "height", "placement", "mask", "forceRender"]);
      var vcDrawerProps = _extends(_extends(_extends({}, attrs), omit(rest, ['size', 'closeIcon', 'closable', 'destroyOnClose', 'drawerStyle', 'headerStyle', 'bodyStyle', 'title', 'push', 'onAfterVisibleChange', 'onClose', 'onUpdate:visible', 'onUpdate:open', 'visible'])), {
        forceRender: forceRender,
        onClose: close,
        afterVisibleChange: afterVisibleChange,
        handler: false,
        prefixCls: prefixCls.value,
        open: visible.value,
        showMask: mask,
        placement: placement,
        ref: vcDrawer
      });
      return wrapSSR(_createVNode(NoCompactStyle, null, {
        default: function _default() {
          return [_createVNode(VcDrawer, _objectSpread(_objectSpread({}, vcDrawerProps), {}, {
            "maskMotion": maskMotion.value,
            "motion": panelMotion,
            "width": mergedWidth.value,
            "height": mergedHeight.value,
            "getContainer": getContainer.value,
            "rootClassName": drawerClassName.value,
            "rootStyle": props.rootStyle,
            "contentWrapperStyle": wrapperStyle.value
          }), {
            handler: props.handle ? function () {
              return props.handle;
            } : slots.handle,
            default: function _default() {
              return renderBody(prefixCls.value);
            }
          })];
        }
      }));
    };
  }
});
export default withInstall(Drawer);