import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { defineComponent } from 'vue';
import classNames from '../_util/classNames';
import LocaleReceiver from '../locale-provider/LocaleReceiver';
import DefaultEmptyImg from './empty';
import SimpleEmptyImg from './simple';
import { filterEmpty } from '../_util/props-util';
import { anyType, objectType, withInstall } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
var defaultEmptyImg = _createVNode(DefaultEmptyImg, null, null);
var simpleEmptyImg = _createVNode(SimpleEmptyImg, null, null);
export var emptyProps = function emptyProps() {
  return {
    prefixCls: String,
    imageStyle: objectType(),
    image: anyType(),
    description: anyType()
  };
};
var Empty = defineComponent({
  name: 'AEmpty',
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: emptyProps(),
  setup: function setup(props, _ref) {
    var _ref$slots = _ref.slots,
      slots = _ref$slots === void 0 ? {} : _ref$slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('empty', props),
      direction = _useConfigInject.direction,
      prefixClsRef = _useConfigInject.prefixCls;
    var _useStyle = useStyle(prefixClsRef),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _a, _b;
      var prefixCls = prefixClsRef.value;
      var _c = _extends(_extends({}, props), attrs),
        _c$image = _c.image,
        image = _c$image === void 0 ? ((_a = slots.image) === null || _a === void 0 ? void 0 : _a.call(slots)) || defaultEmptyImg : _c$image,
        _c$description = _c.description,
        description = _c$description === void 0 ? ((_b = slots.description) === null || _b === void 0 ? void 0 : _b.call(slots)) || undefined : _c$description,
        imageStyle = _c.imageStyle,
        _c$class = _c.class,
        className = _c$class === void 0 ? '' : _c$class,
        restProps = __rest(_c, ["image", "description", "imageStyle", "class"]);
      return wrapSSR(_createVNode(LocaleReceiver, {
        "componentName": "Empty",
        "children": function children(locale) {
          var _classNames;
          var des = typeof description !== 'undefined' ? description : locale.description;
          var alt = typeof des === 'string' ? des : 'empty';
          var imageNode = null;
          if (typeof image === 'string') {
            imageNode = _createVNode("img", {
              "alt": alt,
              "src": image
            }, null);
          } else {
            imageNode = image;
          }
          return _createVNode("div", _objectSpread({
            "class": classNames(prefixCls, className, hashId.value, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-normal"), image === simpleEmptyImg), _defineProperty(_classNames, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), _classNames))
          }, restProps), [_createVNode("div", {
            "class": "".concat(prefixCls, "-image"),
            "style": imageStyle
          }, [imageNode]), des && _createVNode("p", {
            "class": "".concat(prefixCls, "-description")
          }, [des]), slots.default && _createVNode("div", {
            "class": "".concat(prefixCls, "-footer")
          }, [filterEmpty(slots.default())])]);
        }
      }, null));
    };
  }
});
Empty.PRESENTED_IMAGE_DEFAULT = defaultEmptyImg;
Empty.PRESENTED_IMAGE_SIMPLE = simpleEmptyImg;
export default withInstall(Empty);