import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";
import VerticalAlignTopOutlined from "@ant-design/icons-vue/es/icons/VerticalAlignTopOutlined";
import { getTransitionProps, Transition } from '../_util/transition';
import { defineComponent, nextTick, onActivated, onBeforeUnmount, onMounted, reactive, ref, watch, onDeactivated } from 'vue';
import FloatButton, { floatButtonPrefixCls } from './FloatButton';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import getScroll from '../_util/getScroll';
import scrollTo from '../_util/scrollTo';
import throttleByAnimationFrame from '../_util/throttleByAnimationFrame';
import { initDefaultProps } from '../_util/props-util';
import { backTopProps } from './interface';
import useStyle from './style';
import { useInjectFloatButtonGroupContext } from './context';
var BackTop = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ABackTop',
  inheritAttrs: false,
  props: initDefaultProps(backTopProps(), {
    visibilityHeight: 400,
    target: function target() {
      return window;
    },
    duration: 450,
    type: 'default',
    shape: 'circle'
  }),
  // emits: ['click'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit;
    var _useConfigInject = useConfigInject(floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 1),
      wrapSSR = _useStyle2[0];
    var domRef = ref();
    var state = reactive({
      visible: props.visibilityHeight === 0,
      scrollEvent: null
    });
    var getDefaultTarget = function getDefaultTarget() {
      return domRef.value && domRef.value.ownerDocument ? domRef.value.ownerDocument : window;
    };
    var scrollToTop = function scrollToTop(e) {
      var _props$target = props.target,
        target = _props$target === void 0 ? getDefaultTarget : _props$target,
        duration = props.duration;
      scrollTo(0, {
        getContainer: target,
        duration: duration
      });
      emit('click', e);
    };
    var handleScroll = throttleByAnimationFrame(function (e) {
      var visibilityHeight = props.visibilityHeight;
      var scrollTop = getScroll(e.target, true);
      state.visible = scrollTop >= visibilityHeight;
    });
    var bindScrollEvent = function bindScrollEvent() {
      var target = props.target;
      var getTarget = target || getDefaultTarget;
      var container = getTarget();
      handleScroll({
        target: container
      });
      container === null || container === void 0 ? void 0 : container.addEventListener('scroll', handleScroll);
    };
    var scrollRemove = function scrollRemove() {
      var target = props.target;
      var getTarget = target || getDefaultTarget;
      var container = getTarget();
      handleScroll.cancel();
      container === null || container === void 0 ? void 0 : container.removeEventListener('scroll', handleScroll);
    };
    watch(function () {
      return props.target;
    }, function () {
      scrollRemove();
      nextTick(function () {
        bindScrollEvent();
      });
    });
    onMounted(function () {
      nextTick(function () {
        bindScrollEvent();
      });
    });
    onActivated(function () {
      nextTick(function () {
        bindScrollEvent();
      });
    });
    onDeactivated(function () {
      scrollRemove();
    });
    onBeforeUnmount(function () {
      scrollRemove();
    });
    var floatButtonGroupContext = useInjectFloatButtonGroupContext();
    return function () {
      var _class;
      var defaultElement = _createVNode("div", {
        "class": "".concat(prefixCls.value, "-content")
      }, [_createVNode("div", {
        "class": "".concat(prefixCls.value, "-icon")
      }, [_createVNode(VerticalAlignTopOutlined, null, null)])]);
      var floatButtonProps = _extends(_extends({}, attrs), {
        shape: (floatButtonGroupContext === null || floatButtonGroupContext === void 0 ? void 0 : floatButtonGroupContext.shape.value) || props.shape,
        onClick: scrollToTop,
        class: (_class = {}, _defineProperty(_class, "".concat(prefixCls.value), true), _defineProperty(_class, "".concat(attrs.class), attrs.class), _defineProperty(_class, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _class)
      });
      var transitionProps = getTransitionProps('fade');
      return wrapSSR(_createVNode(Transition, transitionProps, {
        default: function _default() {
          return [_withDirectives(_createVNode(FloatButton, _objectSpread(_objectSpread({}, floatButtonProps), {}, {
            "ref": domRef
          }), {
            icon: function icon() {
              return _createVNode(VerticalAlignTopOutlined, null, null);
            },
            default: function _default() {
              var _a;
              return ((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || defaultElement;
            }
          }), [[_vShow, state.visible]])];
        }
      }));
    };
  }
});
export default BackTop;