import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { createVNode as _createVNode, Fragment as _Fragment } from "vue";
import { defineComponent } from 'vue';
import FileTextOutlined from "@ant-design/icons-vue/es/icons/FileTextOutlined";
import { floatButtonContentProps } from './interface';
import { filterEmpty } from '../_util/props-util';
var FloatButtonContent = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AFloatButtonContent',
  inheritAttrs: false,
  props: floatButtonContentProps(),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    return function () {
      var _a;
      var prefixCls = props.prefixCls;
      var description = filterEmpty((_a = slots.description) === null || _a === void 0 ? void 0 : _a.call(slots));
      return _createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [attrs.class, "".concat(prefixCls, "-content")]
      }), [slots.icon || description.length ? _createVNode(_Fragment, null, [slots.icon && _createVNode("div", {
        "class": "".concat(prefixCls, "-icon")
      }, [slots.icon()]), description.length ? _createVNode("div", {
        "class": "".concat(prefixCls, "-description")
      }, [description]) : null]) : _createVNode("div", {
        "class": "".concat(prefixCls, "-icon")
      }, [_createVNode(FileTextOutlined, null, null)])]);
    };
  }
});
export default FloatButtonContent;