import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, withDirectives as _withDirectives, createVNode as _createVNode, vShow as _vShow, Fragment as _Fragment } from "vue";
import { defineComponent, ref, computed, watch, onBeforeUnmount } from 'vue';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import FileTextOutlined from "@ant-design/icons-vue/es/icons/FileTextOutlined";
import classNames from '../_util/classNames';
import { getTransitionProps, Transition } from '../_util/transition';
import FloatButton, { floatButtonPrefixCls } from './FloatButton';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { useProvideFloatButtonGroupContext } from './context';
import { findDOMNode, initDefaultProps } from '../_util/props-util';
import { floatButtonGroupProps } from './interface';
// CSSINJS
import useStyle from './style';
import useMergedState from '../_util/hooks/useMergedState';
var FloatButtonGroup = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AFloatButtonGroup',
  inheritAttrs: false,
  props: initDefaultProps(floatButtonGroupProps(), {
    type: 'default',
    shape: 'circle'
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      emit = _ref.emit;
    var _useConfigInject = useConfigInject(floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useMergedState = useMergedState(false, {
        value: computed(function () {
          return props.open;
        })
      }),
      _useMergedState2 = _slicedToArray(_useMergedState, 2),
      open = _useMergedState2[0],
      setOpen = _useMergedState2[1];
    var floatButtonGroupRef = ref(null);
    var floatButtonRef = ref(null);
    useProvideFloatButtonGroupContext({
      shape: computed(function () {
        return props.shape;
      })
    });
    var hoverTypeAction = {
      onMouseenter: function onMouseenter() {
        var _a;
        setOpen(true);
        emit('update:open', true);
        (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, true);
      },
      onMouseleave: function onMouseleave() {
        var _a;
        setOpen(false);
        emit('update:open', false);
        (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, false);
      }
    };
    var hoverAction = computed(function () {
      return props.trigger === 'hover' ? hoverTypeAction : {};
    });
    var handleOpenChange = function handleOpenChange() {
      var _a;
      var nextOpen = !open.value;
      emit('update:open', nextOpen);
      (_a = props.onOpenChange) === null || _a === void 0 ? void 0 : _a.call(props, nextOpen);
      setOpen(nextOpen);
    };
    var onClick = function onClick(e) {
      var _a, _b, _c;
      if ((_a = floatButtonGroupRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
        if ((_b = findDOMNode(floatButtonRef.value)) === null || _b === void 0 ? void 0 : _b.contains(e.target)) {
          handleOpenChange();
        }
        return;
      }
      setOpen(false);
      emit('update:open', false);
      (_c = props.onOpenChange) === null || _c === void 0 ? void 0 : _c.call(props, false);
    };
    watch(computed(function () {
      return props.trigger;
    }), function (value) {
      document.removeEventListener('click', onClick);
      if (value === 'click') {
        document.addEventListener('click', onClick);
      }
    }, {
      immediate: true
    });
    onBeforeUnmount(function () {
      document.removeEventListener('click', onClick);
    });
    return function () {
      var _classNames;
      var _a;
      var _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'circle' : _props$shape,
        _props$type = props.type,
        type = _props$type === void 0 ? 'default' : _props$type,
        tooltip = props.tooltip,
        description = props.description,
        trigger = props.trigger;
      var groupPrefixCls = "".concat(prefixCls.value, "-group");
      var groupCls = classNames(groupPrefixCls, hashId.value, attrs.class, (_classNames = {}, _defineProperty(_classNames, "".concat(groupPrefixCls, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, "".concat(groupPrefixCls, "-").concat(shape), shape), _defineProperty(_classNames, "".concat(groupPrefixCls, "-").concat(shape, "-shadow"), !trigger), _classNames));
      var wrapperCls = classNames(hashId.value, "".concat(groupPrefixCls, "-wrap"));
      var transitionProps = getTransitionProps("".concat(groupPrefixCls, "-wrap"));
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({
        "ref": floatButtonGroupRef
      }, attrs), {}, {
        "class": groupCls
      }, hoverAction.value), [trigger && ['click', 'hover'].includes(trigger) ? _createVNode(_Fragment, null, [_createVNode(Transition, transitionProps, {
        default: function _default() {
          return [_withDirectives(_createVNode("div", {
            "class": wrapperCls
          }, [slots.default && slots.default()]), [[_vShow, open.value]])];
        }
      }), _createVNode(FloatButton, {
        "ref": floatButtonRef,
        "type": type,
        "shape": shape,
        "tooltip": tooltip,
        "description": description
      }, {
        icon: function icon() {
          var _a, _b;
          return open.value ? ((_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots)) || _createVNode(CloseOutlined, null, null) : ((_b = slots.icon) === null || _b === void 0 ? void 0 : _b.call(slots)) || _createVNode(FileTextOutlined, null, null);
        },
        tooltip: slots.tooltip,
        description: slots.description
      })]) : (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]));
    };
  }
});
export default FloatButtonGroup;