import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";
import { useInjectFormItemPrefix } from './context';
import { computed, defineComponent, ref, Transition, watch, TransitionGroup } from 'vue';
import { getTransitionGroupProps, getTransitionProps } from '../_util/transition';
import collapseMotion from '../_util/collapseMotion';
import useStyle from './style';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ErrorList',
  inheritAttrs: false,
  props: ['errors', 'help', 'onErrorVisibleChanged', 'helpStatus', 'warnings'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs;
    var _useInjectFormItemPre = useInjectFormItemPrefix(),
      prefixCls = _useInjectFormItemPre.prefixCls,
      status = _useInjectFormItemPre.status;
    var baseClassName = computed(function () {
      return "".concat(prefixCls.value, "-item-explain");
    });
    var visible = computed(function () {
      return !!(props.errors && props.errors.length);
    });
    var innerStatus = ref(status.value);
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      hashId = _useStyle2[1];
    // Memo status in same visible
    watch([visible, status], function () {
      if (visible.value) {
        innerStatus.value = status.value;
      }
    });
    return function () {
      var _a, _b;
      var colMItem = collapseMotion("".concat(prefixCls.value, "-show-help-item"));
      var transitionGroupProps = getTransitionGroupProps("".concat(prefixCls.value, "-show-help-item"), colMItem);
      transitionGroupProps.role = 'alert';
      transitionGroupProps.class = [hashId.value, baseClassName.value, attrs.class, "".concat(prefixCls.value, "-show-help")];
      return _createVNode(Transition, _objectSpread(_objectSpread({}, getTransitionProps("".concat(prefixCls.value, "-show-help"))), {}, {
        "onAfterEnter": function onAfterEnter() {
          return props.onErrorVisibleChanged(true);
        },
        "onAfterLeave": function onAfterLeave() {
          return props.onErrorVisibleChanged(false);
        }
      }), {
        default: function _default() {
          return [_withDirectives(_createVNode(TransitionGroup, _objectSpread(_objectSpread({}, transitionGroupProps), {}, {
            "tag": "div"
          }), {
            default: function _default() {
              return [(_b = props.errors) === null || _b === void 0 ? void 0 : _b.map(function (error, index) {
                return _createVNode("div", {
                  "key": index,
                  "class": innerStatus.value ? "".concat(baseClassName.value, "-").concat(innerStatus.value) : ''
                }, [error]);
              })];
            }
          }), [[_vShow, !!((_a = props.errors) === null || _a === void 0 ? void 0 : _a.length)]])];
        }
      });
    };
  }
});