import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import PreviewGroup from '../vc-image/src/PreviewGroup';
import { computed, defineComponent } from 'vue';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import RotateLeftOutlined from "@ant-design/icons-vue/es/icons/RotateLeftOutlined";
import RotateRightOutlined from "@ant-design/icons-vue/es/icons/RotateRightOutlined";
import ZoomInOutlined from "@ant-design/icons-vue/es/icons/ZoomInOutlined";
import ZoomOutOutlined from "@ant-design/icons-vue/es/icons/ZoomOutOutlined";
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import LeftOutlined from "@ant-design/icons-vue/es/icons/LeftOutlined";
import RightOutlined from "@ant-design/icons-vue/es/icons/RightOutlined";
import useStyle from './style';
import { anyType } from '../_util/type';
export var icons = {
  rotateLeft: _createVNode(RotateLeftOutlined, null, null),
  rotateRight: _createVNode(RotateRightOutlined, null, null),
  zoomIn: _createVNode(ZoomInOutlined, null, null),
  zoomOut: _createVNode(ZoomOutOutlined, null, null),
  close: _createVNode(CloseOutlined, null, null),
  left: _createVNode(LeftOutlined, null, null),
  right: _createVNode(RightOutlined, null, null)
};
var InternalPreviewGroup = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AImagePreviewGroup',
  inheritAttrs: false,
  props: {
    previewPrefixCls: String,
    preview: anyType()
  },
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = useConfigInject('image', props),
      prefixCls = _useConfigInject.prefixCls;
    var previewPrefixCls = computed(function () {
      return "".concat(prefixCls.value, "-preview");
    });
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var mergedPreview = computed(function () {
      var preview = props.preview;
      if (preview === false) {
        return preview;
      }
      var _preview = _typeof(preview) === 'object' ? preview : {};
      return _extends(_extends({}, _preview), {
        rootClassName: hashId.value
      });
    });
    return function () {
      return wrapSSR(_createVNode(PreviewGroup, _objectSpread(_objectSpread({}, _extends(_extends({}, attrs), props)), {}, {
        "preview": mergedPreview.value,
        "icons": icons,
        "previewPrefixCls": previewPrefixCls.value
      }), slots));
    };
  }
});
export default InternalPreviewGroup;