import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { watch, defineComponent, shallowRef, computed } from 'vue';
import classNames from '../_util/classNames';
import UpOutlined from "@ant-design/icons-vue/es/icons/UpOutlined";
import DownOutlined from "@ant-design/icons-vue/es/icons/DownOutlined";
import VcInputNumber, { inputNumberProps as baseInputNumberProps } from './src/InputNumber';
import { FormItemInputContext, NoFormStatus, useInjectFormItemContext } from '../form/FormItemContext';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { cloneElement } from '../_util/vnode';
import omit from '../_util/omit';
import PropTypes from '../_util/vue-types';
import isValidValue from '../_util/isValidValue';
import { getStatusClassNames, getMergedStatus } from '../_util/statusUtils';
import { booleanType, stringType } from '../_util/type';
// CSSINJS
import useStyle from './style';
import { NoCompactStyle, useCompactItemContext } from '../space/Compact';
import { useInjectDisabled } from '../config-provider/DisabledContext';
var baseProps = baseInputNumberProps();
export var inputNumberProps = function inputNumberProps() {
  return _extends(_extends({}, baseProps), {
    size: stringType(),
    bordered: booleanType(true),
    placeholder: String,
    name: String,
    id: String,
    type: String,
    addonBefore: PropTypes.any,
    addonAfter: PropTypes.any,
    prefix: PropTypes.any,
    'onUpdate:value': baseProps.onChange,
    valueModifiers: Object,
    status: stringType()
  });
};
var InputNumber = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AInputNumber',
  inheritAttrs: false,
  props: inputNumberProps(),
  // emits: ['focus', 'blur', 'change', 'input', 'update:value'],
  slots: ['addonBefore', 'addonAfter', 'prefix'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      expose = _ref.expose,
      attrs = _ref.attrs,
      slots = _ref.slots;
    var formItemContext = useInjectFormItemContext();
    var formItemInputContext = FormItemInputContext.useInject();
    var mergedStatus = computed(function () {
      return getMergedStatus(formItemInputContext.status, props.status);
    });
    var _useConfigInject = useConfigInject('input-number', props),
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      direction = _useConfigInject.direction,
      disabled = _useConfigInject.disabled;
    var _useCompactItemContex = useCompactItemContext(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    // Style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var mergedSize = computed(function () {
      return compactSize.value || size.value;
    });
    var disabledContext = useInjectDisabled();
    var mergedDisabled = computed(function () {
      var _a;
      return (_a = disabled.value) !== null && _a !== void 0 ? _a : disabledContext.value;
    });
    var mergedValue = shallowRef(props.value === undefined ? props.defaultValue : props.value);
    var focused = shallowRef(false);
    watch(function () {
      return props.value;
    }, function () {
      mergedValue.value = props.value;
    });
    var inputNumberRef = shallowRef(null);
    var focus = function focus() {
      var _a;
      (_a = inputNumberRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = inputNumberRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleChange = function handleChange(val) {
      if (props.value === undefined) {
        mergedValue.value = val;
      }
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    var handleBlur = function handleBlur(e) {
      focused.value = false;
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    var handleFocus = function handleFocus(e) {
      focused.value = true;
      emit('focus', e);
    };
    return function () {
      var _classNames;
      var _a, _b, _c, _d;
      var hasFeedback = formItemInputContext.hasFeedback,
        isFormItemInput = formItemInputContext.isFormItemInput,
        feedbackIcon = formItemInputContext.feedbackIcon;
      var id = (_a = props.id) !== null && _a !== void 0 ? _a : formItemContext.id.value;
      var _e = _extends(_extends(_extends({}, attrs), props), {
          id: id
        }),
        className = _e.class,
        bordered = _e.bordered,
        readonly = _e.readonly,
        style = _e.style,
        _e$addonBefore = _e.addonBefore,
        addonBefore = _e$addonBefore === void 0 ? (_b = slots.addonBefore) === null || _b === void 0 ? void 0 : _b.call(slots) : _e$addonBefore,
        _e$addonAfter = _e.addonAfter,
        addonAfter = _e$addonAfter === void 0 ? (_c = slots.addonAfter) === null || _c === void 0 ? void 0 : _c.call(slots) : _e$addonAfter,
        _e$prefix = _e.prefix,
        prefix = _e$prefix === void 0 ? (_d = slots.prefix) === null || _d === void 0 ? void 0 : _d.call(slots) : _e$prefix,
        _e$valueModifiers = _e.valueModifiers,
        valueModifiers = _e$valueModifiers === void 0 ? {} : _e$valueModifiers,
        others = __rest(_e, ["class", "bordered", "readonly", "style", "addonBefore", "addonAfter", "prefix", "valueModifiers"]);
      var preCls = prefixCls.value;
      var inputNumberClass = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(preCls, "-lg"), mergedSize.value === 'large'), _defineProperty(_classNames, "".concat(preCls, "-sm"), mergedSize.value === 'small'), _defineProperty(_classNames, "".concat(preCls, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, "".concat(preCls, "-readonly"), readonly), _defineProperty(_classNames, "".concat(preCls, "-borderless"), !bordered), _defineProperty(_classNames, "".concat(preCls, "-in-form-item"), isFormItemInput), _classNames), getStatusClassNames(preCls, mergedStatus.value), className, compactItemClassnames.value, hashId.value);
      var element = _createVNode(VcInputNumber, _objectSpread(_objectSpread({}, omit(others, ['size', 'defaultValue'])), {}, {
        "ref": inputNumberRef,
        "lazy": !!valueModifiers.lazy,
        "value": mergedValue.value,
        "class": inputNumberClass,
        "prefixCls": preCls,
        "readonly": readonly,
        "onChange": handleChange,
        "onBlur": handleBlur,
        "onFocus": handleFocus
      }), {
        upHandler: slots.upIcon ? function () {
          return _createVNode("span", {
            "class": "".concat(preCls, "-handler-up-inner")
          }, [slots.upIcon()]);
        } : function () {
          return _createVNode(UpOutlined, {
            "class": "".concat(preCls, "-handler-up-inner")
          }, null);
        },
        downHandler: slots.downIcon ? function () {
          return _createVNode("span", {
            "class": "".concat(preCls, "-handler-down-inner")
          }, [slots.downIcon()]);
        } : function () {
          return _createVNode(DownOutlined, {
            "class": "".concat(preCls, "-handler-down-inner")
          }, null);
        }
      });
      var hasAddon = isValidValue(addonBefore) || isValidValue(addonAfter);
      var hasPrefix = isValidValue(prefix);
      if (hasPrefix || hasFeedback) {
        var _classNames2;
        var affixWrapperCls = classNames("".concat(preCls, "-affix-wrapper"), getStatusClassNames("".concat(preCls, "-affix-wrapper"), mergedStatus.value, hasFeedback), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-focused"), focused.value), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-disabled"), mergedDisabled.value), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-sm"), mergedSize.value === 'small'), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-lg"), mergedSize.value === 'large'), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-rtl"), direction.value === 'rtl'), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-readonly"), readonly), _defineProperty(_classNames2, "".concat(preCls, "-affix-wrapper-borderless"), !bordered), _defineProperty(_classNames2, "".concat(className), !hasAddon && className), _classNames2), hashId.value);
        element = _createVNode("div", {
          "class": affixWrapperCls,
          "style": style,
          "onMouseup": function onMouseup() {
            return inputNumberRef.value.focus();
          }
        }, [hasPrefix && _createVNode("span", {
          "class": "".concat(preCls, "-prefix")
        }, [prefix]), element, hasFeedback && _createVNode("span", {
          "class": "".concat(preCls, "-suffix")
        }, [feedbackIcon])]);
      }
      if (hasAddon) {
        var _classNames4;
        var wrapperClassName = "".concat(preCls, "-group");
        var addonClassName = "".concat(wrapperClassName, "-addon");
        var addonBeforeNode = addonBefore ? _createVNode("div", {
          "class": addonClassName
        }, [addonBefore]) : null;
        var addonAfterNode = addonAfter ? _createVNode("div", {
          "class": addonClassName
        }, [addonAfter]) : null;
        var mergedWrapperClassName = classNames("".concat(preCls, "-wrapper"), wrapperClassName, _defineProperty({}, "".concat(wrapperClassName, "-rtl"), direction.value === 'rtl'), hashId.value);
        var mergedGroupClassName = classNames("".concat(preCls, "-group-wrapper"), (_classNames4 = {}, _defineProperty(_classNames4, "".concat(preCls, "-group-wrapper-sm"), mergedSize.value === 'small'), _defineProperty(_classNames4, "".concat(preCls, "-group-wrapper-lg"), mergedSize.value === 'large'), _defineProperty(_classNames4, "".concat(preCls, "-group-wrapper-rtl"), direction.value === 'rtl'), _classNames4), getStatusClassNames("".concat(prefixCls, "-group-wrapper"), mergedStatus.value, hasFeedback), className, hashId.value);
        element = _createVNode("div", {
          "class": mergedGroupClassName,
          "style": style
        }, [_createVNode("div", {
          "class": mergedWrapperClassName
        }, [addonBeforeNode && _createVNode(NoCompactStyle, null, {
          default: function _default() {
            return [_createVNode(NoFormStatus, null, {
              default: function _default() {
                return [addonBeforeNode];
              }
            })];
          }
        }), element, addonAfterNode && _createVNode(NoCompactStyle, null, {
          default: function _default() {
            return [_createVNode(NoFormStatus, null, {
              default: function _default() {
                return [addonAfterNode];
              }
            })];
          }
        })])]);
      }
      return wrapSSR(cloneElement(element, {
        style: style
      }));
    };
  }
});
export default _extends(InputNumber, {
  install: function install(app) {
    app.component(InputNumber.name, InputNumber);
    return app;
  }
});