import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode, Fragment as _Fragment } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { onBeforeUpdate, computed, onBeforeUnmount, onMounted, ref, defineComponent } from 'vue';
import classNames from '../_util/classNames';
import { FormItemInputContext, NoFormStatus, useInjectFormItemContext } from '../form/FormItemContext';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { getMergedStatus, getStatusClassNames } from '../_util/statusUtils';
import { hasPrefixSuffix } from '../vc-input/utils/commonUtils';
import VcInput from '../vc-input/Input';
import inputProps from './inputProps';
import omit from '../_util/omit';
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import { NoCompactStyle, useCompactItemContext } from '../space/Compact';
// CSSINJS
import useStyle from './style';
import { useInjectDisabled } from '../config-provider/DisabledContext';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AInput',
  inheritAttrs: false,
  props: inputProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      expose = _ref.expose,
      emit = _ref.emit;
    var inputRef = ref();
    var formItemContext = useInjectFormItemContext();
    var formItemInputContext = FormItemInputContext.useInject();
    var mergedStatus = computed(function () {
      return getMergedStatus(formItemInputContext.status, props.status);
    });
    var _useConfigInject = useConfigInject('input', props),
      direction = _useConfigInject.direction,
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      autocomplete = _useConfigInject.autocomplete;
    // ===================== Compact Item =====================
    var _useCompactItemContex = useCompactItemContext(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    var mergedSize = computed(function () {
      return compactSize.value || size.value;
    });
    // Style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var disabled = useInjectDisabled();
    var focus = function focus(option) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.focus(option);
    };
    var blur = function blur() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var setSelectionRange = function setSelectionRange(start, end, direction) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.setSelectionRange(start, end, direction);
    };
    var select = function select() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.select();
    };
    expose({
      focus: focus,
      blur: blur,
      input: inputRef,
      setSelectionRange: setSelectionRange,
      select: select
    });
    // ===================== Remove Password value =====================
    var removePasswordTimeoutRef = ref([]);
    var removePasswordTimeout = function removePasswordTimeout() {
      removePasswordTimeoutRef.value.push(setTimeout(function () {
        var _a, _b, _c, _d;
        if (((_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.input) && ((_b = inputRef.value) === null || _b === void 0 ? void 0 : _b.input.getAttribute('type')) === 'password' && ((_c = inputRef.value) === null || _c === void 0 ? void 0 : _c.input.hasAttribute('value'))) {
          (_d = inputRef.value) === null || _d === void 0 ? void 0 : _d.input.removeAttribute('value');
        }
      }));
    };
    onMounted(function () {
      removePasswordTimeout();
    });
    onBeforeUpdate(function () {
      removePasswordTimeoutRef.value.forEach(function (item) {
        return clearTimeout(item);
      });
    });
    onBeforeUnmount(function () {
      removePasswordTimeoutRef.value.forEach(function (item) {
        return clearTimeout(item);
      });
    });
    var handleBlur = function handleBlur(e) {
      removePasswordTimeout();
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    var handleFocus = function handleFocus(e) {
      removePasswordTimeout();
      emit('focus', e);
    };
    var triggerChange = function triggerChange(e) {
      emit('update:value', e.target.value);
      emit('change', e);
      emit('input', e);
      formItemContext.onFieldChange();
    };
    return function () {
      var _classNames, _classNames2, _classNames4;
      var _a, _b, _c, _d, _e, _f;
      var hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      var allowClear = props.allowClear,
        _props$bordered = props.bordered,
        bordered = _props$bordered === void 0 ? true : _props$bordered,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? (_c = slots.addonAfter) === null || _c === void 0 ? void 0 : _c.call(slots) : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? (_d = slots.addonBefore) === null || _d === void 0 ? void 0 : _d.call(slots) : _props$addonBefore,
        _props$id = props.id,
        id = _props$id === void 0 ? (_e = formItemContext.id) === null || _e === void 0 ? void 0 : _e.value : _props$id,
        rest = __rest(props, ["allowClear", "bordered", "prefix", "suffix", "addonAfter", "addonBefore", "id"]);
      var suffixNode = (hasFeedback || suffix) && _createVNode(_Fragment, null, [suffix, hasFeedback && feedbackIcon]);
      var prefixClsValue = prefixCls.value;
      var inputHasPrefixSuffix = hasPrefixSuffix({
        prefix: prefix,
        suffix: suffix
      }) || !!hasFeedback;
      var clearIcon = slots.clearIcon || function () {
        return _createVNode(CloseCircleFilled, null, null);
      };
      return wrapSSR(_createVNode(VcInput, _objectSpread(_objectSpread(_objectSpread({}, attrs), omit(rest, ['onUpdate:value', 'onChange', 'onInput'])), {}, {
        "onChange": triggerChange,
        "id": id,
        "disabled": (_f = props.disabled) !== null && _f !== void 0 ? _f : disabled.value,
        "ref": inputRef,
        "prefixCls": prefixClsValue,
        "autocomplete": autocomplete.value,
        "onBlur": handleBlur,
        "onFocus": handleFocus,
        "suffix": suffixNode,
        "allowClear": allowClear,
        "addonAfter": addonAfter && _createVNode(NoCompactStyle, null, {
          default: function _default() {
            return [_createVNode(NoFormStatus, null, {
              default: function _default() {
                return [addonAfter];
              }
            })];
          }
        }),
        "addonBefore": addonBefore && _createVNode(NoCompactStyle, null, {
          default: function _default() {
            return [_createVNode(NoFormStatus, null, {
              default: function _default() {
                return [addonBefore];
              }
            })];
          }
        }),
        "class": [attrs.class, compactItemClassnames.value],
        "inputClassName": classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixClsValue, "-sm"), mergedSize.value === 'small'), _defineProperty(_classNames, "".concat(prefixClsValue, "-lg"), mergedSize.value === 'large'), _defineProperty(_classNames, "".concat(prefixClsValue, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, "".concat(prefixClsValue, "-borderless"), !bordered), _classNames), !inputHasPrefixSuffix && getStatusClassNames(prefixClsValue, mergedStatus.value), hashId.value),
        "affixWrapperClassName": classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-sm"), mergedSize.value === 'small'), _defineProperty(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-lg"), mergedSize.value === 'large'), _defineProperty(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-rtl"), direction.value === 'rtl'), _defineProperty(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-borderless"), !bordered), _classNames2), getStatusClassNames("".concat(prefixClsValue, "-affix-wrapper"), mergedStatus.value, hasFeedback), hashId.value),
        "wrapperClassName": classNames(_defineProperty({}, "".concat(prefixClsValue, "-group-rtl"), direction.value === 'rtl'), hashId.value),
        "groupClassName": classNames((_classNames4 = {}, _defineProperty(_classNames4, "".concat(prefixClsValue, "-group-wrapper-sm"), mergedSize.value === 'small'), _defineProperty(_classNames4, "".concat(prefixClsValue, "-group-wrapper-lg"), mergedSize.value === 'large'), _defineProperty(_classNames4, "".concat(prefixClsValue, "-group-wrapper-rtl"), direction.value === 'rtl'), _classNames4), getStatusClassNames("".concat(prefixClsValue, "-group-wrapper"), mergedStatus.value, hasFeedback), hashId.value)
      }), _extends(_extends({}, slots), {
        clearIcon: clearIcon
      })));
    };
  }
});