import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";
import { computed, createVNode, defineComponent, provide, ref } from 'vue';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { SiderHookProviderKey } from './injectionKey';
import useStyle from './style';
export var basicProps = function basicProps() {
  return {
    prefixCls: String,
    hasSider: {
      type: Boolean,
      default: undefined
    },
    tagName: String
  };
};
function generator(_ref) {
  var suffixCls = _ref.suffixCls,
    tagName = _ref.tagName,
    name = _ref.name;
  return function (BasicComponent) {
    var Adapter = defineComponent({
      compatConfig: {
        MODE: 3
      },
      name: name,
      props: basicProps(),
      setup: function setup(props, _ref2) {
        var slots = _ref2.slots;
        var _useConfigInject = useConfigInject(suffixCls, props),
          prefixCls = _useConfigInject.prefixCls;
        return function () {
          var basicComponentProps = _extends(_extends({}, props), {
            prefixCls: prefixCls.value,
            tagName: tagName
          });
          return _createVNode(BasicComponent, basicComponentProps, slots);
        };
      }
    });
    return Adapter;
  };
}
var Basic = defineComponent({
  compatConfig: {
    MODE: 3
  },
  props: basicProps(),
  setup: function setup(props, _ref3) {
    var slots = _ref3.slots;
    return function () {
      return createVNode(props.tagName, {
        class: props.prefixCls
      }, slots);
    };
  }
});
var BasicLayout = defineComponent({
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: basicProps(),
  setup: function setup(props, _ref4) {
    var slots = _ref4.slots,
      attrs = _ref4.attrs;
    var _useConfigInject2 = useConfigInject('', props),
      prefixCls = _useConfigInject2.prefixCls,
      direction = _useConfigInject2.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var siders = ref([]);
    var siderHookProvider = {
      addSider: function addSider(id) {
        siders.value = [].concat(_toConsumableArray(siders.value), [id]);
      },
      removeSider: function removeSider(id) {
        siders.value = siders.value.filter(function (currentId) {
          return currentId !== id;
        });
      }
    };
    provide(SiderHookProviderKey, siderHookProvider);
    var divCls = computed(function () {
      var _ref5;
      var prefixCls = props.prefixCls,
        hasSider = props.hasSider;
      return _ref5 = {}, _defineProperty(_ref5, hashId.value, true), _defineProperty(_ref5, "".concat(prefixCls), true), _defineProperty(_ref5, "".concat(prefixCls, "-has-sider"), typeof hasSider === 'boolean' ? hasSider : siders.value.length > 0), _defineProperty(_ref5, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), _ref5;
    });
    return function () {
      var tagName = props.tagName;
      return wrapSSR(createVNode(tagName, _extends(_extends({}, attrs), {
        class: [divCls.value, attrs.class]
      }), slots));
    };
  }
});
var Layout = generator({
  suffixCls: 'layout',
  tagName: 'section',
  name: 'ALayout'
})(BasicLayout);
var Header = generator({
  suffixCls: 'layout-header',
  tagName: 'header',
  name: 'ALayoutHeader'
})(Basic);
var Footer = generator({
  suffixCls: 'layout-footer',
  tagName: 'footer',
  name: 'ALayoutFooter'
})(Basic);
var Content = generator({
  suffixCls: 'layout-content',
  tagName: 'main',
  name: 'ALayoutContent'
})(Basic);
export { Header, Footer, Content };
export default Layout;