import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";
import Trigger from '../../vc-trigger';
import { computed, defineComponent, onBeforeUnmount, shallowRef, watch } from 'vue';
import { useInjectForceRender, useInjectMenu } from './hooks/useMenuContext';
import { placements, placementsRtl } from './placements';
import raf from '../../_util/raf';
import classNames from '../../_util/classNames';
import { getTransitionProps } from '../../_util/transition';
var popupPlacementMap = {
  horizontal: 'bottomLeft',
  vertical: 'rightTop',
  'vertical-left': 'rightTop',
  'vertical-right': 'leftTop'
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'PopupTrigger',
  inheritAttrs: false,
  props: {
    prefixCls: String,
    mode: String,
    visible: Boolean,
    // popup: React.ReactNode;
    popupClassName: String,
    popupOffset: Array,
    disabled: Boolean,
    onVisibleChange: Function
  },
  slots: ['popup'],
  emits: ['visibleChange'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit;
    var innerVisible = shallowRef(false);
    var _useInjectMenu = useInjectMenu(),
      getPopupContainer = _useInjectMenu.getPopupContainer,
      rtl = _useInjectMenu.rtl,
      subMenuOpenDelay = _useInjectMenu.subMenuOpenDelay,
      subMenuCloseDelay = _useInjectMenu.subMenuCloseDelay,
      builtinPlacements = _useInjectMenu.builtinPlacements,
      triggerSubMenuAction = _useInjectMenu.triggerSubMenuAction,
      forceSubMenuRender = _useInjectMenu.forceSubMenuRender,
      motion = _useInjectMenu.motion,
      defaultMotions = _useInjectMenu.defaultMotions,
      rootClassName = _useInjectMenu.rootClassName;
    var forceRender = useInjectForceRender();
    var placement = computed(function () {
      return rtl.value ? _extends(_extends({}, placementsRtl), builtinPlacements.value) : _extends(_extends({}, placements), builtinPlacements.value);
    });
    var popupPlacement = computed(function () {
      return popupPlacementMap[props.mode];
    });
    var visibleRef = shallowRef();
    watch(function () {
      return props.visible;
    }, function (visible) {
      raf.cancel(visibleRef.value);
      visibleRef.value = raf(function () {
        innerVisible.value = visible;
      });
    }, {
      immediate: true
    });
    onBeforeUnmount(function () {
      raf.cancel(visibleRef.value);
    });
    var onVisibleChange = function onVisibleChange(visible) {
      emit('visibleChange', visible);
    };
    var mergedMotion = computed(function () {
      var _a, _b;
      var m = motion.value || ((_a = defaultMotions.value) === null || _a === void 0 ? void 0 : _a[props.mode]) || ((_b = defaultMotions.value) === null || _b === void 0 ? void 0 : _b.other);
      var res = typeof m === 'function' ? m() : m;
      return res ? getTransitionProps(res.name, {
        css: true
      }) : undefined;
    });
    return function () {
      var prefixCls = props.prefixCls,
        popupClassName = props.popupClassName,
        mode = props.mode,
        popupOffset = props.popupOffset,
        disabled = props.disabled;
      return _createVNode(Trigger, {
        "prefixCls": prefixCls,
        "popupClassName": classNames("".concat(prefixCls, "-popup"), _defineProperty({}, "".concat(prefixCls, "-rtl"), rtl.value), popupClassName, rootClassName.value),
        "stretch": mode === 'horizontal' ? 'minWidth' : null,
        "getPopupContainer": getPopupContainer.value,
        "builtinPlacements": placement.value,
        "popupPlacement": popupPlacement.value,
        "popupVisible": innerVisible.value,
        "popupAlign": popupOffset && {
          offset: popupOffset
        },
        "action": disabled ? [] : [triggerSubMenuAction.value],
        "mouseEnterDelay": subMenuOpenDelay.value,
        "mouseLeaveDelay": subMenuCloseDelay.value,
        "onPopupVisibleChange": onVisibleChange,
        "forceRender": forceRender || forceSubMenuRender.value,
        "popupAnimation": mergedMotion.value
      }, {
        popup: slots.popup,
        default: slots.default
      });
    };
  }
});