import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { textEllipsis } from '../../style';
var getVerticalInlineStyle = function getVerticalInlineStyle(token) {
  var _ref;
  var componentCls = token.componentCls,
    menuItemHeight = token.menuItemHeight,
    itemMarginInline = token.itemMarginInline,
    padding = token.padding,
    menuArrowSize = token.menuArrowSize,
    marginXS = token.marginXS,
    marginXXS = token.marginXXS;
  var paddingWithArrow = padding + menuArrowSize + marginXS;
  return _ref = {}, _defineProperty(_ref, "".concat(componentCls, "-item"), {
    position: 'relative'
  }), _defineProperty(_ref, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px"),
    paddingInline: padding,
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    marginInline: itemMarginInline,
    marginBlock: marginXXS,
    width: "calc(100% - ".concat(itemMarginInline * 2, "px)")
  }), _defineProperty(_ref, "".concat(componentCls, "-submenu"), {
    paddingBottom: 0.02
  }), _defineProperty(_ref, "> ".concat(componentCls, "-item,\n            > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px")
  }), _defineProperty(_ref, "".concat(componentCls, "-item-group-list ").concat(componentCls, "-submenu-title,\n            ").concat(componentCls, "-submenu-title"), {
    paddingInlineEnd: paddingWithArrow
  }), _ref;
};
var getVerticalStyle = function getVerticalStyle(token) {
  var _ref2, _$concat$concat, _$concat$concat2, _$concat3, _$concat$concat$con, _tooltip, _$concat5;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    menuItemHeight = token.menuItemHeight,
    colorTextLightSolid = token.colorTextLightSolid,
    dropdownWidth = token.dropdownWidth,
    controlHeightLG = token.controlHeightLG,
    motionDurationMid = token.motionDurationMid,
    motionEaseOut = token.motionEaseOut,
    paddingXL = token.paddingXL,
    fontSizeSM = token.fontSizeSM,
    fontSizeLG = token.fontSizeLG,
    motionDurationSlow = token.motionDurationSlow,
    paddingXS = token.paddingXS,
    boxShadowSecondary = token.boxShadowSecondary;
  var inlineItemStyle = {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px"),
    listStylePosition: 'inside',
    listStyleType: 'disc'
  };
  return [(_ref2 = {}, _defineProperty(_ref2, componentCls, _defineProperty({}, "&-inline, &-vertical", _extends(_defineProperty({}, "&".concat(componentCls, "-root"), {
    boxShadow: 'none'
  }), getVerticalInlineStyle(token)))), _defineProperty(_ref2, "".concat(componentCls, "-submenu-popup"), _defineProperty({}, "".concat(componentCls, "-vertical"), _extends(_extends({}, getVerticalInlineStyle(token)), {
    boxShadow: boxShadowSecondary
  }))), _ref2), // Vertical only
  _defineProperty({}, "".concat(componentCls, "-submenu-popup ").concat(componentCls, "-vertical").concat(componentCls, "-sub"), {
    minWidth: dropdownWidth,
    maxHeight: "calc(100vh - ".concat(controlHeightLG * 2.5, "px)"),
    padding: '0',
    overflow: 'hidden',
    borderInlineEnd: 0,
    // https://github.com/ant-design/ant-design/issues/22244
    // https://github.com/ant-design/ant-design/issues/26812
    "&:not([class*='-active'])": {
      overflowX: 'hidden',
      overflowY: 'auto'
    }
  }), // Inline Only
  _defineProperty({}, "".concat(componentCls, "-inline"), (_$concat3 = {
    width: '100%'
  }, _defineProperty(_$concat3, "&".concat(componentCls, "-root"), _defineProperty({}, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), (_$concat$concat = {
    display: 'flex',
    alignItems: 'center',
    transition: ["border-color ".concat(motionDurationSlow), "background ".concat(motionDurationSlow), "padding ".concat(motionDurationMid, " ").concat(motionEaseOut)].join(',')
  }, _defineProperty(_$concat$concat, "> ".concat(componentCls, "-title-content"), {
    flex: 'auto',
    minWidth: 0,
    overflow: 'hidden',
    textOverflow: 'ellipsis'
  }), _defineProperty(_$concat$concat, '> *', {
    flex: 'none'
  }), _$concat$concat))), _defineProperty(_$concat3, "".concat(componentCls, "-sub").concat(componentCls, "-inline"), (_$concat$concat2 = {
    padding: 0,
    border: 0,
    borderRadius: 0,
    boxShadow: 'none'
  }, _defineProperty(_$concat$concat2, "& > ".concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), inlineItemStyle), _defineProperty(_$concat$concat2, "& ".concat(componentCls, "-item-group-title"), {
    paddingInlineStart: paddingXL
  }), _$concat$concat2)), _defineProperty(_$concat3, "".concat(componentCls, "-item"), inlineItemStyle), _$concat3)), // Inline Collapse Only
  _defineProperty({}, "".concat(componentCls, "-inline-collapsed"), (_$concat5 = {
    width: menuItemHeight * 2
  }, _defineProperty(_$concat5, "&".concat(componentCls, "-root"), _defineProperty({}, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu ").concat(componentCls, "-submenu-title"), _defineProperty({}, "> ".concat(componentCls, "-inline-collapsed-noicon"), {
    fontSize: fontSizeLG,
    textAlign: 'center'
  }))), _defineProperty(_$concat5, "> ".concat(componentCls, "-item,\n          > ").concat(componentCls, "-item-group > ").concat(componentCls, "-item-group-list > ").concat(componentCls, "-item,\n          > ").concat(componentCls, "-item-group > ").concat(componentCls, "-item-group-list > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title,\n          > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), (_$concat$concat$con = {
    insetInlineStart: 0,
    paddingInline: "calc(50% - ".concat(fontSizeSM, "px)"),
    textOverflow: 'clip'
  }, _defineProperty(_$concat$concat$con, "\n            ".concat(componentCls, "-submenu-arrow,\n            ").concat(componentCls, "-submenu-expand-icon\n          "), {
    opacity: 0
  }), _defineProperty(_$concat$concat$con, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    margin: 0,
    fontSize: fontSizeLG,
    lineHeight: "".concat(menuItemHeight, "px"),
    '+ span': {
      display: 'inline-block',
      opacity: 0
    }
  }), _$concat$concat$con)), _defineProperty(_$concat5, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    display: 'inline-block'
  }), _defineProperty(_$concat5, '&-tooltip', (_tooltip = {
    pointerEvents: 'none'
  }, _defineProperty(_tooltip, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    display: 'none'
  }), _defineProperty(_tooltip, 'a, a:hover', {
    color: colorTextLightSolid
  }), _tooltip)), _defineProperty(_$concat5, "".concat(componentCls, "-item-group-title"), _extends(_extends({}, textEllipsis), {
    paddingInline: paddingXS
  })), _$concat5))];
};
export default getVerticalStyle;