import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
// deps-lint-skip-all
import { Keyframes } from '../../_util/cssinjs';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent } from '../../style';
var genMessageStyle = function genMessageStyle(token) {
  var _extends2, _$concat;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    boxShadowSecondary = token.boxShadowSecondary,
    colorBgElevated = token.colorBgElevated,
    colorSuccess = token.colorSuccess,
    colorError = token.colorError,
    colorWarning = token.colorWarning,
    colorInfo = token.colorInfo,
    fontSizeLG = token.fontSizeLG,
    motionEaseInOutCirc = token.motionEaseInOutCirc,
    motionDurationSlow = token.motionDurationSlow,
    marginXS = token.marginXS,
    paddingXS = token.paddingXS,
    borderRadiusLG = token.borderRadiusLG,
    zIndexPopup = token.zIndexPopup,
    messageNoticeContentPadding = token.messageNoticeContentPadding;
  var messageMoveIn = new Keyframes('MessageMoveIn', {
    '0%': {
      padding: 0,
      transform: 'translateY(-100%)',
      opacity: 0
    },
    '100%': {
      padding: paddingXS,
      transform: 'translateY(0)',
      opacity: 1
    }
  });
  var messageMoveOut = new Keyframes('MessageMoveOut', {
    '0%': {
      maxHeight: token.height,
      padding: paddingXS,
      opacity: 1
    },
    '100%': {
      maxHeight: 0,
      padding: 0,
      opacity: 0
    }
  });
  return [// ============================ Holder ============================
  _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'fixed',
    top: marginXS,
    width: '100%',
    pointerEvents: 'none',
    zIndex: zIndexPopup
  }, _defineProperty(_extends2, "".concat(componentCls, "-move-up"), {
    animationFillMode: 'forwards'
  }), _defineProperty(_extends2, "\n        ".concat(componentCls, "-move-up-appear,\n        ").concat(componentCls, "-move-up-enter\n      "), {
    animationName: messageMoveIn,
    animationDuration: motionDurationSlow,
    animationPlayState: 'paused',
    animationTimingFunction: motionEaseInOutCirc
  }), _defineProperty(_extends2, "\n        ".concat(componentCls, "-move-up-appear").concat(componentCls, "-move-up-appear-active,\n        ").concat(componentCls, "-move-up-enter").concat(componentCls, "-move-up-enter-active\n      "), {
    animationPlayState: 'running'
  }), _defineProperty(_extends2, "".concat(componentCls, "-move-up-leave"), {
    animationName: messageMoveOut,
    animationDuration: motionDurationSlow,
    animationPlayState: 'paused',
    animationTimingFunction: motionEaseInOutCirc
  }), _defineProperty(_extends2, "".concat(componentCls, "-move-up-leave").concat(componentCls, "-move-up-leave-active"), {
    animationPlayState: 'running'
  }), _defineProperty(_extends2, '&-rtl', {
    direction: 'rtl',
    span: {
      direction: 'rtl'
    }
  }), _extends2))), // ============================ Notice ============================
  _defineProperty({}, "".concat(componentCls, "-notice"), (_$concat = {
    padding: paddingXS,
    textAlign: 'center'
  }, _defineProperty(_$concat, iconCls, {
    verticalAlign: 'text-bottom',
    marginInlineEnd: marginXS,
    fontSize: fontSizeLG
  }), _defineProperty(_$concat, "".concat(componentCls, "-notice-content"), {
    display: 'inline-block',
    padding: messageNoticeContentPadding,
    background: colorBgElevated,
    borderRadius: borderRadiusLG,
    boxShadow: boxShadowSecondary,
    pointerEvents: 'all'
  }), _defineProperty(_$concat, "".concat(componentCls, "-success ").concat(iconCls), {
    color: colorSuccess
  }), _defineProperty(_$concat, "".concat(componentCls, "-error ").concat(iconCls), {
    color: colorError
  }), _defineProperty(_$concat, "".concat(componentCls, "-warning ").concat(iconCls), {
    color: colorWarning
  }), _defineProperty(_$concat, "\n        ".concat(componentCls, "-info ").concat(iconCls, ",\n        ").concat(componentCls, "-loading ").concat(iconCls), {
    color: colorInfo
  }), _$concat)), // ============================= Pure =============================
  _defineProperty({}, "".concat(componentCls, "-notice-pure-panel"), {
    padding: 0,
    textAlign: 'start'
  })];
};
// ============================== Export ==============================
export default genComponentStyleHook('Message', function (token) {
  // Gen-style functions here
  var combinedToken = mergeToken(token, {
    messageNoticeContentPadding: "".concat((token.controlHeightLG - token.fontSize * token.lineHeight) / 2, "px ").concat(token.paddingSM, "px")
  });
  return [genMessageStyle(combinedToken)];
}, function (token) {
  return {
    height: 150,
    zIndexPopup: token.zIndexPopupBase + 10
  };
});