import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import CheckCircleFilled from "@ant-design/icons-vue/es/icons/CheckCircleFilled";
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import ExclamationCircleFilled from "@ant-design/icons-vue/es/icons/ExclamationCircleFilled";
import InfoCircleFilled from "@ant-design/icons-vue/es/icons/InfoCircleFilled";
import classNames from '../_util/classNames';
import Dialog from './Modal';
import ActionButton from '../_util/ActionButton';
import { defineComponent } from 'vue';
import { useLocaleReceiver } from '../locale-provider/LocaleReceiver';
import { getTransitionName } from '../_util/transition';
import warning from '../_util/warning';
function renderSomeContent(someContent) {
  if (typeof someContent === 'function') {
    return someContent();
  }
  return someContent;
}
export default defineComponent({
  name: 'ConfirmDialog',
  inheritAttrs: false,
  props: ['icon', 'onCancel', 'onOk', 'close', 'closable', 'zIndex', 'afterClose', 'visible', 'open', 'keyboard', 'centered', 'getContainer', 'maskStyle', 'okButtonProps', 'cancelButtonProps', 'okType', 'prefixCls', 'okCancel', 'width', 'mask', 'maskClosable', 'okText', 'cancelText', 'autoFocusButton', 'transitionName', 'maskTransitionName', 'type', 'title', 'content', 'direction', 'rootPrefixCls', 'bodyStyle', 'closeIcon', 'modalRender', 'focusTriggerAfterClose', 'wrapClassName', 'confirmPrefixCls', 'footer'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs;
    var _useLocaleReceiver = useLocaleReceiver('Modal'),
      _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
      locale = _useLocaleReceiver2[0];
    if (process.env.NODE_ENV !== 'production') {
      warning(props.visible === undefined, 'Modal', "`visible` is deprecated, please use `open` instead.");
    }
    return function () {
      var icon = props.icon,
        onCancel = props.onCancel,
        onOk = props.onOk,
        close = props.close,
        _props$closable = props.closable,
        closable = _props$closable === void 0 ? false : _props$closable,
        zIndex = props.zIndex,
        afterClose = props.afterClose,
        keyboard = props.keyboard,
        centered = props.centered,
        getContainer = props.getContainer,
        maskStyle = props.maskStyle,
        okButtonProps = props.okButtonProps,
        cancelButtonProps = props.cancelButtonProps,
        okCancel = props.okCancel,
        _props$width = props.width,
        width = _props$width === void 0 ? 416 : _props$width,
        _props$mask = props.mask,
        mask = _props$mask === void 0 ? true : _props$mask,
        _props$maskClosable = props.maskClosable,
        maskClosable = _props$maskClosable === void 0 ? false : _props$maskClosable,
        type = props.type,
        open = props.open,
        title = props.title,
        content = props.content,
        direction = props.direction,
        closeIcon = props.closeIcon,
        modalRender = props.modalRender,
        focusTriggerAfterClose = props.focusTriggerAfterClose,
        rootPrefixCls = props.rootPrefixCls,
        bodyStyle = props.bodyStyle,
        wrapClassName = props.wrapClassName,
        footer = props.footer;
      // Icon
      var mergedIcon = icon;
      // 支持传入{ icon: null }来隐藏`Modal.confirm`默认的Icon
      if (!icon && icon !== null) {
        switch (type) {
          case 'info':
            mergedIcon = _createVNode(InfoCircleFilled, null, null);
            break;
          case 'success':
            mergedIcon = _createVNode(CheckCircleFilled, null, null);
            break;
          case 'error':
            mergedIcon = _createVNode(CloseCircleFilled, null, null);
            break;
          default:
            mergedIcon = _createVNode(ExclamationCircleFilled, null, null);
        }
      }
      var okType = props.okType || 'primary';
      var prefixCls = props.prefixCls || 'ant-modal';
      var contentPrefixCls = "".concat(prefixCls, "-confirm");
      var style = attrs.style || {};
      var okText = renderSomeContent(props.okText) || (okCancel ? locale.value.okText : locale.value.justOkText);
      var mergedOkCancel = okCancel !== null && okCancel !== void 0 ? okCancel : type === 'confirm';
      var autoFocusButton = props.autoFocusButton === null ? false : props.autoFocusButton || 'ok';
      var confirmPrefixCls = "".concat(prefixCls, "-confirm");
      var classString = classNames(confirmPrefixCls, "".concat(confirmPrefixCls, "-").concat(props.type), _defineProperty({}, "".concat(confirmPrefixCls, "-rtl"), direction === 'rtl'), attrs.class);
      var cancelButton = mergedOkCancel && _createVNode(ActionButton, {
        "actionFn": onCancel,
        "close": close,
        "autofocus": autoFocusButton === 'cancel',
        "buttonProps": cancelButtonProps,
        "prefixCls": "".concat(rootPrefixCls, "-btn")
      }, {
        default: function _default() {
          return [renderSomeContent(props.cancelText) || locale.value.cancelText];
        }
      });
      return _createVNode(Dialog, {
        "prefixCls": prefixCls,
        "class": classString,
        "wrapClassName": classNames(_defineProperty({}, "".concat(confirmPrefixCls, "-centered"), !!centered), wrapClassName),
        "onCancel": function onCancel(e) {
          return close === null || close === void 0 ? void 0 : close({
            triggerCancel: true
          }, e);
        },
        "open": open,
        "title": "",
        "footer": "",
        "transitionName": getTransitionName(rootPrefixCls, 'zoom', props.transitionName),
        "maskTransitionName": getTransitionName(rootPrefixCls, 'fade', props.maskTransitionName),
        "mask": mask,
        "maskClosable": maskClosable,
        "maskStyle": maskStyle,
        "style": style,
        "bodyStyle": bodyStyle,
        "width": width,
        "zIndex": zIndex,
        "afterClose": afterClose,
        "keyboard": keyboard,
        "centered": centered,
        "getContainer": getContainer,
        "closable": closable,
        "closeIcon": closeIcon,
        "modalRender": modalRender,
        "focusTriggerAfterClose": focusTriggerAfterClose
      }, {
        default: function _default() {
          return [_createVNode("div", {
            "class": "".concat(contentPrefixCls, "-body-wrapper")
          }, [_createVNode("div", {
            "class": "".concat(contentPrefixCls, "-body")
          }, [renderSomeContent(mergedIcon), title === undefined ? null : _createVNode("span", {
            "class": "".concat(contentPrefixCls, "-title")
          }, [renderSomeContent(title)]), _createVNode("div", {
            "class": "".concat(contentPrefixCls, "-content")
          }, [renderSomeContent(content)])]), footer !== undefined ? renderSomeContent(footer) : _createVNode("div", {
            "class": "".concat(contentPrefixCls, "-btns")
          }, [cancelButton, _createVNode(ActionButton, {
            "type": okType,
            "actionFn": onOk,
            "close": close,
            "autofocus": autoFocusButton === 'ok',
            "buttonProps": okButtonProps,
            "prefixCls": "".concat(rootPrefixCls, "-btn")
          }, {
            default: function _default() {
              return [okText];
            }
          })])])];
        }
      });
    };
  }
});