import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { initFadeMotion, initZoomMotion } from '../../style/motion';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { clearFix, genFocusStyle, resetComponent } from '../../style';
import 'vue';
function box(position) {
  return {
    position: position,
    top: 0,
    insetInlineEnd: 0,
    bottom: 0,
    insetInlineStart: 0
  };
}
export var genModalMaskStyle = function genModalMaskStyle(token) {
  var _$concat;
  var componentCls = token.componentCls;
  return [_defineProperty({}, "".concat(componentCls, "-root"), (_$concat = {}, _defineProperty(_$concat, "".concat(componentCls).concat(token.antCls, "-zoom-enter, ").concat(componentCls).concat(token.antCls, "-zoom-appear"), {
    // reset scale avoid mousePosition bug
    transform: 'none',
    opacity: 0,
    animationDuration: token.motionDurationSlow,
    // https://github.com/ant-design/ant-design/issues/11777
    userSelect: 'none'
  }), _defineProperty(_$concat, "".concat(componentCls, "-mask"), _extends(_extends({}, box('fixed')), _defineProperty({
    zIndex: token.zIndexPopupBase,
    height: '100%',
    backgroundColor: token.colorBgMask
  }, "".concat(componentCls, "-hidden"), {
    display: 'none'
  }))), _defineProperty(_$concat, "".concat(componentCls, "-wrap"), _extends(_extends({}, box('fixed')), {
    overflow: 'auto',
    outline: 0,
    WebkitOverflowScrolling: 'touch'
  })), _$concat)), _defineProperty({}, "".concat(componentCls, "-root"), initFadeMotion(token))];
};
var genModalStyle = function genModalStyle(token) {
  var _mediaMaxWidth$, _$concat4, _extends3, _$concat6;
  var componentCls = token.componentCls;
  return [// ======================== Root =========================
  _defineProperty({}, "".concat(componentCls, "-root"), (_$concat4 = {}, _defineProperty(_$concat4, "".concat(componentCls, "-wrap"), {
    zIndex: token.zIndexPopupBase,
    position: 'fixed',
    inset: 0,
    overflow: 'auto',
    outline: 0,
    WebkitOverflowScrolling: 'touch'
  }), _defineProperty(_$concat4, "".concat(componentCls, "-wrap-rtl"), {
    direction: 'rtl'
  }), _defineProperty(_$concat4, "".concat(componentCls, "-centered"), _defineProperty({
    textAlign: 'center',
    '&::before': {
      display: 'inline-block',
      width: 0,
      height: '100%',
      verticalAlign: 'middle',
      content: '""'
    }
  }, componentCls, {
    top: 0,
    display: 'inline-block',
    paddingBottom: 0,
    textAlign: 'start',
    verticalAlign: 'middle'
  })), _defineProperty(_$concat4, "@media (max-width: ".concat(token.screenSMMax, ")"), (_mediaMaxWidth$ = {}, _defineProperty(_mediaMaxWidth$, componentCls, {
    maxWidth: 'calc(100vw - 16px)',
    margin: "".concat(token.marginXS, " auto")
  }), _defineProperty(_mediaMaxWidth$, "".concat(componentCls, "-centered"), _defineProperty({}, componentCls, {
    flex: 1
  })), _mediaMaxWidth$)), _$concat4)), // ======================== Modal ========================
  _defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends3 = {
    pointerEvents: 'none',
    position: 'relative',
    top: 100,
    width: 'auto',
    maxWidth: "calc(100vw - ".concat(token.margin * 2, "px)"),
    margin: '0 auto',
    paddingBottom: token.paddingLG
  }, _defineProperty(_extends3, "".concat(componentCls, "-title"), {
    margin: 0,
    color: token.modalHeadingColor,
    fontWeight: token.fontWeightStrong,
    fontSize: token.modalHeaderTitleFontSize,
    lineHeight: token.modalHeaderTitleLineHeight,
    wordWrap: 'break-word'
  }), _defineProperty(_extends3, "".concat(componentCls, "-content"), {
    position: 'relative',
    backgroundColor: token.modalContentBg,
    backgroundClip: 'padding-box',
    border: 0,
    borderRadius: token.borderRadiusLG,
    boxShadow: token.boxShadowSecondary,
    pointerEvents: 'auto',
    padding: "".concat(token.paddingMD, "px ").concat(token.paddingContentHorizontalLG, "px")
  }), _defineProperty(_extends3, "".concat(componentCls, "-close"), _extends({
    position: 'absolute',
    top: (token.modalHeaderCloseSize - token.modalCloseBtnSize) / 2,
    insetInlineEnd: (token.modalHeaderCloseSize - token.modalCloseBtnSize) / 2,
    zIndex: token.zIndexPopupBase + 10,
    padding: 0,
    color: token.modalCloseColor,
    fontWeight: token.fontWeightStrong,
    lineHeight: 1,
    textDecoration: 'none',
    background: 'transparent',
    borderRadius: token.borderRadiusSM,
    width: token.modalConfirmIconSize,
    height: token.modalConfirmIconSize,
    border: 0,
    outline: 0,
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationMid, ", background-color ").concat(token.motionDurationMid),
    '&-x': {
      display: 'block',
      fontSize: token.fontSizeLG,
      fontStyle: 'normal',
      lineHeight: "".concat(token.modalCloseBtnSize, "px"),
      textAlign: 'center',
      textTransform: 'none',
      textRendering: 'auto'
    },
    '&:hover': {
      color: token.modalIconHoverColor,
      backgroundColor: token.wireframe ? 'transparent' : token.colorFillContent,
      textDecoration: 'none'
    },
    '&:active': {
      backgroundColor: token.wireframe ? 'transparent' : token.colorFillContentHover
    }
  }, genFocusStyle(token))), _defineProperty(_extends3, "".concat(componentCls, "-header"), {
    color: token.colorText,
    background: token.modalHeaderBg,
    borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0"),
    marginBottom: token.marginXS
  }), _defineProperty(_extends3, "".concat(componentCls, "-body"), {
    fontSize: token.fontSize,
    lineHeight: token.lineHeight,
    wordWrap: 'break-word'
  }), _defineProperty(_extends3, "".concat(componentCls, "-footer"), _defineProperty({
    textAlign: 'end',
    background: token.modalFooterBg,
    marginTop: token.marginSM
  }, "".concat(token.antCls, "-btn + ").concat(token.antCls, "-btn:not(").concat(token.antCls, "-dropdown-trigger)"), {
    marginBottom: 0,
    marginInlineStart: token.marginXS
  })), _defineProperty(_extends3, "".concat(componentCls, "-open"), {
    overflow: 'hidden'
  }), _extends3))), // ======================== Pure =========================
  _defineProperty({}, "".concat(componentCls, "-pure-panel"), (_$concat6 = {
    top: 'auto',
    padding: 0,
    display: 'flex',
    flexDirection: 'column'
  }, _defineProperty(_$concat6, "".concat(componentCls, "-content,\n          ").concat(componentCls, "-body,\n          ").concat(componentCls, "-confirm-body-wrapper"), {
    display: 'flex',
    flexDirection: 'column',
    flex: 'auto'
  }), _defineProperty(_$concat6, "".concat(componentCls, "-confirm-body"), {
    marginBottom: 'auto'
  }), _$concat6))];
};
var genModalConfirmStyle = function genModalConfirmStyle(token) {
  var _$concat8, _$concat9, _confirmComponentCls, _ref6;
  var componentCls = token.componentCls;
  var confirmComponentCls = "".concat(componentCls, "-confirm");
  return _ref6 = {}, _defineProperty(_ref6, confirmComponentCls, (_confirmComponentCls = {
    '&-rtl': {
      direction: 'rtl'
    }
  }, _defineProperty(_confirmComponentCls, "".concat(token.antCls, "-modal-header"), {
    display: 'none'
  }), _defineProperty(_confirmComponentCls, "".concat(confirmComponentCls, "-body-wrapper"), _extends({}, clearFix())), _defineProperty(_confirmComponentCls, "".concat(confirmComponentCls, "-body"), (_$concat9 = {
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center'
  }, _defineProperty(_$concat9, "".concat(confirmComponentCls, "-title"), _defineProperty({
    flex: '0 0 100%',
    display: 'block',
    // create BFC to avoid
    // https://user-images.githubusercontent.com/507615/37702510-ba844e06-2d2d-11e8-9b67-8e19be57f445.png
    overflow: 'hidden',
    color: token.colorTextHeading,
    fontWeight: token.fontWeightStrong,
    fontSize: token.modalHeaderTitleFontSize,
    lineHeight: token.modalHeaderTitleLineHeight
  }, "+ ".concat(confirmComponentCls, "-content"), {
    marginBlockStart: token.marginXS,
    flexBasis: '100%',
    maxWidth: "calc(100% - ".concat(token.modalConfirmIconSize + token.marginSM, "px)")
  })), _defineProperty(_$concat9, "".concat(confirmComponentCls, "-content"), {
    color: token.colorText,
    fontSize: token.fontSize
  }), _defineProperty(_$concat9, "> ".concat(token.iconCls), (_$concat8 = {
    flex: 'none',
    marginInlineEnd: token.marginSM,
    fontSize: token.modalConfirmIconSize
  }, _defineProperty(_$concat8, "+ ".concat(confirmComponentCls, "-title"), {
    flex: 1
  }), _defineProperty(_$concat8, "+ ".concat(confirmComponentCls, "-title + ").concat(confirmComponentCls, "-content"), {
    marginInlineStart: token.modalConfirmIconSize + token.marginSM
  }), _$concat8)), _$concat9)), _defineProperty(_confirmComponentCls, "".concat(confirmComponentCls, "-btns"), _defineProperty({
    textAlign: 'end',
    marginTop: token.marginSM
  }, "".concat(token.antCls, "-btn + ").concat(token.antCls, "-btn"), {
    marginBottom: 0,
    marginInlineStart: token.marginXS
  })), _confirmComponentCls)), _defineProperty(_ref6, "".concat(confirmComponentCls, "-error ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorError
  }), _defineProperty(_ref6, "".concat(confirmComponentCls, "-warning ").concat(confirmComponentCls, "-body > ").concat(token.iconCls, ",\n        ").concat(confirmComponentCls, "-confirm ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorWarning
  }), _defineProperty(_ref6, "".concat(confirmComponentCls, "-info ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorInfo
  }), _defineProperty(_ref6, "".concat(confirmComponentCls, "-success ").concat(confirmComponentCls, "-body > ").concat(token.iconCls), {
    color: token.colorSuccess
  }), _defineProperty(_ref6, "".concat(componentCls, "-zoom-leave ").concat(componentCls, "-btns"), {
    pointerEvents: 'none'
  }), _ref6;
};
var genRTLStyle = function genRTLStyle(token) {
  var componentCls = token.componentCls;
  return _defineProperty({}, "".concat(componentCls, "-root"), _defineProperty({}, "".concat(componentCls, "-wrap-rtl"), _defineProperty({
    direction: 'rtl'
  }, "".concat(componentCls, "-confirm-body"), {
    direction: 'rtl'
  })));
};
var genWireframeStyle = function genWireframeStyle(token) {
  var _componentCls, _confirmComponentCls2, _ref8;
  var componentCls = token.componentCls,
    antCls = token.antCls;
  var confirmComponentCls = "".concat(componentCls, "-confirm");
  return _ref8 = {}, _defineProperty(_ref8, componentCls, (_componentCls = {}, _defineProperty(_componentCls, "".concat(componentCls, "-content"), {
    padding: 0
  }), _defineProperty(_componentCls, "".concat(componentCls, "-header"), {
    padding: token.modalHeaderPadding,
    borderBottom: "".concat(token.modalHeaderBorderWidth, "px ").concat(token.modalHeaderBorderStyle, " ").concat(token.modalHeaderBorderColorSplit),
    marginBottom: 0
  }), _defineProperty(_componentCls, "".concat(componentCls, "-body"), {
    padding: token.modalBodyPadding
  }), _defineProperty(_componentCls, "".concat(componentCls, "-footer"), {
    padding: "".concat(token.modalFooterPaddingVertical, "px ").concat(token.modalFooterPaddingHorizontal, "px"),
    borderTop: "".concat(token.modalFooterBorderWidth, "px ").concat(token.modalFooterBorderStyle, " ").concat(token.modalFooterBorderColorSplit),
    borderRadius: "0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px"),
    marginTop: 0
  }), _componentCls)), _defineProperty(_ref8, confirmComponentCls, (_confirmComponentCls2 = {}, _defineProperty(_confirmComponentCls2, "".concat(antCls, "-modal-body"), {
    padding: "".concat(token.padding * 2, "px ").concat(token.padding * 2, "px ").concat(token.paddingLG, "px")
  }), _defineProperty(_confirmComponentCls2, "".concat(confirmComponentCls, "-body"), _defineProperty({}, "> ".concat(token.iconCls), _defineProperty({
    marginInlineEnd: token.margin
  }, "+ ".concat(confirmComponentCls, "-title + ").concat(confirmComponentCls, "-content"), {
    marginInlineStart: token.modalConfirmIconSize + token.margin
  }))), _defineProperty(_confirmComponentCls2, "".concat(confirmComponentCls, "-btns"), {
    marginTop: token.marginLG
  }), _confirmComponentCls2)), _ref8;
};
// ============================== Export ==============================
export default genComponentStyleHook('Modal', function (token) {
  var headerPaddingVertical = token.padding;
  var headerFontSize = token.fontSizeHeading5;
  var headerLineHeight = token.lineHeightHeading5;
  var modalToken = mergeToken(token, {
    modalBodyPadding: token.paddingLG,
    modalHeaderBg: token.colorBgElevated,
    modalHeaderPadding: "".concat(headerPaddingVertical, "px ").concat(token.paddingLG, "px"),
    modalHeaderBorderWidth: token.lineWidth,
    modalHeaderBorderStyle: token.lineType,
    modalHeaderTitleLineHeight: headerLineHeight,
    modalHeaderTitleFontSize: headerFontSize,
    modalHeaderBorderColorSplit: token.colorSplit,
    modalHeaderCloseSize: headerLineHeight * headerFontSize + headerPaddingVertical * 2,
    modalContentBg: token.colorBgElevated,
    modalHeadingColor: token.colorTextHeading,
    modalCloseColor: token.colorTextDescription,
    modalFooterBg: 'transparent',
    modalFooterBorderColorSplit: token.colorSplit,
    modalFooterBorderStyle: token.lineType,
    modalFooterPaddingVertical: token.paddingXS,
    modalFooterPaddingHorizontal: token.padding,
    modalFooterBorderWidth: token.lineWidth,
    modalConfirmTitleFontSize: token.fontSizeLG,
    modalIconHoverColor: token.colorIconHover,
    modalConfirmIconSize: token.fontSize * token.lineHeight,
    modalCloseBtnSize: token.controlHeightLG * 0.55
  });
  return [genModalStyle(modalToken), genModalConfirmStyle(modalToken), genRTLStyle(modalToken), genModalMaskStyle(modalToken), token.wireframe && genWireframeStyle(modalToken), initZoomMotion(modalToken, 'zoom')];
});