import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import { useConfigContextInject } from '../../config-provider/context';
import { useLocaleReceiver } from '../../locale-provider/LocaleReceiver';
import defaultLocale from '../../locale/en_US';
import ConfirmDialog from '../ConfirmDialog';
import initDefaultProps from '../../_util/props-util/initDefaultProps';
var comfirmFuncProps = function comfirmFuncProps() {
  return {
    config: Object,
    afterClose: Function,
    destroyAction: Function,
    open: Boolean
  };
};
export default defineComponent({
  name: 'HookModal',
  inheritAttrs: false,
  props: initDefaultProps(comfirmFuncProps(), {
    config: {
      width: 520,
      okType: 'primary'
    }
  }),
  setup: function setup(props, _ref) {
    var expose = _ref.expose;
    var _a;
    var open = computed(function () {
      return props.open;
    });
    var innerConfig = computed(function () {
      return props.config;
    });
    var _useConfigContextInje = useConfigContextInject(),
      direction = _useConfigContextInje.direction,
      getPrefixCls = _useConfigContextInje.getPrefixCls;
    var prefixCls = getPrefixCls('modal');
    var rootPrefixCls = getPrefixCls();
    var afterClose = function afterClose() {
      var _a, _b;
      props === null || props === void 0 ? void 0 : props.afterClose();
      (_b = (_a = innerConfig.value).afterClose) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var close = function close() {
      props.destroyAction.apply(props, arguments);
    };
    expose({
      destroy: close
    });
    var mergedOkCancel = (_a = innerConfig.value.okCancel) !== null && _a !== void 0 ? _a : innerConfig.value.type === 'confirm';
    var _useLocaleReceiver = useLocaleReceiver('Modal', defaultLocale.Modal),
      _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
      contextLocale = _useLocaleReceiver2[0];
    return function () {
      return _createVNode(ConfirmDialog, _objectSpread(_objectSpread({
        "prefixCls": prefixCls,
        "rootPrefixCls": rootPrefixCls
      }, innerConfig.value), {}, {
        "close": close,
        "open": open.value,
        "afterClose": afterClose,
        "okText": innerConfig.value.okText || (mergedOkCancel ? contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.okText : contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.justOkText),
        "direction": innerConfig.value.direction || direction.value,
        "cancelText": innerConfig.value.cancelText || (contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.cancelText)
      }), null);
    };
  }
});