import _extends from "@babel/runtime/helpers/esm/extends";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import { createVNode as _createVNode } from "vue";
import { isRef, unref, computed, defineComponent, shallowRef, watch } from 'vue';
import { withConfirm, withError, withInfo, withSuccess, withWarn } from '../confirm';
import HookModal from './HookModal';
import destroyFns from '../destroyFns';
var uuid = 0;
var ElementsHolder = defineComponent({
  name: 'ElementsHolder',
  inheritAttrs: false,
  setup: function setup(_, _ref) {
    var expose = _ref.expose;
    var modals = shallowRef([]);
    var addModal = function addModal(modal) {
      modals.value.push(modal);
      modals.value = modals.value.slice();
      return function () {
        modals.value = modals.value.filter(function (currentModal) {
          return currentModal !== modal;
        });
      };
    };
    expose({
      addModal: addModal
    });
    return function () {
      return modals.value.map(function (modal) {
        return modal();
      });
    };
  }
});
function useModal() {
  var holderRef = shallowRef(null);
  // ========================== Effect ==========================
  var actionQueue = shallowRef([]);
  watch(actionQueue, function () {
    if (actionQueue.value.length) {
      var cloneQueue = _toConsumableArray(actionQueue.value);
      cloneQueue.forEach(function (action) {
        action();
      });
      actionQueue.value = [];
    }
  }, {
    immediate: true
  });
  // =========================== Hook ===========================
  var getConfirmFunc = function getConfirmFunc(withFunc) {
    return function hookConfirm(config) {
      var _a;
      uuid += 1;
      var open = shallowRef(true);
      var modalRef = shallowRef(null);
      var configRef = shallowRef(unref(config));
      var updateConfig = shallowRef({});
      watch(function () {
        return config;
      }, function (val) {
        updateAction(_extends(_extends({}, isRef(val) ? val.value : val), updateConfig.value));
      });
      var destroyAction = function destroyAction() {
        open.value = false;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        var triggerCancel = args.some(function (param) {
          return param && param.triggerCancel;
        });
        if (configRef.value.onCancel && triggerCancel) {
          var _configRef$value;
          (_configRef$value = configRef.value).onCancel.apply(_configRef$value, [function () {}].concat(_toConsumableArray(args.slice(1))));
        }
      };
      // eslint-disable-next-line prefer-const
      var closeFunc;
      var modal = function modal() {
        return _createVNode(HookModal, {
          "key": "modal-".concat(uuid),
          "config": withFunc(configRef.value),
          "ref": modalRef,
          "open": open.value,
          "destroyAction": destroyAction,
          "afterClose": function afterClose() {
            closeFunc === null || closeFunc === void 0 ? void 0 : closeFunc();
          }
        }, null);
      };
      closeFunc = (_a = holderRef.value) === null || _a === void 0 ? void 0 : _a.addModal(modal);
      if (closeFunc) {
        destroyFns.push(closeFunc);
      }
      var updateAction = function updateAction(newConfig) {
        configRef.value = _extends(_extends({}, configRef.value), newConfig);
      };
      var destroy = function destroy() {
        if (modalRef.value) {
          destroyAction();
        } else {
          actionQueue.value = [].concat(_toConsumableArray(actionQueue.value), [destroyAction]);
        }
      };
      var update = function update(newConfig) {
        updateConfig.value = newConfig;
        if (modalRef.value) {
          updateAction(newConfig);
        } else {
          actionQueue.value = [].concat(_toConsumableArray(actionQueue.value), [function () {
            return updateAction(newConfig);
          }]);
        }
      };
      return {
        destroy: destroy,
        update: update
      };
    };
  };
  var fns = computed(function () {
    return {
      info: getConfirmFunc(withInfo),
      success: getConfirmFunc(withSuccess),
      error: getConfirmFunc(withError),
      warning: getConfirmFunc(withWarn),
      confirm: getConfirmFunc(withConfirm)
    };
  });
  return [fns.value, function () {
    return _createVNode(ElementsHolder, {
      "key": "modal-holder",
      "ref": holderRef
    }, null);
  }];
}
export default useModal;