import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode, createTextVNode as _createTextVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { computed, toRef, defineComponent } from 'vue';
import LeftOutlined from "@ant-design/icons-vue/es/icons/LeftOutlined";
import RightOutlined from "@ant-design/icons-vue/es/icons/RightOutlined";
import DoubleLeftOutlined from "@ant-design/icons-vue/es/icons/DoubleLeftOutlined";
import DoubleRightOutlined from "@ant-design/icons-vue/es/icons/DoubleRightOutlined";
import MiniSelect, { MiddleSelect } from './Select';
import { useLocaleReceiver } from '../locale-provider/LocaleReceiver';
import VcPagination from '../vc-pagination';
import enUS from '../vc-pagination/locale/en_US';
import classNames from '../_util/classNames';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useBreakpoint from '../_util/hooks/useBreakpoint';
import { booleanType, arrayType, stringType, functionType, someType } from '../_util/type';
// CSSINJS
import useStyle from './style';
export var paginationProps = function paginationProps() {
  return {
    total: Number,
    defaultCurrent: Number,
    disabled: booleanType(),
    current: Number,
    defaultPageSize: Number,
    pageSize: Number,
    hideOnSinglePage: booleanType(),
    showSizeChanger: booleanType(),
    pageSizeOptions: arrayType(),
    buildOptionText: functionType(),
    showQuickJumper: someType([Boolean, Object]),
    showTotal: functionType(),
    size: stringType(),
    simple: booleanType(),
    locale: Object,
    prefixCls: String,
    selectPrefixCls: String,
    totalBoundaryShowSizeChanger: Number,
    selectComponentClass: String,
    itemRender: functionType(),
    role: String,
    responsive: Boolean,
    showLessItems: booleanType(),
    onChange: functionType(),
    onShowSizeChange: functionType(),
    'onUpdate:current': functionType(),
    'onUpdate:pageSize': functionType()
  };
};
export var paginationConfig = function paginationConfig() {
  return _extends(_extends({}, paginationProps()), {
    position: stringType()
  });
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'APagination',
  inheritAttrs: false,
  props: paginationProps(),
  // emits: ['change', 'showSizeChange', 'update:current', 'update:pageSize'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('pagination', props),
      prefixCls = _useConfigInject.prefixCls,
      configProvider = _useConfigInject.configProvider,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var selectPrefixCls = computed(function () {
      return configProvider.getPrefixCls('select', props.selectPrefixCls);
    });
    var breakpoint = useBreakpoint();
    var _useLocaleReceiver = useLocaleReceiver('Pagination', enUS, toRef(props, 'locale')),
      _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
      locale = _useLocaleReceiver2[0];
    var getIconsProps = function getIconsProps(pre) {
      var ellipsis = _createVNode("span", {
        "class": "".concat(pre, "-item-ellipsis")
      }, [_createTextVNode("\u2022\u2022\u2022")]);
      var prevIcon = _createVNode("button", {
        "class": "".concat(pre, "-item-link"),
        "type": "button",
        "tabindex": -1
      }, [_createVNode(LeftOutlined, null, null)]);
      var nextIcon = _createVNode("button", {
        "class": "".concat(pre, "-item-link"),
        "type": "button",
        "tabindex": -1
      }, [_createVNode(RightOutlined, null, null)]);
      var jumpPrevIcon = _createVNode("a", {
        "rel": "nofollow",
        "class": "".concat(pre, "-item-link")
      }, [_createVNode("div", {
        "class": "".concat(pre, "-item-container")
      }, [_createVNode(DoubleLeftOutlined, {
        "class": "".concat(pre, "-item-link-icon")
      }, null), ellipsis])]);
      var jumpNextIcon = _createVNode("a", {
        "rel": "nofollow",
        "class": "".concat(pre, "-item-link")
      }, [_createVNode("div", {
        "class": "".concat(pre, "-item-container")
      }, [_createVNode(DoubleRightOutlined, {
        "class": "".concat(pre, "-item-link-icon")
      }, null), ellipsis])]);
      // change arrows direction in right-to-left direction
      if (direction.value === 'rtl') {
        var _ref2 = [nextIcon, prevIcon];
        prevIcon = _ref2[0];
        nextIcon = _ref2[1];
        var _ref3 = [jumpNextIcon, jumpPrevIcon];
        jumpPrevIcon = _ref3[0];
        jumpNextIcon = _ref3[1];
      }
      return {
        prevIcon: prevIcon,
        nextIcon: nextIcon,
        jumpPrevIcon: jumpPrevIcon,
        jumpNextIcon: jumpNextIcon
      };
    };
    return function () {
      var _a;
      var size = props.size,
        _props$itemRender = props.itemRender,
        itemRender = _props$itemRender === void 0 ? slots.itemRender : _props$itemRender,
        _props$buildOptionTex = props.buildOptionText,
        buildOptionText = _props$buildOptionTex === void 0 ? slots.buildOptionText : _props$buildOptionTex,
        selectComponentClass = props.selectComponentClass,
        responsive = props.responsive,
        restProps = __rest(props, ["size", "itemRender", "buildOptionText", "selectComponentClass", "responsive"]);
      var isSmall = size === 'small' || !!(((_a = breakpoint.value) === null || _a === void 0 ? void 0 : _a.xs) && !size && responsive);
      var paginationProps = _extends(_extends(_extends(_extends(_extends({}, restProps), getIconsProps(prefixCls.value)), {
        prefixCls: prefixCls.value,
        selectPrefixCls: selectPrefixCls.value,
        selectComponentClass: selectComponentClass || (isSmall ? MiniSelect : MiddleSelect),
        locale: locale.value,
        buildOptionText: buildOptionText
      }), attrs), {
        class: classNames(_defineProperty({
          mini: isSmall
        }, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value),
        itemRender: itemRender
      });
      return wrapSSR(_createVNode(VcPagination, paginationProps, null));
    };
  }
});