import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genBasicInputStyle, genInputSmallStyle, initInputToken } from '../../input/style';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { genFocusOutline, genFocusStyle, resetComponent } from '../../style';
var genPaginationDisabledStyle = function genPaginationDisabledStyle(token) {
  var _$concat2, _ref;
  var componentCls = token.componentCls;
  return _ref = {}, _defineProperty(_ref, "".concat(componentCls, "-disabled"), {
    '&, &:hover': _defineProperty({
      cursor: 'not-allowed'
    }, "".concat(componentCls, "-item-link"), {
      color: token.colorTextDisabled,
      cursor: 'not-allowed'
    }),
    '&:focus-visible': _defineProperty({
      cursor: 'not-allowed'
    }, "".concat(componentCls, "-item-link"), {
      color: token.colorTextDisabled,
      cursor: 'not-allowed'
    })
  }), _defineProperty(_ref, "&".concat(componentCls, "-disabled"), (_$concat2 = {
    cursor: 'not-allowed'
  }, _defineProperty(_$concat2, "".concat(componentCls, "-item"), {
    cursor: 'not-allowed',
    '&:hover, &:active': {
      backgroundColor: 'transparent'
    },
    a: {
      color: token.colorTextDisabled,
      backgroundColor: 'transparent',
      border: 'none',
      cursor: 'not-allowed'
    },
    '&-active': {
      borderColor: token.colorBorder,
      backgroundColor: token.paginationItemDisabledBgActive,
      '&:hover, &:active': {
        backgroundColor: token.paginationItemDisabledBgActive
      },
      a: {
        color: token.paginationItemDisabledColorActive
      }
    }
  }), _defineProperty(_$concat2, "".concat(componentCls, "-item-link"), _defineProperty({
    color: token.colorTextDisabled,
    cursor: 'not-allowed',
    '&:hover, &:active': {
      backgroundColor: 'transparent'
    }
  }, "".concat(componentCls, "-simple&"), {
    backgroundColor: 'transparent'
  })), _defineProperty(_$concat2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 0
  }), _defineProperty(_$concat2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 1
  }), _defineProperty(_$concat2, "".concat(componentCls, "-simple-pager"), {
    color: token.colorTextDisabled
  }), _$concat2)), _ref;
};
var genPaginationMiniStyle = function genPaginationMiniStyle(token) {
  var _$concat$concat, _ref2;
  var componentCls = token.componentCls;
  return _ref2 = {}, _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-total-text, &").concat(componentCls, "-mini ").concat(componentCls, "-simple-pager"), {
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-item"), {
    minWidth: token.paginationItemSizeSM,
    height: token.paginationItemSizeSM,
    margin: 0,
    lineHeight: "".concat(token.paginationItemSizeSM - 2, "px")
  }), _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-item:not(").concat(componentCls, "-item-active)"), {
    backgroundColor: 'transparent',
    borderColor: 'transparent'
  }), _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-prev, &").concat(componentCls, "-mini ").concat(componentCls, "-next"), {
    minWidth: token.paginationItemSizeSM,
    height: token.paginationItemSizeSM,
    margin: 0,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), _defineProperty(_ref2, "\n    &".concat(componentCls, "-mini ").concat(componentCls, "-prev ").concat(componentCls, "-item-link,\n    &").concat(componentCls, "-mini ").concat(componentCls, "-next ").concat(componentCls, "-item-link\n    "), {
    backgroundColor: 'transparent',
    borderColor: 'transparent',
    '&::after': {
      height: token.paginationItemSizeSM,
      lineHeight: "".concat(token.paginationItemSizeSM, "px")
    }
  }), _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-jump-prev, &").concat(componentCls, "-mini ").concat(componentCls, "-jump-next"), {
    height: token.paginationItemSizeSM,
    marginInlineEnd: 0,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), _defineProperty(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-options"), (_$concat$concat = {
    marginInlineStart: token.paginationMiniOptionsMarginInlineStart
  }, _defineProperty(_$concat$concat, "&-size-changer", {
    top: token.paginationMiniOptionsSizeChangerTop
  }), _defineProperty(_$concat$concat, "&-quick-jumper", {
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px"),
    input: _extends(_extends({}, genInputSmallStyle(token)), {
      width: token.paginationMiniQuickJumperInputWidth,
      height: token.controlHeightSM
    })
  }), _$concat$concat)), _ref2;
};
var genPaginationSimpleStyle = function genPaginationSimpleStyle(token) {
  var _ref3;
  var componentCls = token.componentCls;
  return _ref3 = {}, _defineProperty(_ref3, "\n    &".concat(componentCls, "-simple ").concat(componentCls, "-prev,\n    &").concat(componentCls, "-simple ").concat(componentCls, "-next\n    "), _defineProperty({
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px"),
    verticalAlign: 'top'
  }, "".concat(componentCls, "-item-link"), {
    height: token.paginationItemSizeSM,
    backgroundColor: 'transparent',
    border: 0,
    '&::after': {
      height: token.paginationItemSizeSM,
      lineHeight: "".concat(token.paginationItemSizeSM, "px")
    }
  })), _defineProperty(_ref3, "&".concat(componentCls, "-simple ").concat(componentCls, "-simple-pager"), {
    display: 'inline-block',
    height: token.paginationItemSizeSM,
    marginInlineEnd: token.marginXS,
    input: {
      boxSizing: 'border-box',
      height: '100%',
      marginInlineEnd: token.marginXS,
      padding: "0 ".concat(token.paginationItemPaddingInline, "px"),
      textAlign: 'center',
      backgroundColor: token.paginationItemInputBg,
      border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
      borderRadius: token.borderRadius,
      outline: 'none',
      transition: "border-color ".concat(token.motionDurationMid),
      color: 'inherit',
      '&:hover': {
        borderColor: token.colorPrimary
      },
      '&:focus': {
        borderColor: token.colorPrimaryHover,
        boxShadow: "".concat(token.inputOutlineOffset, "px 0 ").concat(token.controlOutlineWidth, "px ").concat(token.controlOutline)
      },
      '&[disabled]': {
        color: token.colorTextDisabled,
        backgroundColor: token.colorBgContainerDisabled,
        borderColor: token.colorBorder,
        cursor: 'not-allowed'
      }
    }
  }), _ref3;
};
var genPaginationJumpStyle = function genPaginationJumpStyle(token) {
  var _$concat3, _hover2, _extends2, _$concat$concat3, _$concat$concat4, _ref4;
  var componentCls = token.componentCls;
  return _ref4 = {}, _defineProperty(_ref4, "".concat(componentCls, "-jump-prev, ").concat(componentCls, "-jump-next"), (_$concat$concat3 = {
    outline: 0
  }, _defineProperty(_$concat$concat3, "".concat(componentCls, "-item-container"), (_$concat3 = {
    position: 'relative'
  }, _defineProperty(_$concat3, "".concat(componentCls, "-item-link-icon"), {
    color: token.colorPrimary,
    fontSize: token.fontSizeSM,
    opacity: 0,
    transition: "all ".concat(token.motionDurationMid),
    '&-svg': {
      top: 0,
      insetInlineEnd: 0,
      bottom: 0,
      insetInlineStart: 0,
      margin: 'auto'
    }
  }), _defineProperty(_$concat3, "".concat(componentCls, "-item-ellipsis"), {
    position: 'absolute',
    top: 0,
    insetInlineEnd: 0,
    bottom: 0,
    insetInlineStart: 0,
    display: 'block',
    margin: 'auto',
    color: token.colorTextDisabled,
    fontFamily: 'Arial, Helvetica, sans-serif',
    letterSpacing: token.paginationEllipsisLetterSpacing,
    textAlign: 'center',
    textIndent: token.paginationEllipsisTextIndent,
    opacity: 1,
    transition: "all ".concat(token.motionDurationMid)
  }), _$concat3)), _defineProperty(_$concat$concat3, '&:hover', (_hover2 = {}, _defineProperty(_hover2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 1
  }), _defineProperty(_hover2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 0
  }), _hover2)), _defineProperty(_$concat$concat3, '&:focus-visible', _extends((_extends2 = {}, _defineProperty(_extends2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 1
  }), _defineProperty(_extends2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 0
  }), _extends2), genFocusOutline(token))), _$concat$concat3)), _defineProperty(_ref4, "\n    ".concat(componentCls, "-prev,\n    ").concat(componentCls, "-jump-prev,\n    ").concat(componentCls, "-jump-next\n    "), {
    marginInlineEnd: token.marginXS
  }), _defineProperty(_ref4, "\n    ".concat(componentCls, "-prev,\n    ").concat(componentCls, "-next,\n    ").concat(componentCls, "-jump-prev,\n    ").concat(componentCls, "-jump-next\n    "), {
    display: 'inline-block',
    minWidth: token.paginationItemSize,
    height: token.paginationItemSize,
    color: token.colorText,
    fontFamily: token.paginationFontFamily,
    lineHeight: "".concat(token.paginationItemSize, "px"),
    textAlign: 'center',
    verticalAlign: 'middle',
    listStyle: 'none',
    borderRadius: token.borderRadius,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationMid)
  }), _defineProperty(_ref4, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), (_$concat$concat4 = {
    fontFamily: 'Arial, Helvetica, sans-serif',
    outline: 0,
    button: {
      color: token.colorText,
      cursor: 'pointer',
      userSelect: 'none'
    }
  }, _defineProperty(_$concat$concat4, "".concat(componentCls, "-item-link"), {
    display: 'block',
    width: '100%',
    height: '100%',
    padding: 0,
    fontSize: token.fontSizeSM,
    textAlign: 'center',
    backgroundColor: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    borderRadius: token.borderRadius,
    outline: 'none',
    transition: "border ".concat(token.motionDurationMid)
  }), _defineProperty(_$concat$concat4, "&:focus-visible ".concat(componentCls, "-item-link"), _extends({}, genFocusOutline(token))), _defineProperty(_$concat$concat4, "&:hover ".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgTextHover
  }), _defineProperty(_$concat$concat4, "&:active ".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgTextActive
  }), _defineProperty(_$concat$concat4, "&".concat(componentCls, "-disabled:hover"), _defineProperty({}, "".concat(componentCls, "-item-link"), {
    backgroundColor: 'transparent'
  })), _$concat$concat4)), _defineProperty(_ref4, "".concat(componentCls, "-slash"), {
    marginInlineEnd: token.paginationSlashMarginInlineEnd,
    marginInlineStart: token.paginationSlashMarginInlineStart
  }), _defineProperty(_ref4, "".concat(componentCls, "-options"), {
    display: 'inline-block',
    marginInlineStart: token.margin,
    verticalAlign: 'middle',
    '&-size-changer.-select': {
      display: 'inline-block',
      width: 'auto'
    },
    '&-quick-jumper': {
      display: 'inline-block',
      height: token.controlHeight,
      marginInlineStart: token.marginXS,
      lineHeight: "".concat(token.controlHeight, "px"),
      verticalAlign: 'top',
      input: _extends(_extends({}, genBasicInputStyle(token)), {
        width: token.controlHeightLG * 1.25,
        height: token.controlHeight,
        boxSizing: 'border-box',
        margin: 0,
        marginInlineStart: token.marginXS,
        marginInlineEnd: token.marginXS
      })
    }
  }), _ref4;
};
var genPaginationItemStyle = function genPaginationItemStyle(token) {
  var componentCls = token.componentCls;
  return _defineProperty({}, "".concat(componentCls, "-item"), _extends(_extends(_defineProperty({
    display: 'inline-block',
    minWidth: token.paginationItemSize,
    height: token.paginationItemSize,
    marginInlineEnd: token.marginXS,
    fontFamily: token.paginationFontFamily,
    lineHeight: "".concat(token.paginationItemSize - 2, "px"),
    textAlign: 'center',
    verticalAlign: 'middle',
    listStyle: 'none',
    backgroundColor: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    borderRadius: token.borderRadius,
    outline: 0,
    cursor: 'pointer',
    userSelect: 'none',
    a: {
      display: 'block',
      padding: "0 ".concat(token.paginationItemPaddingInline, "px"),
      color: token.colorText,
      transition: 'none',
      '&:hover': {
        textDecoration: 'none'
      }
    }
  }, "&:not(".concat(componentCls, "-item-active)"), {
    '&:hover': {
      transition: "all ".concat(token.motionDurationMid),
      backgroundColor: token.colorBgTextHover
    },
    '&:active': {
      backgroundColor: token.colorBgTextActive
    }
  }), genFocusStyle(token)), {
    '&-active': {
      fontWeight: token.paginationFontWeightActive,
      backgroundColor: token.paginationItemBgActive,
      borderColor: token.colorPrimary,
      a: {
        color: token.colorPrimary
      },
      '&:hover': {
        borderColor: token.colorPrimaryHover
      },
      '&:hover a': {
        color: token.colorPrimaryHover
      }
    }
  }));
};
var genPaginationStyle = function genPaginationStyle(token) {
  var _extends5, _ref6;
  var componentCls = token.componentCls;
  return _ref6 = {}, _defineProperty(_ref6, componentCls, _extends(_extends(_extends(_extends(_extends(_extends(_extends(_extends({}, resetComponent(token)), _defineProperty({
    'ul, ol': {
      margin: 0,
      padding: 0,
      listStyle: 'none'
    },
    '&::after': {
      display: 'block',
      clear: 'both',
      height: 0,
      overflow: 'hidden',
      visibility: 'hidden',
      content: '""'
    }
  }, "".concat(componentCls, "-total-text"), {
    display: 'inline-block',
    height: token.paginationItemSize,
    marginInlineEnd: token.marginXS,
    lineHeight: "".concat(token.paginationItemSize - 2, "px"),
    verticalAlign: 'middle'
  })), genPaginationItemStyle(token)), genPaginationJumpStyle(token)), genPaginationSimpleStyle(token)), genPaginationMiniStyle(token)), genPaginationDisabledStyle(token)), (_extends5 = {}, _defineProperty(_extends5, "@media only screen and (max-width: ".concat(token.screenLG, "px)"), _defineProperty({}, "".concat(componentCls, "-item"), {
    '&-after-jump-prev, &-before-jump-next': {
      display: 'none'
    }
  })), _defineProperty(_extends5, "@media only screen and (max-width: ".concat(token.screenSM, "px)"), _defineProperty({}, "".concat(componentCls, "-options"), {
    display: 'none'
  })), _extends5))), _defineProperty(_ref6, "&".concat(token.componentCls, "-rtl"), {
    direction: 'rtl'
  }), _ref6;
};
var genBorderedStyle = function genBorderedStyle(token) {
  var _$concat$concat5, _$concat$concat7, _$concat$concat8, _$concat6, _componentCls, _ref7;
  var componentCls = token.componentCls;
  return _ref7 = {}, _defineProperty(_ref7, "".concat(componentCls).concat(componentCls, "-disabled"), (_$concat$concat7 = {
    '&, &:hover': _defineProperty({}, "".concat(componentCls, "-item-link"), {
      borderColor: token.colorBorder
    }),
    '&:focus-visible': _defineProperty({}, "".concat(componentCls, "-item-link"), {
      borderColor: token.colorBorder
    })
  }, _defineProperty(_$concat$concat7, "".concat(componentCls, "-item, ").concat(componentCls, "-item-link"), (_$concat$concat5 = {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder
  }, _defineProperty(_$concat$concat5, "&:hover:not(".concat(componentCls, "-item-active)"), {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder,
    a: {
      color: token.colorTextDisabled
    }
  }), _defineProperty(_$concat$concat5, "&".concat(componentCls, "-item-active"), {
    backgroundColor: token.paginationItemDisabledBgActive
  }), _$concat$concat5)), _defineProperty(_$concat$concat7, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), _defineProperty({
    '&:hover button': {
      backgroundColor: token.colorBgContainerDisabled,
      borderColor: token.colorBorder,
      color: token.colorTextDisabled
    }
  }, "".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder
  })), _$concat$concat7)), _defineProperty(_ref7, componentCls, (_componentCls = {}, _defineProperty(_componentCls, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), (_$concat$concat8 = {
    '&:hover button': {
      borderColor: token.colorPrimaryHover,
      backgroundColor: token.paginationItemBg
    }
  }, _defineProperty(_$concat$concat8, "".concat(componentCls, "-item-link"), {
    backgroundColor: token.paginationItemLinkBg,
    borderColor: token.colorBorder
  }), _defineProperty(_$concat$concat8, "&:hover ".concat(componentCls, "-item-link"), {
    borderColor: token.colorPrimary,
    backgroundColor: token.paginationItemBg,
    color: token.colorPrimary
  }), _defineProperty(_$concat$concat8, "&".concat(componentCls, "-disabled"), _defineProperty({}, "".concat(componentCls, "-item-link"), {
    borderColor: token.colorBorder,
    color: token.colorTextDisabled
  })), _$concat$concat8)), _defineProperty(_componentCls, "".concat(componentCls, "-item"), (_$concat6 = {
    backgroundColor: token.paginationItemBg,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder)
  }, _defineProperty(_$concat6, "&:hover:not(".concat(componentCls, "-item-active)"), {
    borderColor: token.colorPrimary,
    backgroundColor: token.paginationItemBg,
    a: {
      color: token.colorPrimary
    }
  }), _defineProperty(_$concat6, '&-active', {
    borderColor: token.colorPrimary
  }), _$concat6)), _componentCls)), _ref7;
};
// ============================== Export ==============================
export default genComponentStyleHook('Pagination', function (token) {
  var paginationToken = mergeToken(token, {
    paginationItemSize: token.controlHeight,
    paginationFontFamily: token.fontFamily,
    paginationItemBg: token.colorBgContainer,
    paginationItemBgActive: token.colorBgContainer,
    paginationFontWeightActive: token.fontWeightStrong,
    paginationItemSizeSM: token.controlHeightSM,
    paginationItemInputBg: token.colorBgContainer,
    paginationMiniOptionsSizeChangerTop: 0,
    paginationItemDisabledBgActive: token.controlItemBgActiveDisabled,
    paginationItemDisabledColorActive: token.colorTextDisabled,
    paginationItemLinkBg: token.colorBgContainer,
    inputOutlineOffset: '0 0',
    paginationMiniOptionsMarginInlineStart: token.marginXXS / 2,
    paginationMiniQuickJumperInputWidth: token.controlHeightLG * 1.1,
    paginationItemPaddingInline: token.marginXXS * 1.5,
    paginationEllipsisLetterSpacing: token.marginXXS / 2,
    paginationSlashMarginInlineStart: token.marginXXS,
    paginationSlashMarginInlineEnd: token.marginSM,
    paginationEllipsisTextIndent: '0.13em' // magic for ui experience
  }, initInputToken(token));
  return [genPaginationStyle(paginationToken), token.wireframe && genBorderedStyle(paginationToken)];
});