import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook } from '../../theme/internal';
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _componentCls;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    zIndexPopup = token.zIndexPopup,
    colorText = token.colorText,
    colorWarning = token.colorWarning,
    marginXS = token.marginXS,
    fontSize = token.fontSize,
    fontWeightStrong = token.fontWeightStrong,
    lineHeight = token.lineHeight;
  return _defineProperty({}, componentCls, (_componentCls = {
    zIndex: zIndexPopup
  }, _defineProperty(_componentCls, "".concat(componentCls, "-inner-content"), {
    color: colorText
  }), _defineProperty(_componentCls, "".concat(componentCls, "-message"), (_$concat = {
    position: 'relative',
    marginBottom: marginXS,
    color: colorText,
    fontSize: fontSize,
    display: 'flex',
    flexWrap: 'nowrap',
    alignItems: 'start'
  }, _defineProperty(_$concat, "> ".concat(componentCls, "-message-icon ").concat(iconCls), {
    color: colorWarning,
    fontSize: fontSize,
    flex: 'none',
    lineHeight: 1,
    paddingTop: (Math.round(fontSize * lineHeight) - fontSize) / 2
  }), _defineProperty(_$concat, '&-title', {
    flex: 'auto',
    marginInlineStart: marginXS
  }), _defineProperty(_$concat, '&-title-only', {
    fontWeight: fontWeightStrong
  }), _$concat)), _defineProperty(_componentCls, "".concat(componentCls, "-description"), {
    position: 'relative',
    marginInlineStart: fontSize + marginXS,
    marginBottom: marginXS,
    color: colorText,
    fontSize: fontSize
  }), _defineProperty(_componentCls, "".concat(componentCls, "-buttons"), {
    textAlign: 'end',
    button: {
      marginInlineStart: marginXS
    }
  }), _componentCls));
};
// ============================== Export ==============================
export default genComponentStyleHook('Popconfirm', function (token) {
  return genBaseStyle(token);
}, function (token) {
  var zIndexPopupBase = token.zIndexPopupBase;
  return {
    zIndexPopup: zIndexPopupBase + 60
  };
});