import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { initZoomMotion } from '../../style/motion';
import { genComponentStyleHook, mergeToken, PresetColors } from '../../theme/internal';
import { resetComponent } from '../../style';
import getArrowStyle from '../../style/placementArrow';
var genBaseStyle = function genBaseStyle(token) {
  var _extends2;
  var componentCls = token.componentCls,
    popoverBg = token.popoverBg,
    popoverColor = token.popoverColor,
    width = token.width,
    fontWeightStrong = token.fontWeightStrong,
    popoverPadding = token.popoverPadding,
    boxShadowSecondary = token.boxShadowSecondary,
    colorTextHeading = token.colorTextHeading,
    borderRadius = token.borderRadiusLG,
    zIndexPopup = token.zIndexPopup,
    marginXS = token.marginXS,
    colorBgElevated = token.colorBgElevated;
  return [_defineProperty({}, componentCls, _extends(_extends({}, resetComponent(token)), (_extends2 = {
    position: 'absolute',
    top: 0,
    // use `left` to fix https://github.com/ant-design/ant-design/issues/39195
    left: {
      _skip_check_: true,
      value: 0
    },
    zIndex: zIndexPopup,
    fontWeight: 'normal',
    whiteSpace: 'normal',
    textAlign: 'start',
    cursor: 'auto',
    userSelect: 'text',
    '--antd-arrow-background-color': colorBgElevated,
    '&-rtl': {
      direction: 'rtl'
    },
    '&-hidden': {
      display: 'none'
    }
  }, _defineProperty(_extends2, "".concat(componentCls, "-content"), {
    position: 'relative'
  }), _defineProperty(_extends2, "".concat(componentCls, "-inner"), {
    backgroundColor: popoverBg,
    backgroundClip: 'padding-box',
    borderRadius: borderRadius,
    boxShadow: boxShadowSecondary,
    padding: popoverPadding
  }), _defineProperty(_extends2, "".concat(componentCls, "-title"), {
    minWidth: width,
    marginBottom: marginXS,
    color: colorTextHeading,
    fontWeight: fontWeightStrong
  }), _defineProperty(_extends2, "".concat(componentCls, "-inner-content"), {
    color: popoverColor
  }), _extends2))),
  // Arrow Style
  getArrowStyle(token, {
    colorBg: 'var(--antd-arrow-background-color)'
  }), // Pure Render
  _defineProperty({}, "".concat(componentCls, "-pure"), _defineProperty({
    position: 'relative',
    maxWidth: 'none'
  }, "".concat(componentCls, "-content"), {
    display: 'inline-block'
  }))];
};
var genColorStyle = function genColorStyle(token) {
  var componentCls = token.componentCls;
  return _defineProperty({}, componentCls, PresetColors.map(function (colorKey) {
    var _$concat$concat;
    var lightColor = token["".concat(colorKey, "-6")];
    return _defineProperty({}, "&".concat(componentCls, "-").concat(colorKey), (_$concat$concat = {
      '--antd-arrow-background-color': lightColor
    }, _defineProperty(_$concat$concat, "".concat(componentCls, "-inner"), {
      backgroundColor: lightColor
    }), _defineProperty(_$concat$concat, "".concat(componentCls, "-arrow"), {
      background: 'transparent'
    }), _$concat$concat));
  }));
};
var genWireframeStyle = function genWireframeStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    colorSplit = token.colorSplit,
    paddingSM = token.paddingSM,
    controlHeight = token.controlHeight,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    padding = token.padding;
  var titlePaddingBlockDist = controlHeight - Math.round(fontSize * lineHeight);
  var popoverTitlePaddingBlockTop = titlePaddingBlockDist / 2;
  var popoverTitlePaddingBlockBottom = titlePaddingBlockDist / 2 - lineWidth;
  var popoverPaddingHorizontal = padding;
  return _defineProperty({}, componentCls, (_componentCls = {}, _defineProperty(_componentCls, "".concat(componentCls, "-inner"), {
    padding: 0
  }), _defineProperty(_componentCls, "".concat(componentCls, "-title"), {
    margin: 0,
    padding: "".concat(popoverTitlePaddingBlockTop, "px ").concat(popoverPaddingHorizontal, "px ").concat(popoverTitlePaddingBlockBottom, "px"),
    borderBottom: "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorSplit)
  }), _defineProperty(_componentCls, "".concat(componentCls, "-inner-content"), {
    padding: "".concat(paddingSM, "px ").concat(popoverPaddingHorizontal, "px")
  }), _componentCls));
};
export default genComponentStyleHook('Popover', function (token) {
  var colorBgElevated = token.colorBgElevated,
    colorText = token.colorText,
    wireframe = token.wireframe;
  var popoverToken = mergeToken(token, {
    popoverBg: colorBgElevated,
    popoverColor: colorText,
    popoverPadding: 12 // Fixed Value
  });

  return [genBaseStyle(popoverToken), genColorStyle(popoverToken), wireframe && genWireframeStyle(popoverToken), initZoomMotion(popoverToken, 'zoom-big')];
}, function (_ref6) {
  var zIndexPopupBase = _ref6.zIndexPopupBase;
  return {
    zIndexPopup: zIndexPopupBase + 30,
    width: 177
  };
});