import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { Fragment as _Fragment, resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import { Circle as VCCircle } from '../vc-progress';
import { getPercentage, getSize, getStrokeColor } from './utils';
import { progressProps } from './props';
import { initDefaultProps } from '../_util/props-util';
import Tooltip from '../tooltip';
import { anyType } from '../_util/type';
export var circleProps = function circleProps() {
  return _extends(_extends({}, progressProps()), {
    strokeColor: anyType()
  });
};
var CIRCLE_MIN_STROKE_WIDTH = 3;
var getMinPercent = function getMinPercent(width) {
  return CIRCLE_MIN_STROKE_WIDTH / width * 100;
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Circle',
  inheritAttrs: false,
  props: initDefaultProps(circleProps(), {
    trailColor: null
  }),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var originWidth = computed(function () {
      var _a;
      return (_a = props.width) !== null && _a !== void 0 ? _a : 120;
    });
    var mergedSize = computed(function () {
      var _a;
      return (_a = props.size) !== null && _a !== void 0 ? _a : [originWidth.value, originWidth.value];
    });
    var sizeRef = computed(function () {
      return getSize(mergedSize.value, 'circle');
    });
    var gapDeg = computed(function () {
      // Support gapDeg = 0 when type = 'dashboard'
      if (props.gapDegree || props.gapDegree === 0) {
        return props.gapDegree;
      }
      if (props.type === 'dashboard') {
        return 75;
      }
      return undefined;
    });
    var circleStyle = computed(function () {
      return {
        width: "".concat(sizeRef.value.width, "px"),
        height: "".concat(sizeRef.value.height, "px"),
        fontSize: "".concat(sizeRef.value.width * 0.15 + 6, "px")
      };
    });
    var circleWidth = computed(function () {
      var _a;
      return (_a = props.strokeWidth) !== null && _a !== void 0 ? _a : Math.max(getMinPercent(sizeRef.value.width), 6);
    });
    var gapPos = computed(function () {
      return props.gapPosition || props.type === 'dashboard' && 'bottom' || undefined;
    });
    // using className to style stroke color
    var percent = computed(function () {
      return getPercentage(props);
    });
    var isGradient = computed(function () {
      return Object.prototype.toString.call(props.strokeColor) === '[object Object]';
    });
    var strokeColor = computed(function () {
      return getStrokeColor({
        success: props.success,
        strokeColor: props.strokeColor
      });
    });
    var wrapperClassName = computed(function () {
      var _ref2;
      return _ref2 = {}, _defineProperty(_ref2, "".concat(props.prefixCls, "-inner"), true), _defineProperty(_ref2, "".concat(props.prefixCls, "-circle-gradient"), isGradient.value), _ref2;
    });
    return function () {
      var _a;
      var circleContent = _createVNode(VCCircle, {
        "percent": percent.value,
        "strokeWidth": circleWidth.value,
        "trailWidth": circleWidth.value,
        "strokeColor": strokeColor.value,
        "strokeLinecap": props.strokeLinecap,
        "trailColor": props.trailColor,
        "prefixCls": props.prefixCls,
        "gapDegree": gapDeg.value,
        "gapPosition": gapPos.value
      }, null);
      return _createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [wrapperClassName.value, attrs.class],
        "style": [attrs.style, circleStyle.value]
      }), [sizeRef.value.width <= 20 ? _createVNode(Tooltip, null, {
        default: function _default() {
          return [_createVNode("span", null, [circleContent])];
        },
        title: slots.default
      }) : _createVNode(_Fragment, null, [circleContent, (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)])]);
    };
  }
});