import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { createVNode as _createVNode } from "vue";
import { computed, defineComponent } from 'vue';
import { someType } from '../_util/type';
import { progressProps } from './props';
import { getSize } from './utils';
export var stepsProps = function stepsProps() {
  return _extends(_extends({}, progressProps()), {
    steps: Number,
    strokeColor: someType(),
    trailColor: String
  });
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Steps',
  props: stepsProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var current = computed(function () {
      return Math.round(props.steps * ((props.percent || 0) / 100));
    });
    var mergedSize = computed(function () {
      var _a;
      return (_a = props.size) !== null && _a !== void 0 ? _a : [props.size === 'small' ? 2 : 14, props.strokeWidth || 8];
    });
    var sizeRef = computed(function () {
      return getSize(mergedSize.value, 'step', {
        steps: props.steps,
        strokeWidth: props.strokeWidth || 8
      });
    });
    var styledSteps = computed(function () {
      var steps = props.steps,
        strokeColor = props.strokeColor,
        trailColor = props.trailColor,
        prefixCls = props.prefixCls;
      var temp = [];
      for (var i = 0; i < steps; i += 1) {
        var _cls;
        var color = Array.isArray(strokeColor) ? strokeColor[i] : strokeColor;
        var cls = (_cls = {}, _defineProperty(_cls, "".concat(prefixCls, "-steps-item"), true), _defineProperty(_cls, "".concat(prefixCls, "-steps-item-active"), i <= current.value - 1), _cls);
        temp.push(_createVNode("div", {
          "key": i,
          "class": cls,
          "style": {
            backgroundColor: i <= current.value - 1 ? color : trailColor,
            width: "".concat(sizeRef.value.width / steps, "px"),
            height: "".concat(sizeRef.value.height, "px")
          }
        }, null));
      }
      return temp;
    });
    return function () {
      var _a;
      return _createVNode("div", {
        "class": "".concat(props.prefixCls, "-steps-outer")
      }, [styledSteps.value, (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]);
    };
  }
});