import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, Fragment as _Fragment, createVNode as _createVNode } from "vue";
import { defineComponent, computed, ref } from 'vue';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
import { useLocaleReceiver } from '../locale/LocaleReceiver';
import { withInstall } from '../_util/type';
import Spin from '../spin';
import Button from '../button';
import { ReloadOutlined } from '@ant-design/icons-vue';
import { useToken } from '../theme/internal';
import { QRCodeCanvas } from './QRCodeCanvas';
import warning from '../_util/warning';
import { qrcodeProps } from './interface';
var QRCode = defineComponent({
  name: 'AQrcode',
  inheritAttrs: false,
  props: qrcodeProps(),
  emits: ['refresh'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    if (process.env.NODE_ENV !== 'production') {
      warning(!(props.icon && props.errorLevel === 'L'), 'QRCode', 'ErrorLevel `L` is not recommended to be used with `icon`, for scanning result would be affected by low level.');
    }
    var _useLocaleReceiver = useLocaleReceiver('QRCode'),
      _useLocaleReceiver2 = _slicedToArray(_useLocaleReceiver, 1),
      locale = _useLocaleReceiver2[0];
    var _useConfigInject = useConfigInject('qrcode', props),
      prefixCls = _useConfigInject.prefixCls;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useToken = useToken(),
      _useToken2 = _slicedToArray(_useToken, 2),
      token = _useToken2[1];
    var qrCodeCanvas = ref();
    expose({
      toDataURL: function toDataURL(type, quality) {
        var _a;
        return (_a = qrCodeCanvas.value) === null || _a === void 0 ? void 0 : _a.toDataURL(type, quality);
      }
    });
    var qrCodeProps = computed(function () {
      var value = props.value,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? '' : _props$icon,
        _props$size = props.size,
        size = _props$size === void 0 ? 160 : _props$size,
        _props$iconSize = props.iconSize,
        iconSize = _props$iconSize === void 0 ? 40 : _props$iconSize,
        _props$color = props.color,
        color = _props$color === void 0 ? '#000' : _props$color,
        _props$errorLevel = props.errorLevel,
        errorLevel = _props$errorLevel === void 0 ? 'M' : _props$errorLevel;
      var imageSettings = {
        src: icon,
        x: undefined,
        y: undefined,
        height: iconSize,
        width: iconSize,
        excavate: true
      };
      return {
        value: value,
        size: size - (token.value.paddingSM + token.value.lineWidth) * 2,
        level: errorLevel,
        bgColor: 'transparent',
        fgColor: color,
        imageSettings: icon ? imageSettings : undefined
      };
    });
    return function () {
      var pre = prefixCls.value;
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "style": [attrs.style, {
          width: props.size + 'px',
          height: props.size + 'px'
        }],
        "class": [hashId.value, pre, _defineProperty({}, "".concat(prefixCls, "-borderless"), !props.bordered)]
      }), [props.status !== 'active' && _createVNode("div", {
        "class": "".concat(pre, "-mask")
      }, [props.status === 'loading' && _createVNode(Spin, null, null), props.status === 'expired' && _createVNode(_Fragment, null, [_createVNode("p", {
        "class": "".concat(pre, "-expired")
      }, [locale.value.expired]), _createVNode(Button, {
        "type": "link",
        "onClick": function onClick(e) {
          return emit('refresh', e);
        }
      }, {
        default: function _default() {
          return [locale.value.refresh];
        },
        icon: function icon() {
          return _createVNode(ReloadOutlined, null, null);
        }
      })])]), _createVNode(QRCodeCanvas, _objectSpread({
        "ref": qrCodeCanvas
      }, qrCodeProps.value), null)]));
    };
  }
});
export default withInstall(QRCode);