import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { computed, defineComponent, ref } from 'vue';
import PropTypes from '../_util/vue-types';
import VcCheckbox from '../vc-checkbox/Checkbox';
import classNames from '../_util/classNames';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { FormItemInputContext, useInjectFormItemContext } from '../form/FormItemContext';
import omit from '../_util/omit';
import { useInjectRadioGroupContext, useInjectRadioOptionTypeContext } from './context';
import { booleanType, functionType } from '../_util/type';
// CSSINJS
import useStyle from './style';
import { useInjectDisabled } from '../config-provider/DisabledContext';
export var radioProps = function radioProps() {
  return {
    prefixCls: String,
    checked: booleanType(),
    disabled: booleanType(),
    isGroup: booleanType(),
    value: PropTypes.any,
    name: String,
    id: String,
    autofocus: booleanType(),
    onChange: functionType(),
    onFocus: functionType(),
    onBlur: functionType(),
    onClick: functionType(),
    'onUpdate:checked': functionType(),
    'onUpdate:value': functionType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ARadio',
  inheritAttrs: false,
  props: radioProps(),
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      expose = _ref.expose,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var formItemContext = useInjectFormItemContext();
    var formItemInputContext = FormItemInputContext.useInject();
    var radioOptionTypeContext = useInjectRadioOptionTypeContext();
    var radioGroupContext = useInjectRadioGroupContext();
    var vcCheckbox = ref();
    var _useConfigInject = useConfigInject('radio', props),
      radioPrefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      disabled = _useConfigInject.disabled;
    var prefixCls = computed(function () {
      return (radioGroupContext === null || radioGroupContext === void 0 ? void 0 : radioGroupContext.optionType.value) === 'button' || radioOptionTypeContext === 'button' ? "".concat(radioPrefixCls.value, "-button") : radioPrefixCls.value;
    });
    var contextDisabled = useInjectDisabled();
    // Style
    var _useStyle = useStyle(radioPrefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var focus = function focus() {
      vcCheckbox.value.focus();
    };
    var blur = function blur() {
      vcCheckbox.value.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleChange = function handleChange(event) {
      var targetChecked = event.target.checked;
      emit('update:checked', targetChecked);
      emit('update:value', targetChecked);
      emit('change', event);
      formItemContext.onFieldChange();
    };
    var onChange = function onChange(e) {
      emit('change', e);
      if (radioGroupContext && radioGroupContext.onChange) {
        radioGroupContext.onChange(e);
      }
    };
    return function () {
      var _classNames;
      var _a;
      var radioGroup = radioGroupContext;
      var customizePrefixCls = props.prefixCls,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        restProps = __rest(props, ["prefixCls", "id"]);
      var rProps = _extends(_extends({
        prefixCls: prefixCls.value,
        id: id
      }, omit(restProps, ['onUpdate:checked', 'onUpdate:value'])), {
        disabled: (_a = disabled.value) !== null && _a !== void 0 ? _a : contextDisabled.value
      });
      if (radioGroup) {
        rProps.name = radioGroup.name.value;
        rProps.onChange = onChange;
        rProps.checked = props.value === radioGroup.value.value;
        rProps.disabled = props.disabled || radioGroup.disabled.value;
      } else {
        rProps.onChange = handleChange;
      }
      var wrapperClassString = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-wrapper"), true), _defineProperty(_classNames, "".concat(prefixCls.value, "-wrapper-checked"), rProps.checked), _defineProperty(_classNames, "".concat(prefixCls.value, "-wrapper-disabled"), rProps.disabled), _defineProperty(_classNames, "".concat(prefixCls.value, "-wrapper-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, "".concat(prefixCls.value, "-wrapper-in-form-item"), formItemInputContext.isFormItemInput), _classNames), attrs.class, hashId.value);
      return wrapSSR(_createVNode("label", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": wrapperClassString
      }), [_createVNode(VcCheckbox, _objectSpread(_objectSpread({}, rProps), {}, {
        "type": "radio",
        "ref": vcCheckbox
      }), null), slots.default && _createVNode("span", null, [slots.default()])]));
    };
  }
});