import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { createVNode as _createVNode } from "vue";
import { defineComponent } from 'vue';
import Radio, { radioProps } from './Radio';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { useProvideRadioOptionTypeContext } from './context';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ARadioButton',
  inheritAttrs: false,
  props: radioProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('radio', props),
      prefixCls = _useConfigInject.prefixCls;
    useProvideRadioOptionTypeContext('button');
    return function () {
      var _a;
      return _createVNode(Radio, _objectSpread(_objectSpread(_objectSpread({}, attrs), props), {}, {
        "prefixCls": prefixCls.value
      }), {
        default: function _default() {
          return [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)];
        }
      });
    };
  }
});