import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { defineComponent, computed } from 'vue';
import PropTypes from '../_util/vue-types';
import CheckCircleFilled from "@ant-design/icons-vue/es/icons/CheckCircleFilled";
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import ExclamationCircleFilled from "@ant-design/icons-vue/es/icons/ExclamationCircleFilled";
import WarningFilled from "@ant-design/icons-vue/es/icons/WarningFilled";
import noFound from './noFound';
import serverError from './serverError';
import unauthorized from './unauthorized';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import classNames from '../_util/classNames';
import useStyle from './style';
export var IconMap = {
  success: CheckCircleFilled,
  error: CloseCircleFilled,
  info: ExclamationCircleFilled,
  warning: WarningFilled
};
export var ExceptionMap = {
  '404': noFound,
  '500': serverError,
  '403': unauthorized
};
// ExceptionImageMap keys
var ExceptionStatus = Object.keys(ExceptionMap);
export var resultProps = function resultProps() {
  return {
    prefixCls: String,
    icon: PropTypes.any,
    status: {
      type: [Number, String],
      default: 'info'
    },
    title: PropTypes.any,
    subTitle: PropTypes.any,
    extra: PropTypes.any
  };
};
var renderIcon = function renderIcon(prefixCls, _ref) {
  var status = _ref.status,
    icon = _ref.icon;
  if (ExceptionStatus.includes("".concat(status))) {
    var SVGComponent = ExceptionMap[status];
    return _createVNode("div", {
      "class": "".concat(prefixCls, "-icon ").concat(prefixCls, "-image")
    }, [_createVNode(SVGComponent, null, null)]);
  }
  var IconComponent = IconMap[status];
  var iconNode = icon || _createVNode(IconComponent, null, null);
  return _createVNode("div", {
    "class": "".concat(prefixCls, "-icon")
  }, [iconNode]);
};
var renderExtra = function renderExtra(prefixCls, extra) {
  return extra && _createVNode("div", {
    "class": "".concat(prefixCls, "-extra")
  }, [extra]);
};
var Result = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AResult',
  inheritAttrs: false,
  props: resultProps(),
  slots: ['title', 'subTitle', 'icon', 'extra'],
  setup: function setup(props, _ref2) {
    var slots = _ref2.slots,
      attrs = _ref2.attrs;
    var _useConfigInject = useConfigInject('result', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var className = computed(function () {
      return classNames(prefixCls.value, hashId.value, "".concat(prefixCls.value, "-").concat(props.status), _defineProperty({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'));
    });
    return function () {
      var _a, _b, _c, _d, _e, _f, _g, _h;
      var title = (_a = props.title) !== null && _a !== void 0 ? _a : (_b = slots.title) === null || _b === void 0 ? void 0 : _b.call(slots);
      var subTitle = (_c = props.subTitle) !== null && _c !== void 0 ? _c : (_d = slots.subTitle) === null || _d === void 0 ? void 0 : _d.call(slots);
      var icon = (_e = props.icon) !== null && _e !== void 0 ? _e : (_f = slots.icon) === null || _f === void 0 ? void 0 : _f.call(slots);
      var extra = (_g = props.extra) !== null && _g !== void 0 ? _g : (_h = slots.extra) === null || _h === void 0 ? void 0 : _h.call(slots);
      var pre = prefixCls.value;
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": [className.value, attrs.class]
      }), [renderIcon(pre, {
        status: props.status,
        icon: icon
      }), _createVNode("div", {
        "class": "".concat(pre, "-title")
      }, [title]), subTitle && _createVNode("div", {
        "class": "".concat(pre, "-subtitle")
      }, [subTitle]), renderExtra(pre, extra), slots.default && _createVNode("div", {
        "class": "".concat(pre, "-content")
      }, [slots.default()])]));
    };
  }
});
/* add resource */
Result.PRESENTED_IMAGE_403 = ExceptionMap[403];
Result.PRESENTED_IMAGE_404 = ExceptionMap[404];
Result.PRESENTED_IMAGE_500 = ExceptionMap[500];
/* istanbul ignore next */
Result.install = function (app) {
  app.component(Result.name, Result);
  return app;
};
export default Result;