import { createVNode as _createVNode } from "vue";
import { addClass, removeClass } from '../../vc-util/Dom/class';
import { onBeforeUnmount, nextTick, Transition, watch, defineComponent, computed, ref } from 'vue';
import { anyType } from '../../_util/type';
var calcThumbStyle = function calcThumbStyle(targetElement) {
  return targetElement ? {
    left: targetElement.offsetLeft,
    right: targetElement.parentElement.clientWidth - targetElement.clientWidth - targetElement.offsetLeft,
    width: targetElement.clientWidth
  } : null;
};
var toPX = function toPX(value) {
  return value !== undefined ? "".concat(value, "px") : undefined;
};
var MotionThumb = defineComponent({
  props: {
    value: anyType(),
    getValueIndex: anyType(),
    prefixCls: anyType(),
    motionName: anyType(),
    onMotionStart: anyType(),
    onMotionEnd: anyType(),
    direction: anyType(),
    containerRef: anyType()
  },
  emits: ['motionStart', 'motionEnd'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit;
    var thumbRef = ref();
    // =========================== Effect ===========================
    var findValueElement = function findValueElement(val) {
      var _a;
      var index = props.getValueIndex(val);
      var ele = (_a = props.containerRef.value) === null || _a === void 0 ? void 0 : _a.querySelectorAll(".".concat(props.prefixCls, "-item"))[index];
      return (ele === null || ele === void 0 ? void 0 : ele.offsetParent) && ele;
    };
    var prevStyle = ref(null);
    var nextStyle = ref(null);
    watch(function () {
      return props.value;
    }, function (value, prevValue) {
      var prev = findValueElement(prevValue);
      var next = findValueElement(value);
      var calcPrevStyle = calcThumbStyle(prev);
      var calcNextStyle = calcThumbStyle(next);
      prevStyle.value = calcPrevStyle;
      nextStyle.value = calcNextStyle;
      if (prev && next) {
        emit('motionStart');
      } else {
        emit('motionEnd');
      }
    }, {
      flush: 'post'
    });
    var thumbStart = computed(function () {
      var _a, _b;
      return props.direction === 'rtl' ? toPX(-((_a = prevStyle.value) === null || _a === void 0 ? void 0 : _a.right)) : toPX((_b = prevStyle.value) === null || _b === void 0 ? void 0 : _b.left);
    });
    var thumbActive = computed(function () {
      var _a, _b;
      return props.direction === 'rtl' ? toPX(-((_a = nextStyle.value) === null || _a === void 0 ? void 0 : _a.right)) : toPX((_b = nextStyle.value) === null || _b === void 0 ? void 0 : _b.left);
    });
    // =========================== Motion ===========================
    var timeid;
    var onAppearStart = function onAppearStart(el) {
      clearTimeout(timeid);
      nextTick(function () {
        if (el) {
          el.style.transform = "translateX(var(--thumb-start-left))";
          el.style.width = "var(--thumb-start-width)";
        }
      });
    };
    var onAppearActive = function onAppearActive(el) {
      timeid = setTimeout(function () {
        if (el) {
          addClass(el, "".concat(props.motionName, "-appear-active"));
          el.style.transform = "translateX(var(--thumb-active-left))";
          el.style.width = "var(--thumb-active-width)";
        }
      });
    };
    var onAppearEnd = function onAppearEnd(el) {
      prevStyle.value = null;
      nextStyle.value = null;
      if (el) {
        el.style.transform = null;
        el.style.width = null;
        removeClass(el, "".concat(props.motionName, "-appear-active"));
      }
      emit('motionEnd');
    };
    var mergedStyle = computed(function () {
      var _a, _b;
      return {
        '--thumb-start-left': thumbStart.value,
        '--thumb-start-width': toPX((_a = prevStyle.value) === null || _a === void 0 ? void 0 : _a.width),
        '--thumb-active-left': thumbActive.value,
        '--thumb-active-width': toPX((_b = nextStyle.value) === null || _b === void 0 ? void 0 : _b.width)
      };
    });
    onBeforeUnmount(function () {
      clearTimeout(timeid);
    });
    return function () {
      // It's little ugly which should be refactor when @umi/test update to latest jsdom
      var motionProps = {
        ref: thumbRef,
        style: mergedStyle.value,
        class: ["".concat(props.prefixCls, "-thumb")]
      };
      if (process.env.NODE_ENV === 'test') {
        motionProps['data-test-style'] = JSON.stringify(mergedStyle.value);
      }
      return _createVNode(Transition, {
        "appear": true,
        "onBeforeEnter": onAppearStart,
        "onEnter": onAppearActive,
        "onAfterEnter": onAppearEnd
      }, {
        default: function _default() {
          return [!prevStyle.value || !nextStyle.value ? null : _createVNode("div", motionProps, null)];
        }
      });
    };
  }
});
export default MotionThumb;