import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { defineComponent, shallowRef, computed } from 'vue';
import classNames from '../../_util/classNames';
import useConfigInject from '../../config-provider/hooks/useConfigInject';
import { initDefaultProps } from '../../_util/props-util';
import useStyle from '../style';
import { functionType, someType, arrayType, booleanType, stringType } from '../../_util/type';
import MotionThumb from './MotionThumb';
function normalizeOptions(options) {
  return options.map(function (option) {
    if (_typeof(option) === 'object' && option !== null) {
      return option;
    }
    return {
      label: option === null || option === void 0 ? void 0 : option.toString(),
      title: option === null || option === void 0 ? void 0 : option.toString(),
      value: option
    };
  });
}
export var segmentedProps = function segmentedProps() {
  return {
    prefixCls: String,
    options: arrayType(),
    block: booleanType(),
    disabled: booleanType(),
    size: stringType(),
    value: _extends(_extends({}, someType([String, Number])), {
      required: true
    }),
    motionName: String,
    onChange: functionType(),
    'onUpdate:value': functionType()
  };
};
var SegmentedOption = function SegmentedOption(props, _ref) {
  var slots = _ref.slots,
    emit = _ref.emit;
  var value = props.value,
    disabled = props.disabled,
    payload = props.payload,
    title = props.title,
    prefixCls = props.prefixCls,
    _props$label = props.label,
    label = _props$label === void 0 ? slots.label : _props$label,
    checked = props.checked,
    className = props.className;
  var handleChange = function handleChange(event) {
    if (disabled) {
      return;
    }
    emit('change', event, value);
  };
  return _createVNode("label", {
    "class": classNames(_defineProperty({}, "".concat(prefixCls, "-item-disabled"), disabled), className)
  }, [_createVNode("input", {
    "class": "".concat(prefixCls, "-item-input"),
    "type": "radio",
    "disabled": disabled,
    "checked": checked,
    "onChange": handleChange
  }, null), _createVNode("div", {
    "class": "".concat(prefixCls, "-item-label"),
    "title": typeof title === 'string' ? title : ''
  }, [typeof label === 'function' ? label({
    value: value,
    disabled: disabled,
    payload: payload,
    title: title
  }) : label])]);
};
SegmentedOption.inheritAttrs = false;
export default defineComponent({
  name: 'ASegmented',
  inheritAttrs: false,
  props: initDefaultProps(segmentedProps(), {
    options: [],
    motionName: 'thumb-motion'
  }),
  slots: ['label'],
  setup: function setup(props, _ref2) {
    var emit = _ref2.emit,
      slots = _ref2.slots,
      attrs = _ref2.attrs;
    var _useConfigInject = useConfigInject('segmented', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var rootRef = shallowRef();
    var thumbShow = shallowRef(false);
    var segmentedOptions = computed(function () {
      return normalizeOptions(props.options);
    });
    var handleChange = function handleChange(_event, val) {
      if (props.disabled) {
        return;
      }
      emit('update:value', val);
      emit('change', val);
    };
    return function () {
      var _classNames2;
      var pre = prefixCls.value;
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": classNames(pre, (_classNames2 = {}, _defineProperty(_classNames2, hashId.value, true), _defineProperty(_classNames2, "".concat(pre, "-block"), props.block), _defineProperty(_classNames2, "".concat(pre, "-disabled"), props.disabled), _defineProperty(_classNames2, "".concat(pre, "-lg"), size.value == 'large'), _defineProperty(_classNames2, "".concat(pre, "-sm"), size.value == 'small'), _defineProperty(_classNames2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classNames2), attrs.class),
        "ref": rootRef
      }), [_createVNode("div", {
        "class": "".concat(pre, "-group")
      }, [_createVNode(MotionThumb, {
        "containerRef": rootRef,
        "prefixCls": pre,
        "value": props.value,
        "motionName": "".concat(pre, "-").concat(props.motionName),
        "direction": direction.value,
        "getValueIndex": function getValueIndex(val) {
          return segmentedOptions.value.findIndex(function (n) {
            return n.value === val;
          });
        },
        "onMotionStart": function onMotionStart() {
          thumbShow.value = true;
        },
        "onMotionEnd": function onMotionEnd() {
          thumbShow.value = false;
        }
      }, null), segmentedOptions.value.map(function (segmentedOption) {
        return _createVNode(SegmentedOption, _objectSpread(_objectSpread({
          "key": segmentedOption.value,
          "prefixCls": pre,
          "checked": segmentedOption.value === props.value,
          "onChange": handleChange
        }, segmentedOption), {}, {
          "className": classNames(segmentedOption.className, "".concat(pre, "-item"), _defineProperty({}, "".concat(pre, "-item-selected"), segmentedOption.value === props.value && !thumbShow.value)),
          "disabled": !!props.disabled || !!segmentedOption.disabled
        }), slots);
      })])]));
    };
  }
});