import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent, textEllipsis } from '../../style';
// ============================== Mixins ==============================
function getItemDisabledStyle(cls, token) {
  return _defineProperty({}, "".concat(cls, ", ").concat(cls, ":hover, ").concat(cls, ":focus"), {
    color: token.colorTextDisabled,
    cursor: 'not-allowed'
  });
}
function getItemSelectedStyle(token) {
  return {
    backgroundColor: token.bgColorSelected,
    boxShadow: token.boxShadow
  };
}
var segmentedTextEllipsisCss = _extends({
  overflow: 'hidden'
}, textEllipsis);
// ============================== Styles ==============================
var genSegmentedStyle = function genSegmentedStyle(token) {
  var _$concat, _$concat2, _$concat3, _extends3;
  var componentCls = token.componentCls;
  return _defineProperty({}, componentCls, _extends(_extends(_extends(_extends(_extends({}, resetComponent(token)), (_extends3 = {
    display: 'inline-block',
    padding: token.segmentedContainerPadding,
    color: token.labelColor,
    backgroundColor: token.bgColor,
    borderRadius: token.borderRadius,
    transition: "all ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut)
  }, _defineProperty(_extends3, "".concat(componentCls, "-group"), {
    position: 'relative',
    display: 'flex',
    alignItems: 'stretch',
    justifyItems: 'flex-start',
    width: '100%'
  }), _defineProperty(_extends3, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), _defineProperty(_extends3, "&".concat(componentCls, "-block"), {
    display: 'flex'
  }), _defineProperty(_extends3, "&".concat(componentCls, "-block ").concat(componentCls, "-item"), {
    flex: 1,
    minWidth: 0
  }), _defineProperty(_extends3, "".concat(componentCls, "-item"), (_$concat = {
    position: 'relative',
    textAlign: 'center',
    cursor: 'pointer',
    transition: "color ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut),
    borderRadius: token.borderRadiusSM,
    '&-selected': _extends(_extends({}, getItemSelectedStyle(token)), {
      color: token.labelColorHover
    }),
    '&::after': {
      content: '""',
      position: 'absolute',
      width: '100%',
      height: '100%',
      top: 0,
      insetInlineStart: 0,
      borderRadius: 'inherit',
      transition: "background-color ".concat(token.motionDurationMid)
    }
  }, _defineProperty(_$concat, "&:hover:not(".concat(componentCls, "-item-selected):not(").concat(componentCls, "-item-disabled)"), {
    color: token.labelColorHover,
    '&::after': {
      backgroundColor: token.bgColorHover
    }
  }), _defineProperty(_$concat, '&-label', _extends({
    minHeight: token.controlHeight - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeight - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontal, "px")
  }, segmentedTextEllipsisCss)), _defineProperty(_$concat, '&-icon + *', {
    marginInlineStart: token.marginSM / 2
  }), _defineProperty(_$concat, '&-input', {
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: 0,
    height: 0,
    opacity: 0,
    pointerEvents: 'none'
  }), _$concat)), _defineProperty(_extends3, "".concat(componentCls, "-thumb"), _extends(_extends({}, getItemSelectedStyle(token)), _defineProperty({
    position: 'absolute',
    insetBlockStart: 0,
    insetInlineStart: 0,
    width: 0,
    height: '100%',
    padding: "".concat(token.paddingXXS, "px 0"),
    borderRadius: token.borderRadiusSM
  }, "& ~ ".concat(componentCls, "-item:not(").concat(componentCls, "-item-selected):not(").concat(componentCls, "-item-disabled)::after"), {
    backgroundColor: 'transparent'
  }))), _defineProperty(_extends3, "&".concat(componentCls, "-lg"), (_$concat2 = {
    borderRadius: token.borderRadiusLG
  }, _defineProperty(_$concat2, "".concat(componentCls, "-item-label"), {
    minHeight: token.controlHeightLG - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeightLG - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontal, "px"),
    fontSize: token.fontSizeLG
  }), _defineProperty(_$concat2, "".concat(componentCls, "-item, ").concat(componentCls, "-thumb"), {
    borderRadius: token.borderRadius
  }), _$concat2)), _defineProperty(_extends3, "&".concat(componentCls, "-sm"), (_$concat3 = {
    borderRadius: token.borderRadiusSM
  }, _defineProperty(_$concat3, "".concat(componentCls, "-item-label"), {
    minHeight: token.controlHeightSM - token.segmentedContainerPadding * 2,
    lineHeight: "".concat(token.controlHeightSM - token.segmentedContainerPadding * 2, "px"),
    padding: "0 ".concat(token.segmentedPaddingHorizontalSM, "px")
  }), _defineProperty(_$concat3, "".concat(componentCls, "-item, ").concat(componentCls, "-thumb"), {
    borderRadius: token.borderRadiusXS
  }), _$concat3)), _extends3)), getItemDisabledStyle("&-disabled ".concat(componentCls, "-item"), token)), getItemDisabledStyle("".concat(componentCls, "-item-disabled"), token)), _defineProperty({}, "".concat(componentCls, "-thumb-motion-appear-active"), {
    transition: "transform ".concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut, ", width ").concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut),
    willChange: 'transform, width'
  })));
};
// ============================== Export ==============================
export default genComponentStyleHook('Segmented', function (token) {
  var lineWidthBold = token.lineWidthBold,
    lineWidth = token.lineWidth,
    colorTextLabel = token.colorTextLabel,
    colorText = token.colorText,
    colorFillSecondary = token.colorFillSecondary,
    colorBgLayout = token.colorBgLayout,
    colorBgElevated = token.colorBgElevated;
  var segmentedToken = mergeToken(token, {
    segmentedPaddingHorizontal: token.controlPaddingHorizontal - lineWidth,
    segmentedPaddingHorizontalSM: token.controlPaddingHorizontalSM - lineWidth,
    segmentedContainerPadding: lineWidthBold,
    labelColor: colorTextLabel,
    labelColorHover: colorText,
    bgColor: colorBgLayout,
    bgColorHover: colorFillSecondary,
    bgColorSelected: colorBgElevated
  });
  return [genSegmentedStyle(segmentedToken)];
});