import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _objectDestructuringEmpty from "@babel/runtime/helpers/esm/objectDestructuringEmpty";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { computed, defineComponent, ref } from 'vue';
import classNames from '../_util/classNames';
import RcSelect, { selectProps as vcSelectProps, Option, OptGroup } from '../vc-select';
import getIcons from './utils/iconUtil';
import PropTypes from '../_util/vue-types';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { DefaultRenderEmpty } from '../config-provider/renderEmpty';
import omit from '../_util/omit';
import { FormItemInputContext, useInjectFormItemContext } from '../form/FormItemContext';
import { getTransitionDirection, getTransitionName } from '../_util/transition';
import { initDefaultProps } from '../_util/props-util';
import { getStatusClassNames, getMergedStatus } from '../_util/statusUtils';
import { stringType, someType, functionType, booleanType } from '../_util/type';
import { useCompactItemContext } from '../space/Compact';
// CSSINJS
import useStyle from './style';
import { useInjectDisabled } from '../config-provider/DisabledContext';
import devWarning from '../vc-util/devWarning';
export var selectProps = function selectProps() {
  return _extends(_extends({}, omit(vcSelectProps(), ['inputIcon', 'mode', 'getInputElement', 'getRawInputElement', 'backfill'])), {
    value: someType([Array, Object, String, Number]),
    defaultValue: someType([Array, Object, String, Number]),
    notFoundContent: PropTypes.any,
    suffixIcon: PropTypes.any,
    itemIcon: PropTypes.any,
    size: stringType(),
    mode: stringType(),
    bordered: booleanType(true),
    transitionName: String,
    choiceTransitionName: stringType(''),
    popupClassName: String,
    /** @deprecated Please use `popupClassName` instead */
    dropdownClassName: String,
    placement: stringType(),
    status: stringType(),
    'onUpdate:value': functionType()
  });
};
var SECRET_COMBOBOX_MODE_DO_NOT_USE = 'SECRET_COMBOBOX_MODE_DO_NOT_USE';
var Select = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASelect',
  Option: Option,
  OptGroup: OptGroup,
  inheritAttrs: false,
  props: initDefaultProps(selectProps(), {
    listHeight: 256,
    listItemHeight: 24
  }),
  SECRET_COMBOBOX_MODE_DO_NOT_USE: SECRET_COMBOBOX_MODE_DO_NOT_USE,
  // emits: ['change', 'update:value', 'blur'],
  slots: ['notFoundContent', 'suffixIcon', 'itemIcon', 'removeIcon', 'clearIcon', 'dropdownRender', 'option', 'placeholder', 'tagRender', 'maxTagPlaceholder', 'optionLabel' // donot use, maybe remove it
  ],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      emit = _ref.emit,
      slots = _ref.slots,
      expose = _ref.expose;
    var selectRef = ref();
    var formItemContext = useInjectFormItemContext();
    var formItemInputContext = FormItemInputContext.useInject();
    var mergedStatus = computed(function () {
      return getMergedStatus(formItemInputContext.status, props.status);
    });
    var focus = function focus() {
      var _a;
      (_a = selectRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = selectRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var scrollTo = function scrollTo(arg) {
      var _a;
      (_a = selectRef.value) === null || _a === void 0 ? void 0 : _a.scrollTo(arg);
    };
    var mode = computed(function () {
      var mode = props.mode;
      if (mode === 'combobox') {
        return undefined;
      }
      if (mode === SECRET_COMBOBOX_MODE_DO_NOT_USE) {
        return 'combobox';
      }
      return mode;
    });
    // ====================== Warning ======================
    if (process.env.NODE_ENV !== 'production') {
      devWarning(!props.dropdownClassName, 'Select', '`dropdownClassName` is deprecated. Please use `popupClassName` instead.');
    }
    var _useConfigInject = useConfigInject('select', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      configProvider = _useConfigInject.configProvider,
      renderEmpty = _useConfigInject.renderEmpty,
      contextSize = _useConfigInject.size,
      getPrefixCls = _useConfigInject.getPrefixCls,
      getPopupContainer = _useConfigInject.getPopupContainer,
      disabled = _useConfigInject.disabled,
      select = _useConfigInject.select;
    var _useCompactItemContex = useCompactItemContext(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    var mergedSize = computed(function () {
      return compactSize.value || contextSize.value;
    });
    var contextDisabled = useInjectDisabled();
    var mergedDisabled = computed(function () {
      var _a;
      return (_a = disabled.value) !== null && _a !== void 0 ? _a : contextDisabled.value;
    });
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var rootPrefixCls = computed(function () {
      return getPrefixCls();
    });
    // ===================== Placement =====================
    var placement = computed(function () {
      if (props.placement !== undefined) {
        return props.placement;
      }
      return direction.value === 'rtl' ? 'bottomRight' : 'bottomLeft';
    });
    var transitionName = computed(function () {
      return getTransitionName(rootPrefixCls.value, getTransitionDirection(placement.value), props.transitionName);
    });
    var mergedClassName = computed(function () {
      var _classNames;
      return classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-lg"), mergedSize.value === 'large'), _defineProperty(_classNames, "".concat(prefixCls.value, "-sm"), mergedSize.value === 'small'), _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, "".concat(prefixCls.value, "-borderless"), !props.bordered), _defineProperty(_classNames, "".concat(prefixCls.value, "-in-form-item"), formItemInputContext.isFormItemInput), _classNames), getStatusClassNames(prefixCls.value, mergedStatus.value, formItemInputContext.hasFeedback), compactItemClassnames.value, hashId.value);
    });
    var triggerChange = function triggerChange() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      emit('update:value', args[0]);
      emit.apply(void 0, ['change'].concat(args));
      formItemContext.onFieldChange();
    };
    var handleBlur = function handleBlur(e) {
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    expose({
      blur: blur,
      focus: focus,
      scrollTo: scrollTo
    });
    var isMultiple = computed(function () {
      return mode.value === 'multiple' || mode.value === 'tags';
    });
    var mergedShowArrow = computed(function () {
      return props.showArrow !== undefined ? props.showArrow : props.loading || !(isMultiple.value || mode.value === 'combobox');
    });
    return function () {
      var _a, _b, _c, _d;
      var notFoundContent = props.notFoundContent,
        _props$listHeight = props.listHeight,
        listHeight = _props$listHeight === void 0 ? 256 : _props$listHeight,
        _props$listItemHeight = props.listItemHeight,
        listItemHeight = _props$listItemHeight === void 0 ? 24 : _props$listItemHeight,
        popupClassName = props.popupClassName,
        dropdownClassName = props.dropdownClassName,
        virtual = props.virtual,
        dropdownMatchSelectWidth = props.dropdownMatchSelectWidth,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        _props$placeholder = props.placeholder,
        placeholder = _props$placeholder === void 0 ? (_a = slots.placeholder) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$placeholder,
        showArrow = props.showArrow;
      var hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      _objectDestructuringEmpty(configProvider);
      // ===================== Empty =====================
      var mergedNotFound;
      if (notFoundContent !== undefined) {
        mergedNotFound = notFoundContent;
      } else if (slots.notFoundContent) {
        mergedNotFound = slots.notFoundContent();
      } else if (mode.value === 'combobox') {
        mergedNotFound = null;
      } else {
        mergedNotFound = (renderEmpty === null || renderEmpty === void 0 ? void 0 : renderEmpty('Select')) || _createVNode(DefaultRenderEmpty, {
          "componentName": "Select"
        }, null);
      }
      // ===================== Icons =====================
      var _getIcons = getIcons(_extends(_extends({}, props), {
          multiple: isMultiple.value,
          prefixCls: prefixCls.value,
          hasFeedback: hasFeedback,
          feedbackIcon: feedbackIcon,
          showArrow: mergedShowArrow.value
        }), slots),
        suffixIcon = _getIcons.suffixIcon,
        itemIcon = _getIcons.itemIcon,
        removeIcon = _getIcons.removeIcon,
        clearIcon = _getIcons.clearIcon;
      var selectProps = omit(props, ['prefixCls', 'suffixIcon', 'itemIcon', 'removeIcon', 'clearIcon', 'size', 'bordered', 'status']);
      var rcSelectRtlDropdownClassName = classNames(popupClassName || dropdownClassName, _defineProperty({}, "".concat(prefixCls.value, "-dropdown-").concat(direction.value), direction.value === 'rtl'), hashId.value);
      return wrapSSR(_createVNode(RcSelect, _objectSpread(_objectSpread(_objectSpread({
        "ref": selectRef,
        "virtual": virtual,
        "dropdownMatchSelectWidth": dropdownMatchSelectWidth
      }, selectProps), attrs), {}, {
        "showSearch": (_b = props.showSearch) !== null && _b !== void 0 ? _b : (_c = select === null || select === void 0 ? void 0 : select.value) === null || _c === void 0 ? void 0 : _c.showSearch,
        "placeholder": placeholder,
        "listHeight": listHeight,
        "listItemHeight": listItemHeight,
        "mode": mode.value,
        "prefixCls": prefixCls.value,
        "direction": direction.value,
        "inputIcon": suffixIcon,
        "menuItemSelectedIcon": itemIcon,
        "removeIcon": removeIcon,
        "clearIcon": clearIcon,
        "notFoundContent": mergedNotFound,
        "class": [mergedClassName.value, attrs.class],
        "getPopupContainer": getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        "dropdownClassName": rcSelectRtlDropdownClassName,
        "onChange": triggerChange,
        "onBlur": handleBlur,
        "id": id,
        "dropdownRender": selectProps.dropdownRender || slots.dropdownRender,
        "transitionName": transitionName.value,
        "children": (_d = slots.default) === null || _d === void 0 ? void 0 : _d.call(slots),
        "tagRender": props.tagRender || slots.tagRender,
        "optionLabelRender": slots.optionLabel,
        "maxTagPlaceholder": props.maxTagPlaceholder || slots.maxTagPlaceholder,
        "showArrow": hasFeedback || showArrow,
        "disabled": mergedDisabled.value
      }), {
        option: slots.option
      }));
    };
  }
});
/* istanbul ignore next */
Select.install = function (app) {
  app.component(Select.name, Select);
  app.component(Select.Option.displayName, Select.Option);
  app.component(Select.OptGroup.displayName, Select.OptGroup);
  return app;
};
export var SelectOption = Select.Option;
export var SelectOptGroup = Select.OptGroup;
export default Select;