import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import genDropdownStyle from './dropdown';
import genMultipleStyle from './multiple';
import genSingleStyle from './single';
import { resetComponent, resetIcon, textEllipsis } from '../../style';
import { genCompactItemStyle } from '../../style/compact-item';
// ============================= Selector =============================
var genSelectorStyle = function genSelectorStyle(token) {
  var _$concat, _ref;
  var componentCls = token.componentCls;
  return _ref = {
    position: 'relative',
    backgroundColor: token.colorBgContainer,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
    transition: "all ".concat(token.motionDurationMid, " ").concat(token.motionEaseInOut),
    input: {
      cursor: 'pointer'
    }
  }, _defineProperty(_ref, "".concat(componentCls, "-show-search&"), {
    cursor: 'text',
    input: {
      cursor: 'auto',
      color: 'inherit'
    }
  }), _defineProperty(_ref, "".concat(componentCls, "-disabled&"), (_$concat = {
    color: token.colorTextDisabled,
    background: token.colorBgContainerDisabled,
    cursor: 'not-allowed'
  }, _defineProperty(_$concat, "".concat(componentCls, "-multiple&"), {
    background: token.colorBgContainerDisabled
  }), _defineProperty(_$concat, "input", {
    cursor: 'not-allowed'
  }), _$concat)), _ref;
};
// ============================== Status ==============================
var genStatusStyle = function genStatusStyle(rootSelectCls, token) {
  var _extends2;
  var overwriteDefaultBorder = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var componentCls = token.componentCls,
    borderHoverColor = token.borderHoverColor,
    outlineColor = token.outlineColor,
    antCls = token.antCls;
  var overwriteStyle = overwriteDefaultBorder ? _defineProperty({}, "".concat(componentCls, "-selector"), {
    borderColor: borderHoverColor
  }) : {};
  return _defineProperty({}, rootSelectCls, _defineProperty({}, "&:not(".concat(componentCls, "-disabled):not(").concat(componentCls, "-customize-input):not(").concat(antCls, "-pagination-size-changer)"), _extends(_extends({}, overwriteStyle), (_extends2 = {}, _defineProperty(_extends2, "".concat(componentCls, "-focused& ").concat(componentCls, "-selector"), {
    borderColor: borderHoverColor,
    boxShadow: "0 0 0 ".concat(token.controlOutlineWidth, "px ").concat(outlineColor),
    borderInlineEndWidth: "".concat(token.controlLineWidth, "px !important"),
    outline: 0
  }), _defineProperty(_extends2, "&:hover ".concat(componentCls, "-selector"), {
    borderColor: borderHoverColor,
    borderInlineEndWidth: "".concat(token.controlLineWidth, "px !important")
  }), _extends2))));
};
// ============================== Styles ==============================
// /* Reset search input style */
var getSearchInputWithoutBorderStyle = function getSearchInputWithoutBorderStyle(token) {
  var componentCls = token.componentCls;
  return _defineProperty({}, "".concat(componentCls, "-selection-search-input"), {
    margin: 0,
    padding: 0,
    background: 'transparent',
    border: 'none',
    outline: 'none',
    appearance: 'none',
    '&::-webkit-search-cancel-button': {
      display: 'none',
      '-webkit-appearance': 'none'
    }
  });
};
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _extends3, _extends4, _ref5;
  var componentCls = token.componentCls,
    inputPaddingHorizontalBase = token.inputPaddingHorizontalBase,
    iconCls = token.iconCls;
  return _ref5 = {}, _defineProperty(_ref5, componentCls, _extends(_extends({}, resetComponent(token)), (_extends4 = {
    position: 'relative',
    display: 'inline-block',
    cursor: 'pointer'
  }, _defineProperty(_extends4, "&:not(".concat(componentCls, "-customize-input) ").concat(componentCls, "-selector"), _extends(_extends({}, genSelectorStyle(token)), getSearchInputWithoutBorderStyle(token))), _defineProperty(_extends4, "".concat(componentCls, "-selection-item"), _extends({
    flex: 1,
    fontWeight: 'normal'
  }, textEllipsis)), _defineProperty(_extends4, "".concat(componentCls, "-selection-placeholder"), _extends(_extends({}, textEllipsis), {
    flex: 1,
    color: token.colorTextPlaceholder,
    pointerEvents: 'none'
  })), _defineProperty(_extends4, "".concat(componentCls, "-arrow"), _extends(_extends({}, resetIcon()), (_extends3 = {
    position: 'absolute',
    top: '50%',
    insetInlineStart: 'auto',
    insetInlineEnd: inputPaddingHorizontalBase,
    height: token.fontSizeIcon,
    marginTop: -token.fontSizeIcon / 2,
    color: token.colorTextQuaternary,
    fontSize: token.fontSizeIcon,
    lineHeight: 1,
    textAlign: 'center',
    pointerEvents: 'none',
    display: 'flex',
    alignItems: 'center'
  }, _defineProperty(_extends3, iconCls, _defineProperty({
    verticalAlign: 'top',
    transition: "transform ".concat(token.motionDurationSlow),
    '> svg': {
      verticalAlign: 'top'
    }
  }, "&:not(".concat(componentCls, "-suffix)"), {
    pointerEvents: 'auto'
  })), _defineProperty(_extends3, "".concat(componentCls, "-disabled &"), {
    cursor: 'not-allowed'
  }), _defineProperty(_extends3, '> *:not(:last-child)', {
    marginInlineEnd: 8 // FIXME: magic
  }), _extends3))), _defineProperty(_extends4, "".concat(componentCls, "-clear"), {
    position: 'absolute',
    top: '50%',
    insetInlineStart: 'auto',
    insetInlineEnd: inputPaddingHorizontalBase,
    zIndex: 1,
    display: 'inline-block',
    width: token.fontSizeIcon,
    height: token.fontSizeIcon,
    marginTop: -token.fontSizeIcon / 2,
    color: token.colorTextQuaternary,
    fontSize: token.fontSizeIcon,
    fontStyle: 'normal',
    lineHeight: 1,
    textAlign: 'center',
    textTransform: 'none',
    background: token.colorBgContainer,
    cursor: 'pointer',
    opacity: 0,
    transition: "color ".concat(token.motionDurationMid, " ease, opacity ").concat(token.motionDurationSlow, " ease"),
    textRendering: 'auto',
    '&:before': {
      display: 'block'
    },
    '&:hover': {
      color: token.colorTextTertiary
    }
  }), _defineProperty(_extends4, '&:hover', _defineProperty({}, "".concat(componentCls, "-clear"), {
    opacity: 1
  })), _extends4))), _defineProperty(_ref5, "".concat(componentCls, "-has-feedback"), _defineProperty({}, "".concat(componentCls, "-clear"), {
    insetInlineEnd: inputPaddingHorizontalBase + token.fontSize + token.paddingXXS
  })), _ref5;
};
// ============================== Styles ==============================
var genSelectStyle = function genSelectStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls;
  return [_defineProperty({}, componentCls, (_componentCls = {}, _defineProperty(_componentCls, "&-borderless ".concat(componentCls, "-selector"), {
    backgroundColor: "transparent !important",
    borderColor: "transparent !important",
    boxShadow: "none !important"
  }), _defineProperty(_componentCls, "&".concat(componentCls, "-in-form-item"), {
    width: '100%'
  }), _componentCls)),
  // =====================================================
  // ==                       LTR                       ==
  // =====================================================
  // Base
  genBaseStyle(token),
  // Single
  genSingleStyle(token),
  // Multiple
  genMultipleStyle(token),
  // Dropdown
  genDropdownStyle(token), // =====================================================
  // ==                       RTL                       ==
  // =====================================================
  _defineProperty({}, "".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }),
  // =====================================================
  // ==                     Status                      ==
  // =====================================================
  genStatusStyle(componentCls, mergeToken(token, {
    borderHoverColor: token.colorPrimaryHover,
    outlineColor: token.controlOutline
  })), genStatusStyle("".concat(componentCls, "-status-error"), mergeToken(token, {
    borderHoverColor: token.colorErrorHover,
    outlineColor: token.colorErrorOutline
  }), true), genStatusStyle("".concat(componentCls, "-status-warning"), mergeToken(token, {
    borderHoverColor: token.colorWarningHover,
    outlineColor: token.colorWarningOutline
  }), true),
  // =====================================================
  // ==             Space Compact                       ==
  // =====================================================
  genCompactItemStyle(token, {
    borderElCls: "".concat(componentCls, "-selector"),
    focusElCls: "".concat(componentCls, "-focused")
  })];
};
// ============================== Export ==============================
export default genComponentStyleHook('Select', function (token, _ref8) {
  var rootPrefixCls = _ref8.rootPrefixCls;
  var selectToken = mergeToken(token, {
    rootPrefixCls: rootPrefixCls,
    inputPaddingHorizontalBase: token.paddingSM - 1
  });
  return [genSelectStyle(selectToken)];
}, function (token) {
  return {
    zIndexPopup: token.zIndexPopupBase + 50
  };
});