import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resetComponent } from '../../style';
import { mergeToken } from '../../theme/internal';
function genSizeStyle(token, suffix) {
  var _extends2, _$concat, _$concat2, _$concat$concat;
  var componentCls = token.componentCls,
    inputPaddingHorizontalBase = token.inputPaddingHorizontalBase,
    borderRadius = token.borderRadius;
  var selectHeightWithoutBorder = token.controlHeight - token.lineWidth * 2;
  var selectionItemPadding = Math.ceil(token.fontSize * 1.25);
  var suffixCls = suffix ? "".concat(componentCls, "-").concat(suffix) : '';
  return _defineProperty({}, "".concat(componentCls, "-single").concat(suffixCls), (_$concat$concat = {
    fontSize: token.fontSize
  }, _defineProperty(_$concat$concat, "".concat(componentCls, "-selector"), _extends(_extends({}, resetComponent(token)), (_extends2 = {
    display: 'flex',
    borderRadius: borderRadius
  }, _defineProperty(_extends2, "".concat(componentCls, "-selection-search"), {
    position: 'absolute',
    top: 0,
    insetInlineStart: inputPaddingHorizontalBase,
    insetInlineEnd: inputPaddingHorizontalBase,
    bottom: 0,
    '&-input': {
      width: '100%'
    }
  }), _defineProperty(_extends2, "\n          ".concat(componentCls, "-selection-item,\n          ").concat(componentCls, "-selection-placeholder\n        "), {
    padding: 0,
    lineHeight: "".concat(selectHeightWithoutBorder, "px"),
    transition: "all ".concat(token.motionDurationSlow),
    // Firefox inline-block position calculation is not same as Chrome & Safari. Patch this:
    '@supports (-moz-appearance: meterbar)': {
      lineHeight: "".concat(selectHeightWithoutBorder, "px")
    }
  }), _defineProperty(_extends2, "".concat(componentCls, "-selection-item"), {
    position: 'relative',
    userSelect: 'none'
  }), _defineProperty(_extends2, "".concat(componentCls, "-selection-placeholder"), {
    transition: 'none',
    pointerEvents: 'none'
  }), _defineProperty(_extends2, ['&:after', /* For '' value baseline align */"".concat(componentCls, "-selection-item:after"), /* For undefined value baseline align */"".concat(componentCls, "-selection-placeholder:after")].join(','), {
    display: 'inline-block',
    width: 0,
    visibility: 'hidden',
    content: '"\\a0"'
  }), _extends2))), _defineProperty(_$concat$concat, "\n        &".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-item,\n        &").concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-placeholder\n      "), {
    paddingInlineEnd: selectionItemPadding
  }), _defineProperty(_$concat$concat, "&".concat(componentCls, "-open ").concat(componentCls, "-selection-item"), {
    color: token.colorTextPlaceholder
  }), _defineProperty(_$concat$concat, "&:not(".concat(componentCls, "-customize-input)"), _defineProperty({}, "".concat(componentCls, "-selector"), (_$concat = {
    width: '100%',
    height: token.controlHeight,
    padding: "0 ".concat(inputPaddingHorizontalBase, "px")
  }, _defineProperty(_$concat, "".concat(componentCls, "-selection-search-input"), {
    height: selectHeightWithoutBorder
  }), _defineProperty(_$concat, '&:after', {
    lineHeight: "".concat(selectHeightWithoutBorder, "px")
  }), _$concat))), _defineProperty(_$concat$concat, "&".concat(componentCls, "-customize-input"), _defineProperty({}, "".concat(componentCls, "-selector"), (_$concat2 = {
    '&:after': {
      display: 'none'
    }
  }, _defineProperty(_$concat2, "".concat(componentCls, "-selection-search"), {
    position: 'static',
    width: '100%'
  }), _defineProperty(_$concat2, "".concat(componentCls, "-selection-placeholder"), {
    position: 'absolute',
    insetInlineStart: 0,
    insetInlineEnd: 0,
    padding: "0 ".concat(inputPaddingHorizontalBase, "px"),
    '&:after': {
      display: 'none'
    }
  }), _$concat2))), _$concat$concat));
}
export default function genSingleStyle(token) {
  var _not$concat2;
  var componentCls = token.componentCls;
  var inputPaddingHorizontalSM = token.controlPaddingHorizontalSM - token.lineWidth;
  return [genSizeStyle(token),
  // ======================== Small ========================
  // Shared
  genSizeStyle(mergeToken(token, {
    controlHeight: token.controlHeightSM,
    borderRadius: token.borderRadiusSM
  }), 'sm'), // padding
  _defineProperty({}, "".concat(componentCls, "-single").concat(componentCls, "-sm"), _defineProperty({}, "&:not(".concat(componentCls, "-customize-input)"), (_not$concat2 = {}, _defineProperty(_not$concat2, "".concat(componentCls, "-selection-search"), {
    insetInlineStart: inputPaddingHorizontalSM,
    insetInlineEnd: inputPaddingHorizontalSM
  }), _defineProperty(_not$concat2, "".concat(componentCls, "-selector"), {
    padding: "0 ".concat(inputPaddingHorizontalSM, "px")
  }), _defineProperty(_not$concat2, "&".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-search"), {
    insetInlineEnd: inputPaddingHorizontalSM + token.fontSize * 1.5
  }), _defineProperty(_not$concat2, "\n            &".concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-item,\n            &").concat(componentCls, "-show-arrow ").concat(componentCls, "-selection-placeholder\n          "), {
    paddingInlineEnd: token.fontSize * 1.5
  }), _not$concat2))),
  // ======================== Large ========================
  // Shared
  genSizeStyle(mergeToken(token, {
    controlHeight: token.controlHeightLG,
    fontSize: token.fontSizeLG,
    borderRadius: token.borderRadiusLG
  }), 'lg')];
}